/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.stats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Arrays;
import org.locationtech.geomesa.utils.stats.BinnedArray;
import org.locationtech.geomesa.utils.stats.BinnedArray$;
import org.locationtech.geomesa.utils.stats.Histogram$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$class;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001B\u0001\u0003\u00015\u0011\u0011\u0002S5ti><'/Y7\u000b\u0005\r!\u0011!B:uCR\u001c(BA\u0003\u0007\u0003\u0015)H/\u001b7t\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\u00059Q5\u0003\u0002\u0001\u0010+e\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005\u0011\u0019F/\u0019;\u0011\u0005i\tS\"A\u000e\u000b\u0005qi\u0012\u0001D:dC2\fGn\\4hS:<'B\u0001\u0010 \u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0011\u0002\u0007\r|W.\u0003\u0002#7\tYA*\u0019>z\u0019><w-\u001b8h\u0011!!\u0003A!b\u0001\n\u0003)\u0013aA:giV\ta\u0005\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u000511/[7qY\u0016T!a\u000b\u0017\u0002\u000f\u0019,\u0017\r^;sK*\u0011QFC\u0001\b_B,gnZ5t\u0013\ty\u0003FA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016D\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0005g\u001a$\b\u0005\u0003\u00054\u0001\t\u0015\r\u0011\"\u00015\u0003!\u0001(o\u001c9feRLX#A\u001b\u0011\u0005YJdB\u0001\t8\u0013\tA\u0014#\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u0012\u0011!i\u0004A!A!\u0002\u0013)\u0014!\u00039s_B,'\u000f^=!\u0011!y\u0004A!A!\u0002\u0013\u0001\u0015aC5oSRL\u0017\r\u001c\"j]N\u0004\"\u0001E!\n\u0005\t\u000b\"aA%oi\"AA\t\u0001B\u0001B\u0003%Q)\u0001\tj]&$\u0018.\u00197F]\u0012\u0004x.\u001b8ugB!\u0001C\u0012%I\u0013\t9\u0015C\u0001\u0004UkBdWM\r\t\u0003\u0013*c\u0001\u0001B\u0003L\u0001\t\u0007AJA\u0001U#\ti\u0005\u000b\u0005\u0002\u0011\u001d&\u0011q*\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001\u0012+\u0003\u0002S#\t\u0019\u0011I\\=\t\u0011Q\u0003!Q1A\u0005\u0004U\u000b\u0001\u0002Z3gCVdGo]\u000b\u0002-B\u0019qK\u0017%\u000f\u0005YA\u0016BA-\u0003\u0003\u0019i\u0015N\\'bq&\u00111\f\u0018\u0002\u000f\u001b&tW*\u0019=EK\u001a\fW\u000f\u001c;t\u0015\tI&\u0001\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003W\u0003%!WMZ1vYR\u001c\b\u0005\u0003\u0005a\u0001\t\u0015\r\u0011b\u0001b\u0003\t\u0019G/F\u0001c!\r\u0019g\rS\u0007\u0002I*\u0011Q-E\u0001\be\u00164G.Z2u\u0013\t9GM\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011!I\u0007A!A!\u0002\u0013\u0011\u0017aA2uA!)1\u000e\u0001C\u0001Y\u00061A(\u001b8jiz\"R!\\9sgR$2A\\8q!\r1\u0002\u0001\u0013\u0005\u0006)*\u0004\u001dA\u0016\u0005\u0006A*\u0004\u001dA\u0019\u0005\u0006I)\u0004\rA\n\u0005\u0006g)\u0004\r!\u000e\u0005\u0006\u007f)\u0004\r\u0001\u0011\u0005\u0006\t*\u0004\r!R\u0003\u0005m\u0002\u0001cNA\u0001T\u0011\u001dA\bA1A\u0005\ne\f\u0011![\u000b\u0002\u0001\"11\u0010\u0001Q\u0001\n\u0001\u000b!!\u001b\u0011\t\u0011u\u0004\u0001\u0019!C\u0001\u0005y\fAAY5ogV\tq\u0010\u0005\u0003\u0017\u0003\u0003A\u0015bAA\u0002\u0005\tY!)\u001b8oK\u0012\f%O]1z\u0011)\t9\u0001\u0001a\u0001\n\u0003\u0011\u0011\u0011B\u0001\tE&t7o\u0018\u0013fcR!\u00111BA\t!\r\u0001\u0012QB\u0005\u0004\u0003\u001f\t\"\u0001B+oSRD\u0011\"a\u0005\u0002\u0006\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0018\u0001\u0001\u000b\u0015B@\u0002\u000b\tLgn\u001d\u0011\t\r\u0005m\u0001\u0001\"\u0001z\u0003\u0019aWM\\4uQ\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012a\u00033je\u0016\u001cG/\u00138eKb$2\u0001QA\u0012\u0011!\t)#!\bA\u0002\u0005\u001d\u0012!\u0002<bYV,\u0007c\u0001\t\u0002*%\u0019\u00111F\t\u0003\t1{gn\u001a\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003\u001dIg\u000eZ3y\u001f\u001a$2\u0001QA\u001a\u0011\u001d\t)#!\fA\u0002!Cq!a\u000e\u0001\t\u0003\tI$A\u0003d_VtG\u000f\u0006\u0003\u0002(\u0005m\u0002B\u0002=\u00026\u0001\u0007\u0001\tC\u0004\u0002@\u0001!\t!!\u0011\u0002\u00075Lg.F\u0001I\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u0003\n1!\\1y\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\naAY8v]\u0012\u001cX#A#\t\u000f\u0005%\u0003\u0001\"\u0001\u0002PQ\u0019Q)!\u0015\t\ra\fi\u00051\u0001A\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n1\"\\3eS\u0006tg+\u00197vKR\u0019\u0001*!\u0017\t\ra\f\u0019\u00061\u0001A\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\nQ\"\u00193e\u0007>,h\u000e^:Ge>lG\u0003BA\u0006\u0003CBq!a\u0019\u0002\\\u0001\u0007a.A\u0003pi\",'\u000fC\u0004\u0002h\u0001!\t%!\u001b\u0002\u000f=\u00147/\u001a:wKR!\u00111BA6\u0011!\ti'!\u001aA\u0002\u0005=\u0014AA:g!\r9\u0013\u0011O\u0005\u0004\u0003gB#!D*j[BdWMR3biV\u0014X\rC\u0004\u0002x\u0001!\t%!\u001f\u0002\u0013UtwNY:feZ,G\u0003BA\u0006\u0003wB\u0001\"!\u001c\u0002v\u0001\u0007\u0011q\u000e\u0005\b\u0003\u007f\u0002A\u0011IAA\u0003\u0015!\u0003\u000f\\;t)\rq\u00171\u0011\u0005\b\u0003G\ni\b1\u0001o\u0011\u001d\t9\t\u0001C!\u0003\u0013\u000b\u0001\u0002\n9mkN$S-\u001d\u000b\u0005\u0003\u0017\tY\tC\u0004\u0002d\u0005\u0015\u0005\u0019\u00018\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\u0006aAo\u001c&t_:|%M[3diV\u0011\u00111\u0013\t\u0006m\u0005UU\u0007U\u0005\u0004\u0003/[$aA'ba\"9\u00111\u0014\u0001\u0005B\u0005u\u0015aB5t\u000b6\u0004H/_\u000b\u0003\u0003?\u00032\u0001EAQ\u0013\r\t\u0019+\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\u000b\u0001C!\u0003S\u000bQa\u00197fCJ$\"!a\u0003\t\u000f\u00055\u0006\u0001\"\u0011\u00020\u0006a\u0011n]#rk&4\u0018\r\\3oiR!\u0011qTAY\u0011\u001d\t\u0019'a+A\u0002U9q!!.\u0003\u0011\u0003\t9,A\u0005ISN$xn\u001a:b[B\u0019a#!/\u0007\r\u0005\u0011\u0001\u0012AA^'\r\tIl\u0004\u0005\bW\u0006eF\u0011AA`)\t\t9\f\u0003\u0005\u0002D\u0006eF\u0011AAc\u0003\u0019\u0011WO\u001a4feV!\u0011qYAg)\u0011\tI-a4\u0011\rA1\u00151ZAf!\rI\u0015Q\u001a\u0003\u0007\u0017\u0006\u0005'\u0019\u0001'\t\u0011\u0005\u0015\u0012\u0011\u0019a\u0001\u0003\u0017D\u0001\"a5\u0002:\u0012\u0005\u0011Q[\u0001\u000bKF,\u0018N^1mK:$X\u0003BAl\u0003G$\u0002\"!7\u0002f\u0006%\u0018Q\u001e\u000b\u0005\u0003?\u000bY\u000e\u0003\u0006\u0002^\u0006E\u0017\u0011!a\u0002\u0003?\f!\"\u001a<jI\u0016t7-\u001a\u00132!\u0011\u0019g-!9\u0011\u0007%\u000b\u0019\u000f\u0002\u0004L\u0003#\u0014\r\u0001\u0014\u0005\t\u0003O\f\t\u000e1\u0001\u0002b\u0006\u0011q.\r\u0005\t\u0003W\f\t\u000e1\u0001\u0002b\u0006\u0011qN\r\u0005\u0007{\u0006E\u0007\u0019\u0001!\t\u0011\u0005E\u0018\u0011\u0018C\u0001\u0003g\f!\"\u001a=qC:$')\u001b8t+\u0011\t)0!@\u0015\r\u0005](q\u0001B\u0005)\u0019\tI0a@\u0003\u0004A)a#!\u0001\u0002|B\u0019\u0011*!@\u0005\r-\u000byO1\u0001M\u0011\u001d!\u0016q\u001ea\u0002\u0005\u0003\u0001Ba\u0016.\u0002|\"9\u0001-a<A\u0004\t\u0015\u0001\u0003B2g\u0003wD\u0001\"!\n\u0002p\u0002\u0007\u00111 \u0005\t\u0005\u0017\ty\u000f1\u0001\u0002z\u0006\u0019q\u000e\u001c3\t\u0011\t=\u0011\u0011\u0018C\u0001\u0005#\tab\u00195fG.,e\u000e\u001a9pS:$8/\u0006\u0003\u0003\u0014\tmAC\u0002B\u000b\u0005C\u00119\u0003\u0006\u0003\u0003\u0018\tu\u0001C\u0002\tG\u00053\u0011I\u0002E\u0002J\u00057!aa\u0013B\u0007\u0005\u0004a\u0005b\u0002+\u0003\u000e\u0001\u000f!q\u0004\t\u0005/j\u0013I\u0002\u0003\u0005\u0003$\t5\u0001\u0019\u0001B\u0013\u0003\u0011aWM\u001a;\u0011\u000bY\t\tA!\u0007\t\u0011\t%\"Q\u0002a\u0001\u0005K\tQA]5hQRD\u0001B!\f\u0002:\u0012%!qF\u0001\u0010O\u0016$\u0018i\u0019;vC2\u0014u.\u001e8egV!!\u0011\u0007B\u001c)\u0011\u0011\u0019D!\u000f\u0011\rA1%Q\u0007B\u001b!\rI%q\u0007\u0003\u0007\u0017\n-\"\u0019\u0001'\t\u000fu\u0014Y\u00031\u0001\u0003<A)a#!\u0001\u00036!A!qHA]\t\u0003\u0011\t%\u0001\u0005d_BL\u0018J\u001c;p+\u0011\u0011\u0019E!\u0014\u0015\r\u0005-!Q\tB(\u0011!\u00119E!\u0010A\u0002\t%\u0013A\u0001;p!\u00151\u0012\u0011\u0001B&!\rI%Q\n\u0003\u0007\u0017\nu\"\u0019\u0001'\t\u0011\tE#Q\ba\u0001\u0005\u0013\nAA\u001a:p[\u0002")
public class Histogram<T>
implements Stat,
LazyLogging {
    private final SimpleFeatureType sft;
    private final String property;
    private final MinMax.MinMaxDefaults<T> defaults;
    private final ClassTag<T> ct;
    private final int i;
    private BinnedArray<T> bins;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static <T> void copyInto(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2) {
        Histogram$.MODULE$.copyInto(binnedArray, binnedArray2);
    }

    public static <T> Tuple2<T, T> checkEndpoints(BinnedArray<T> binnedArray, BinnedArray<T> binnedArray2, MinMax.MinMaxDefaults<T> minMaxDefaults) {
        return Histogram$.MODULE$.checkEndpoints(binnedArray, binnedArray2, minMaxDefaults);
    }

    public static <T> BinnedArray<T> expandBins(T t, BinnedArray<T> binnedArray, MinMax.MinMaxDefaults<T> minMaxDefaults, ClassTag<T> classTag) {
        return Histogram$.MODULE$.expandBins(t, binnedArray, minMaxDefaults, classTag);
    }

    public static <T> boolean equivalent(T t, T t2, int n, ClassTag<T> classTag) {
        return Histogram$.MODULE$.equivalent(t, t2, n, classTag);
    }

    public static <T> Tuple2<T, T> buffer(T t) {
        return Histogram$.MODULE$.buffer(t);
    }

    private Logger logger$lzycompute() {
        Histogram histogram2 = this;
        synchronized (histogram2) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void $plus$eq(Stat other, Predef.DummyImplicit d) {
        Stat$class.$plus$eq(this, other, d);
    }

    @Override
    public Stat $plus(Stat other, Predef.DummyImplicit d) {
        return Stat$class.$plus(this, other, d);
    }

    @Override
    public String toJson() {
        return Stat$class.toJson(this);
    }

    @Override
    public SimpleFeatureType sft() {
        return this.sft;
    }

    public String property() {
        return this.property;
    }

    public MinMax.MinMaxDefaults<T> defaults() {
        return this.defaults;
    }

    public ClassTag<T> ct() {
        return this.ct;
    }

    private int i() {
        return this.i;
    }

    public BinnedArray<T> bins() {
        return this.bins;
    }

    public void bins_$eq(BinnedArray<T> x$1) {
        this.bins = x$1;
    }

    public int length() {
        return this.bins().length();
    }

    public int directIndex(long value2) {
        return this.bins().directIndex(value2);
    }

    public int indexOf(T value2) {
        return this.bins().indexOf(value2);
    }

    public long count(int i) {
        return this.bins().counts()[i];
    }

    public T min() {
        return (T)this.bins().bounds()._1();
    }

    public T max() {
        return (T)this.bins().bounds()._2();
    }

    public Tuple2<T, T> bounds() {
        return this.bins().bounds();
    }

    public Tuple2<T, T> bounds(int i) {
        return this.bins().bounds(i);
    }

    public T medianValue(int i) {
        return this.bins().medianValue(i);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCountsFrom(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                this.$plus$eq(other);
                return;
            }
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    @Override
    public void observe(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.i());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct()));
                    BinnedArray<Object> qual$1 = this.bins();
                    Object x$7 = value2;
                    long x$8 = qual$1.add$default$2();
                    qual$1.add(x$7, x$8);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] + 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error observing value '{}': {}", new Object[]{value2, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void unobserve(SimpleFeature sf) {
        Object value2 = sf.getAttribute(this.i());
        if (value2 != null) {
            try {
                int i = this.bins().indexOf(value2);
                if (i == -1) {
                    this.bins_$eq(Histogram$.MODULE$.expandBins(value2, this.bins(), this.defaults(), this.ct()));
                    this.bins().add(value2, -1L);
                } else {
                    long[] lArray = this.bins().counts();
                    lArray[i] = lArray[i] - 1L;
                }
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error un-observing value '{}': {}", new Object[]{value2, exception.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Histogram<T> $plus(Histogram<T> other) {
        void var2_2;
        Histogram<T> plus2 = new Histogram<T>(this.sft(), this.property(), this.length(), this.bounds(), this.defaults(), this.ct());
        plus2.$plus$eq(this);
        plus2.$plus$eq(other);
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void $plus$eq(Histogram<T> other) {
        if (this.length() == other.length()) {
            Tuple2<T, T> tuple2 = this.bounds();
            Tuple2<T, T> tuple22 = other.bounds();
            if (!(tuple2 != null ? !tuple2.equals(tuple22) : tuple22 != null)) {
                int i = 0;
                while (i < this.bins().length()) {
                    long[] lArray = this.bins().counts();
                    int n = i;
                    lArray[n] = lArray[n] + other.bins().counts()[i];
                    ++i;
                }
                return;
            }
        }
        if (other.isEmpty()) return;
        if (this.isEmpty()) {
            this.bins_$eq(BinnedArray$.MODULE$.apply(other.length(), other.bounds(), this.ct()));
            int i = 0;
            while (i < this.bins().length()) {
                this.bins().counts()[i] = other.bins().counts()[i];
                ++i;
            }
            return;
        }
        Tuple2<T, T> newEndpoints = Histogram$.MODULE$.checkEndpoints(this.bins(), other.bins(), this.defaults());
        int newLength = package$.MODULE$.max(this.length(), other.length());
        Tuple2<T, T> tuple2 = newEndpoints;
        Tuple2<T, T> tuple23 = this.bounds();
        if ((tuple2 != null ? !tuple2.equals(tuple23) : tuple23 != null) || newLength != this.length()) {
            BinnedArray<T> newBins = BinnedArray$.MODULE$.apply(newLength, newEndpoints, this.ct());
            Histogram$.MODULE$.copyInto(newBins, this.bins());
            this.bins_$eq(newBins);
        }
        Histogram$.MODULE$.copyInto(this.bins(), other.bins());
    }

    public Map<String, Object> toJsonObject() {
        Seq binSeq = (Seq)Seq$.MODULE$.tabulate(this.bins().length(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Histogram $outer;

            public final ListMap<String, Object> apply(int bin) {
                return (ListMap)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index"), (Object)BoxesRunTime.boxToInteger((int)bin)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.$outer.bounds(bin)._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.$outer.bounds(bin)._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"count"), (Object)BoxesRunTime.boxToLong((long)this.$outer.bins().counts()[bin]))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return (Map)ListMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"lower-bound"), this.bounds()._1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"upper-bound"), this.bounds()._2()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bins"), (Object)binSeq)}));
    }

    @Override
    public boolean isEmpty() {
        return Predef$.MODULE$.longArrayOps(this.bins().counts()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$1) {
                return this.apply$mcZJ$sp(x$1);
            }

            public boolean apply$mcZJ$sp(long x$1) {
                return x$1 == 0L;
            }
        });
    }

    @Override
    public void clear() {
        this.bins().clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEquivalent(Stat other) {
        Stat stat2 = other;
        if (!(stat2 instanceof Histogram)) return false;
        Histogram histogram2 = (Histogram)stat2;
        String string2 = this.property();
        String string3 = histogram2.property();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        Tuple2<T, T> tuple2 = this.bounds();
        Tuple2<T, T> tuple22 = histogram2.bounds();
        if (tuple2 == null) {
            if (tuple22 != null) {
                return false;
            }
        } else if (!tuple2.equals(tuple22)) return false;
        if (!Arrays.equals(this.bins().counts(), histogram2.bins().counts())) return false;
        return true;
    }

    public Histogram(SimpleFeatureType sft, String property, int initialBins, Tuple2<T, T> initialEndpoints, MinMax.MinMaxDefaults<T> defaults, ClassTag<T> ct) {
        this.sft = sft;
        this.property = property;
        this.defaults = defaults;
        this.ct = ct;
        Stat$class.$init$(this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.i = sft.indexOf(property);
        this.bins = BinnedArray$.MODULE$.apply(initialBins, initialEndpoints, ct);
    }
}

