/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.proj4.mgrs;

import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class MGRS$ {
    public static MGRS$ MODULE$;
    private final int NUM_100K_SETS;
    private final String SET_ORIGIN_COLUMN_LETTERS;
    private final String SET_ORIGIN_ROW_LETTERS;
    private final int _A;
    private final int _I;
    private final int _O;
    private final int _V;
    private final int _Z;

    static {
        new MGRS$();
    }

    public String longLatToMGRS(double d, double lat, int accuracy) {
        if (accuracy < 1 || accuracy > 5) {
            throw new IllegalArgumentException("Accuracy for MGRS conversion must be in the range 1 to 5");
        }
        return this.encode(this.LLtoUTM(d, lat), accuracy);
    }

    public int longLatToMGRS$default$3() {
        return 5;
    }

    public Tuple4<Object, Object, Object, Object> mgrsToBBox(String mgrs) {
        double accuracy;
        Tuple4 tuple4;
        Tuple2<Tuple4<Object, Object, Object, Object>, Object> decoded;
        block6: {
            Tuple2<Tuple4<Object, Object, Object, Object>, Object> tuple2;
            block5: {
                decoded = this.decode(mgrs);
                tuple2 = decoded;
                if (tuple2 == null) break block5;
                tuple4 = (Tuple4)tuple2._1();
                accuracy = tuple2._2$mcD$sp();
                if (tuple4 != null) break block6;
            }
            throw new MatchError(tuple2);
        }
        int easting = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int northing = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int zoneNumber = BoxesRunTime.unboxToInt((Object)tuple4._3());
        char zoneLetter = BoxesRunTime.unboxToChar((Object)tuple4._4());
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)easting), (Object)BoxesRunTime.boxToInteger((int)northing), (Object)BoxesRunTime.boxToInteger((int)zoneNumber), (Object)BoxesRunTime.boxToCharacter((char)zoneLetter), (Object)BoxesRunTime.boxToDouble((double)accuracy));
        Tuple5 tuple52 = tuple5;
        int easting2 = BoxesRunTime.unboxToInt((Object)tuple52._1());
        int northing2 = BoxesRunTime.unboxToInt((Object)tuple52._2());
        int zoneNumber2 = BoxesRunTime.unboxToInt((Object)tuple52._3());
        char zoneLetter2 = BoxesRunTime.unboxToChar((Object)tuple52._4());
        double accuracy2 = BoxesRunTime.unboxToDouble((Object)tuple52._5());
        Tuple2<Object, Object> tuple2 = this.UTMtoLL((Tuple4<Object, Object, Object, Object>)((Tuple4)decoded._1()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double left = tuple2._1$mcD$sp();
        double bottom = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(left, bottom);
        Tuple2.mcDD.sp sp3 = sp2;
        double left2 = sp3._1$mcD$sp();
        double bottom2 = sp3._2$mcD$sp();
        Tuple2<Object, Object> tuple22 = this.UTMtoLL((Tuple4<Object, Object, Object, Object>)new Tuple4((Object)BoxesRunTime.boxToInteger((int)(easting2 + (int)accuracy2)), (Object)BoxesRunTime.boxToInteger((int)(northing2 + (int)accuracy2)), (Object)BoxesRunTime.boxToInteger((int)zoneNumber2), (Object)BoxesRunTime.boxToCharacter((char)zoneLetter2)));
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        double right = tuple22._1$mcD$sp();
        double top = tuple22._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(right, top);
        Tuple2.mcDD.sp sp5 = sp4;
        double right2 = sp5._1$mcD$sp();
        double top2 = sp5._2$mcD$sp();
        return new Tuple4((Object)BoxesRunTime.boxToDouble((double)left2), (Object)BoxesRunTime.boxToDouble((double)bottom2), (Object)BoxesRunTime.boxToDouble((double)right2), (Object)BoxesRunTime.boxToDouble((double)top2));
    }

    public Tuple2<Object, Object> mgrsToLongLat(String mgrs) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.mgrsToBBox(mgrs);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        double left = BoxesRunTime.unboxToDouble((Object)tuple4._1());
        double bottom = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        double right = BoxesRunTime.unboxToDouble((Object)tuple4._3());
        double top = BoxesRunTime.unboxToDouble((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)left), (Object)BoxesRunTime.boxToDouble((double)bottom), (Object)BoxesRunTime.boxToDouble((double)right), (Object)BoxesRunTime.boxToDouble((double)top));
        Tuple4 tuple43 = tuple42;
        double left2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double bottom2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double right2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double top2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        return new Tuple2.mcDD.sp((left2 + right2) / (double)2, (bottom2 + top2) / (double)2);
    }

    private int NUM_100K_SETS() {
        return this.NUM_100K_SETS;
    }

    private String SET_ORIGIN_COLUMN_LETTERS() {
        return this.SET_ORIGIN_COLUMN_LETTERS;
    }

    private String SET_ORIGIN_ROW_LETTERS() {
        return this.SET_ORIGIN_ROW_LETTERS;
    }

    private int _A() {
        return this._A;
    }

    private int _I() {
        return this._I;
    }

    private int _O() {
        return this._O;
    }

    private int _V() {
        return this._V;
    }

    private int _Z() {
        return this._Z;
    }

    private double degToRad(double deg) {
        return deg * Math.PI / 180.0;
    }

    private double radToDeg(double rad) {
        return 180.0 * rad / Math.PI;
    }

    private Tuple4<Object, Object, Object, Object> LLtoUTM(double d, double lat) {
        double a = 6378137.0;
        double eccSquared = 0.00669438;
        double k0 = 0.9996;
        double latRad = this.degToRad(lat);
        double longRad = this.degToRad(d);
        int zoneNumber = d == (double)180 ? 60 : (lat >= 56.0 && lat < 64.0 && d >= 3.0 && d < 12.0 ? 32 : (lat >= 72.0 && lat < 84.0 ? (d >= 0.0 && d < 9.0 ? 31 : (d >= 9.0 && d < 21.0 ? 33 : (d >= 21.0 && d < 33.0 ? 35 : (d >= 33.0 && d < 42.0 ? 37 : (int)((d + 180.0) / 6.0) + 1)))) : (int)((d + 180.0) / 6.0) + 1));
        double longOrigin = ((double)zoneNumber - 1.0) * (double)6 - (double)180 + (double)3;
        double longOriginRad = this.degToRad(longOrigin);
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double _N = a / package$.MODULE$.sqrt(1.0 - eccSquared * package$.MODULE$.sin(latRad) * package$.MODULE$.sin(latRad));
        double _T = package$.MODULE$.tan(latRad) * package$.MODULE$.tan(latRad);
        double _C = eccPrimeSquared * package$.MODULE$.cos(latRad) * package$.MODULE$.cos(latRad);
        double _A = package$.MODULE$.cos(latRad) * (longRad - longOriginRad);
        double _M = a * ((1.0 - eccSquared / (double)4 - (double)3 * eccSquared * eccSquared / (double)64 - (double)5 * eccSquared * eccSquared * eccSquared / (double)256) * latRad - ((double)3 * eccSquared / (double)8 + (double)3 * eccSquared * eccSquared / (double)32 + (double)45 * eccSquared * eccSquared * eccSquared / (double)1024) * package$.MODULE$.sin((double)2 * latRad) + ((double)15 * eccSquared * eccSquared / (double)256 + (double)45 * eccSquared * eccSquared * eccSquared / (double)1024) * package$.MODULE$.sin((double)4 * latRad) - (double)35 * eccSquared * eccSquared * eccSquared / (double)3072 * package$.MODULE$.sin((double)6 * latRad));
        double utmEasting = k0 * _N * (_A + (1.0 - _T + _C) * package$.MODULE$.pow(_A, 3.0) / 6.0 + ((double)5 - (double)18 * _T + _T * _T + (double)72 * _C - (double)58 * eccPrimeSquared) * package$.MODULE$.pow(_A, 5.0) / 120.0) + 500000.0;
        double northingOffset = lat < 0.0 ? 1.0E7 : 0.0;
        double utmNorthing = k0 * (_M + _N * package$.MODULE$.tan(latRad) * (_A * _A / (double)2 + ((double)5 - _T + (double)9 * _C + (double)4 * _C * _C) * package$.MODULE$.pow(_A, 4.0) / 24.0 + ((double)61 - (double)58 * _T + _T * _T + (double)600 * _C - (double)330 * eccPrimeSquared) * package$.MODULE$.pow(_A, 6.0) / 720.0)) + northingOffset;
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)((int)package$.MODULE$.round(utmNorthing))), (Object)BoxesRunTime.boxToInteger((int)((int)package$.MODULE$.round(utmEasting))), (Object)BoxesRunTime.boxToInteger((int)zoneNumber), (Object)BoxesRunTime.boxToCharacter((char)this.getLetterDesignator(lat)));
    }

    private Tuple2<Object, Object> UTMtoLL(Tuple4<Object, Object, Object, Object> decoded) {
        Tuple4<Object, Object, Object, Object> tuple4 = decoded;
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int utmEasting = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int utmNorthing = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int zoneNumber = BoxesRunTime.unboxToInt((Object)tuple4._3());
        char zoneLetter = BoxesRunTime.unboxToChar((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)utmEasting), (Object)BoxesRunTime.boxToInteger((int)utmNorthing), (Object)BoxesRunTime.boxToInteger((int)zoneNumber), (Object)BoxesRunTime.boxToCharacter((char)zoneLetter));
        Tuple4 tuple43 = tuple42;
        int utmEasting2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int utmNorthing2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int zoneNumber2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        char zoneLetter2 = BoxesRunTime.unboxToChar((Object)tuple43._4());
        if (zoneNumber2 < 0 || zoneNumber2 > 60) {
            throw new IllegalArgumentException(new StringBuilder(23).append("Zone number ").append(zoneNumber2).append(" is invalid").toString());
        }
        double k0 = 0.9996;
        double a = 6378137.0;
        double eccSquared = 0.00669438;
        double e1 = (1.0 - package$.MODULE$.sqrt(1.0 - eccSquared)) / (1.0 + package$.MODULE$.sqrt(1.0 - eccSquared));
        double x = (double)utmEasting2 - 500000.0;
        double y = zoneLetter2 < 'N' ? (double)utmNorthing2 - 1.0E7 : (double)utmNorthing2;
        int longOrigin = (zoneNumber2 - 1) * 6 - 180 + 3;
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double _M = y / k0;
        double mu = _M / (a * (1.0 - eccSquared / (double)4 - (double)3 * eccSquared * eccSquared / (double)64 - (double)5 * eccSquared * eccSquared * eccSquared / (double)256));
        double phi1Rad = mu + ((double)3 * e1 / (double)2 - (double)27 * package$.MODULE$.pow(e1, 3.0) / (double)32) * package$.MODULE$.sin((double)2 * mu) + ((double)21 * e1 * e1 / (double)16 - (double)55 * package$.MODULE$.pow(e1, 4.0) / (double)32) * package$.MODULE$.sin((double)4 * mu) + (double)151 * package$.MODULE$.pow(e1, 3.0) / (double)96 * package$.MODULE$.sin((double)6 * mu);
        double _N1 = a / package$.MODULE$.sqrt(1.0 - eccSquared * package$.MODULE$.sin(phi1Rad) * package$.MODULE$.sin(phi1Rad));
        double _T1 = package$.MODULE$.tan(phi1Rad) * package$.MODULE$.tan(phi1Rad);
        double _C1 = eccPrimeSquared * package$.MODULE$.cos(phi1Rad) * package$.MODULE$.cos(phi1Rad);
        double _R1 = a * (1.0 - eccSquared) / package$.MODULE$.pow(1.0 - eccSquared * package$.MODULE$.sin(phi1Rad) * package$.MODULE$.sin(phi1Rad), 1.5);
        double _D = x / (_N1 * k0);
        double lat = this.radToDeg(phi1Rad - _N1 * package$.MODULE$.tan(phi1Rad) / _R1 * (_D * _D / (double)2 - ((double)5 + (double)3 * _T1 + (double)10 * _C1 - (double)4 * _C1 * _C1 - (double)9 * eccPrimeSquared) * package$.MODULE$.pow(_D, 4.0) / (double)24 + ((double)61 + (double)90 * _T1 + (double)298 * _C1 + (double)45 * _T1 * _T1 - (double)252 * eccPrimeSquared - (double)3 * _C1 * _C1) * package$.MODULE$.pow(_D, 6.0) / (double)720));
        double d = (double)longOrigin + this.radToDeg((_D - (1.0 + (double)2 * _T1 + _C1) * package$.MODULE$.pow(_D, 3.0) / (double)6 + ((double)5 - (double)2 * _C1 + (double)28 * _T1 - (double)3 * _C1 * _C1 + (double)8 * eccPrimeSquared + (double)24 * _T1 * _T1) * package$.MODULE$.pow(_D, 5.0) / (double)120) / package$.MODULE$.cos(phi1Rad));
        return new Tuple2.mcDD.sp(d, lat);
    }

    private char getLetterDesignator(double lat) {
        char c;
        if ((double)80 <= lat && lat <= (double)84) {
            c = 'X';
        } else if ((double)-80 <= lat && lat < (double)80) {
            String letters = "CDEFGHJKLMNPQRSTUVWX";
            c = letters.charAt((int)(lat + (double)80) / 8);
        } else {
            throw new IllegalArgumentException(new StringBuilder(33).append("Latitude value, ").append(lat).append(", is out of range").toString());
        }
        return c;
    }

    private String encode(Tuple4<Object, Object, Object, Object> utm, int accuracy) {
        Tuple4<Object, Object, Object, Object> tuple4 = utm;
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int northing = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int easting = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int zoneNumber = BoxesRunTime.unboxToInt((Object)tuple4._3());
        char zoneLetter = BoxesRunTime.unboxToChar((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)northing), (Object)BoxesRunTime.boxToInteger((int)easting), (Object)BoxesRunTime.boxToInteger((int)zoneNumber), (Object)BoxesRunTime.boxToCharacter((char)zoneLetter));
        Tuple4 tuple43 = tuple42;
        int northing2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int easting2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int zoneNumber2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        char zoneLetter2 = BoxesRunTime.unboxToChar((Object)tuple43._4());
        String formatString = new StringBuilder(3).append("%0").append(Integer.toString(accuracy)).append("d").toString();
        String seasting = Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToInteger((int)easting2)), formatString);
        String snorthing = Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToInteger((int)northing2)), formatString);
        return new StringBuilder(0).append(zoneNumber2).append(zoneLetter2).append(this.get100kID(easting2, northing2, zoneNumber2)).append(new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(seasting)).drop(seasting.length() - 5))).take(accuracy)).append(new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(snorthing)).drop(snorthing.length() - 5))).take(accuracy)).toString();
    }

    private String get100kID(int easting, int northing, int zoneNumber) {
        int setParm = this.get100kSetForZone(zoneNumber);
        int setColumn = easting / 100000;
        int setRow = northing / 100000 % 20;
        return this.getLetter100kID(setColumn, setRow, setParm);
    }

    /*
     * WARNING - void declaration
     */
    private int get100kSetForZone(int i) {
        void var2_2;
        int setParm = i % this.NUM_100K_SETS();
        return setParm == 0 ? this.NUM_100K_SETS() : var2_2;
    }

    private String getLetter100kID(int column, int row, int parm) {
        int index = parm - 1;
        char colOrigin = this.SET_ORIGIN_COLUMN_LETTERS().charAt(index);
        char rowOrigin = this.SET_ORIGIN_ROW_LETTERS().charAt(index);
        int colInt = colOrigin + column - 1;
        int rowInt = rowOrigin + row;
        boolean rollover = false;
        if (colInt > this._Z()) {
            colInt = colInt - this._Z() + this._A() - 1;
            rollover = true;
        }
        if (colInt == this._I() || colOrigin < this._I() && colInt > this._I() || (colInt > this._I() || colOrigin < this._I()) && rollover) {
            ++colInt;
        }
        if ((colInt == this._O() || colOrigin < this._O() && colInt > this._O() || (colInt > this._O() || colOrigin < this._O()) && rollover) && ++colInt == this._I()) {
            ++colInt;
        }
        if (colInt > this._Z()) {
            colInt = colInt - this._Z() + this._A() - 1;
        }
        if (rowInt > this._V()) {
            rowInt = rowInt - this._V() + this._A() - 1;
            rollover = true;
        } else {
            rollover = false;
        }
        if (rowInt == this._I() || rowOrigin < this._I() && rowInt > this._I() || (rowInt > this._I() || rowOrigin < this._I()) && rollover) {
            ++rowInt;
        }
        if ((rowInt == this._O() || rowOrigin < this._O() && rowInt > this._O() || (rowInt > this._O() || rowOrigin < this._O()) && rollover) && ++rowInt == this._I()) {
            ++rowInt;
        }
        if (rowInt > this._V()) {
            rowInt = rowInt - this._V() + this._A() - 1;
        }
        return new StringBuilder(0).append((char)colInt).append((char)rowInt).toString();
    }

    private Tuple2<Tuple4<Object, Object, Object, Object>, Object> decode(String mgrsString) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        double north100k;
        if (mgrsString.length() == 0) {
            throw new IllegalArgumentException("Cannot generate MGRS from empty string");
        }
        int length = mgrsString.length();
        String sb = "";
        int i = 0;
        while (!scala.package$.MODULE$.Range().apply(65, 90, 1).contains((int)mgrsString.charAt(i))) {
            if (i >= 2) {
                throw new IllegalArgumentException(new StringBuilder(25).append("Bad MGRS conversion from ").append(mgrsString).toString());
            }
            sb = new StringBuilder(0).append(sb).append(mgrsString.charAt(i)).toString();
            ++i;
        }
        if (i == 0 || i + 3 > length) {
            throw new IllegalArgumentException(new StringBuilder(25).append("Bad MGRS conversion from ").append(mgrsString).toString());
        }
        int zoneNumber = new StringOps(Predef$.MODULE$.augmentString(sb)).toInt();
        char zoneLetter = mgrsString.charAt(i);
        if (zoneLetter <= 'B' || zoneLetter >= 'Y' || zoneLetter == 'I' || zoneLetter == 'O') {
            throw new IllegalArgumentException(new StringBuilder(33).append("MGRS zone letter ").append(zoneLetter).append(" not allowed in ").append(mgrsString).toString());
        }
        String hunK = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(mgrsString)).drop(++i))).take(2);
        int set = this.get100kSetForZone(zoneNumber);
        i += 2;
        double east100k = this.getEastingFromChar(hunK.charAt(0), set);
        for (north100k = this.getNorthingFromChar(hunK.charAt(1), set); north100k < this.getMinNorthing(zoneLetter); north100k += (double)2000000) {
        }
        int remainder = length - i;
        if (remainder % 2 != 0) {
            throw new IllegalArgumentException("MGRS must have an even number of digits after the zone letter/100km letters in $mgrsString");
        }
        int sep = remainder / 2;
        if (sep > 0) {
            double aB = 100000.0 / package$.MODULE$.pow(10.0, (double)sep);
            String sepEastingString = mgrsString.substring(i, i + sep);
            String sepNorthingString = mgrsString.substring(i + sep);
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)(new StringOps(Predef$.MODULE$.augmentString(sepEastingString)).toDouble() * aB)), (Object)BoxesRunTime.boxToDouble((double)(new StringOps(Predef$.MODULE$.augmentString(sepNorthingString)).toDouble() * aB)), (Object)BoxesRunTime.boxToDouble((double)aB));
        } else {
            tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double sepEasting = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double sepNorthing = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double accuracyBonus = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)sepEasting), (Object)BoxesRunTime.boxToDouble((double)sepNorthing), (Object)BoxesRunTime.boxToDouble((double)accuracyBonus));
        Tuple3 tuple34 = tuple33;
        double sepEasting2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
        double sepNorthing2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
        double accuracyBonus2 = BoxesRunTime.unboxToDouble((Object)tuple34._3());
        double easting = sepEasting2 + east100k;
        double northing = sepNorthing2 + north100k;
        return new Tuple2((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)((int)easting)), (Object)BoxesRunTime.boxToInteger((int)((int)northing)), (Object)BoxesRunTime.boxToInteger((int)zoneNumber), (Object)BoxesRunTime.boxToCharacter((char)zoneLetter)), (Object)BoxesRunTime.boxToDouble((double)accuracyBonus2));
    }

    private double getEastingFromChar(char e, int set) {
        int curCol = this.SET_ORIGIN_COLUMN_LETTERS().charAt(set - 1);
        double eastingValue = 100000.0;
        boolean rewindMarker = false;
        while (curCol != e) {
            if (++curCol == this._I()) {
                ++curCol;
            }
            if (curCol == this._O()) {
                ++curCol;
            }
            if (curCol > this._Z()) {
                if (rewindMarker) {
                    throw new IllegalArgumentException("Bad character $e in getEastingFromChar");
                }
                curCol = this._A();
                rewindMarker = true;
            }
            eastingValue += 100000.0;
        }
        return eastingValue;
    }

    private double getNorthingFromChar(char n, int set) {
        if (n > 'V') {
            throw new IllegalArgumentException("Invalid northing, $n, passed to getNorthingFromChar");
        }
        int curRow = this.SET_ORIGIN_ROW_LETTERS().charAt(set - 1);
        double northingValue = 0.0;
        boolean rewindMarker = false;
        while (curRow != n) {
            if (++curRow == this._I()) {
                ++curRow;
            }
            if (curRow == this._O()) {
                ++curRow;
            }
            if (curRow > this._V()) {
                if (rewindMarker) {
                    throw new IllegalArgumentException("Bad character, $n, passed to getNorthingFromChar");
                }
                curRow = this._A();
                rewindMarker = true;
            }
            northingValue += 100000.0;
        }
        return northingValue;
    }

    private double getMinNorthing(char zoneLetter) {
        double d;
        char c = zoneLetter;
        switch (c) {
            case 'C': {
                d = 1100000.0;
                break;
            }
            case 'D': {
                d = 2000000.0;
                break;
            }
            case 'E': {
                d = 2800000.0;
                break;
            }
            case 'F': {
                d = 3700000.0;
                break;
            }
            case 'G': {
                d = 4600000.0;
                break;
            }
            case 'H': {
                d = 5500000.0;
                break;
            }
            case 'J': {
                d = 6400000.0;
                break;
            }
            case 'K': {
                d = 7300000.0;
                break;
            }
            case 'L': {
                d = 8200000.0;
                break;
            }
            case 'M': {
                d = 9100000.0;
                break;
            }
            case 'N': {
                d = 0.0;
                break;
            }
            case 'P': {
                d = 800000.0;
                break;
            }
            case 'Q': {
                d = 1700000.0;
                break;
            }
            case 'R': {
                d = 2600000.0;
                break;
            }
            case 'S': {
                d = 3500000.0;
                break;
            }
            case 'T': {
                d = 4400000.0;
                break;
            }
            case 'U': {
                d = 5300000.0;
                break;
            }
            case 'V': {
                d = 6200000.0;
                break;
            }
            case 'W': {
                d = 7000000.0;
                break;
            }
            case 'X': {
                d = 7900000.0;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(21).append("Invalid zone letter, ").append(zoneLetter).toString());
            }
        }
        return d;
    }

    private MGRS$() {
        MODULE$ = this;
        this.NUM_100K_SETS = 6;
        this.SET_ORIGIN_COLUMN_LETTERS = "AJSAJS";
        this.SET_ORIGIN_ROW_LETTERS = "AFAFAF";
        this._A = 65;
        this._I = 73;
        this._O = 79;
        this._V = 86;
        this._Z = 90;
    }
}

