/*
 * Copyright 2016 Azavea
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package geotrellis.raster.io.geotiff

import _root_.io.circe._

abstract sealed class InterleaveMethod

/** Pixel Interleave: The pixels of each band are stored int the same segment, contiguously */
case object PixelInterleave extends InterleaveMethod
/** Band Interleave: The pixels of each band are in separate segments */
case object BandInterleave extends InterleaveMethod

object InterleaveMethod {
  implicit val interleaveMethodEncoder: Encoder[InterleaveMethod] =
    Encoder.encodeString.contramap[InterleaveMethod](_.toString)

  implicit val interleaveMethodDecoder: Decoder[InterleaveMethod] =
    Decoder.decodeString.emap {
      case "PixelInterleave" => Right(PixelInterleave)
      case "BandInterleave" => Right(BandInterleave)
      case str => Left(s"Invalid Interleave: $str")
    }
}