/*
 * Copyright 2016 Azavea
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package geotrellis.raster.io.geotiff.compression

import geotrellis.raster.io.geotiff.tags.codes.CompressionType._

object NoCompression extends Compression with Compressor with Decompressor {
  def code = Uncompressed

  def createCompressor(segmentCount: Int) = NoCompression
  def createDecompressor() = NoCompression
  def compress(bytes: Array[Byte], sectionIndex: Int): Array[Byte] = { bytes }
  def decompress(bytes: Array[Byte], sectionIndex: Int): Array[Byte] = { bytes }
}
