/*
 * Copyright 2016 Azavea
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package geotrellis.raster.io.geotiff.tags.codes

object TagCodes {

  val NewSubfileTypeTag = 254
  val SubfileTypeTag = 255
  val ImageWidthTag = 256
  val ImageLengthTag = 257
  val BitsPerSampleTag = 258
  val CompressionTag = 259
  val PhotometricInterpTag = 262
  val ThresholdingTag = 263
  val CellWidthTag = 264
  val CellLengthTag = 265
  val FillOrderTag = 266
  val DocumentNameTag = 269
  val ImageDescTag = 270
  val MakerTag = 271
  val ModelTag = 272
  val StripOffsetsTag = 273
  val OrientationTag = 274
  val SamplesPerPixelTag = 277
  val RowsPerStripTag = 278
  val StripByteCountsTag = 279
  val MinSampleValueTag = 280
  val MaxSampleValueTag = 281
  val XResolutionTag = 282
  val YResolutionTag = 283
  val PlanarConfigurationTag = 284
  val PageNameTag = 285
  val XPositionTag = 286
  val YPositionTag = 287
  val FreeOffsetsTag = 288
  val FreeByteCountsTag = 289
  val GrayResponseUnitTag = 290
  val GrayResponseCurveTag = 291
  val T4OptionsTag = 292
  val T6OptionsTag = 293
  val ResolutionUnitTag = 296
  val PageNumberTag = 297
  val TransferFunctionTag = 301
  val SoftwareTag = 305
  val DateTimeTag = 306
  val ArtistTag = 315
  val HostComputerTag = 316
  val PredictorTag = 317
  val WhitePointTag = 318
  val PrimaryChromaticitiesTag = 319
  val ColorMapTag = 320
  val HalftoneHintsTag = 321
  val TileWidthTag = 322
  val TileLengthTag = 323
  val TileOffsetsTag = 324
  val TileByteCountsTag = 325
  val InkSetTag = 332
  val InkNamesTag = 333
  val NumberOfInksTag = 334
  val DotRangeTag = 336
  val TargetPrinterTag = 337
  val ExtraSamplesTag = 338
  val SampleFormatTag = 339
  val TransferRangeTag = 342
  val JpegTablesTag = 347
  val JpegProcTag = 512
  val JpegInterchangeFormatTag = 513
  val JpegInterchangeFormatLengthTag = 514
  val JpegRestartIntervalTag = 515
  val JpegLosslessPredictorsTag = 517
  val JpegPointTransformsTag = 518
  val JpegQTablesTag = 519
  val JpegDCTablesTag = 520
  val JpegACTablesTag = 521
  val YCbCrCoefficientsTag = 529
  val YCbCrSubSamplingTag = 530
  val YCbCrPositioningTag = 531
  val ReferenceBlackWhiteTag = 532
  val CopyrightTag = 33432
  val ModelPixelScaleTag = 33550
  val ModelTiePointsTag = 33922
  val ModelTransformationTag = 34264
  val GeoKeyDirectoryTag = 34735
  val GeoDoubleParamsTag = 34736
  val GeoAsciiParamsTag = 34737
  val DoublesTag = 34736
  val AsciisTag = 34737
  val MetadataTag = 42112
  val GDALInternalNoDataTag = 42113

}
