/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.ir.OpDescriptorHolder;
import org.nd4j.ir.OpNamespace;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.guava.collect.Lists;
import org.nd4j.shade.guava.primitives.Doubles;
import org.nd4j.shade.guava.primitives.Longs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DynamicCustomOp
extends DifferentialFunction
implements CustomOp {
    private static final Logger log = LoggerFactory.getLogger(DynamicCustomOp.class);
    private String opName;
    protected List<INDArray> inputArguments;
    protected List<INDArray> outputArguments;
    protected List<Double> tArguments;
    protected List<Long> iArguments;
    protected List<Boolean> bArguments;
    protected List<DataType> dArguments;
    protected List<String> sArguments;
    protected List<Integer> axis;
    protected boolean inplaceCall;
    private long hash;
    protected SDVariable[] outputVariables;
    private List<LongShapeDescriptor> outputShapes;

    public DynamicCustomOp() {
        this.inputArguments = new ArrayList<INDArray>();
        this.outputArguments = new ArrayList<INDArray>();
        this.tArguments = new ArrayList<Double>();
        this.iArguments = new ArrayList<Long>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
        this.axis = new ArrayList<Integer>();
        this.iArguments = new ArrayList<Long>();
        this.tArguments = new ArrayList<Double>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
    }

    public DynamicCustomOp(SameDiff sameDiff, SDVariable arg) {
        this(sameDiff, DynamicCustomOp.wrapOrNull(arg));
    }

    public DynamicCustomOp(SameDiff sameDiff, SDVariable[] args) {
        this(null, sameDiff, args);
    }

    public DynamicCustomOp(String opName, SameDiff sameDiff, SDVariable[] args) {
        super(sameDiff, args);
        this.inputArguments = new ArrayList<INDArray>();
        this.outputArguments = new ArrayList<INDArray>();
        this.tArguments = new ArrayList<Double>();
        this.iArguments = new ArrayList<Long>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
        this.axis = new ArrayList<Integer>();
        this.opName = opName;
        this.iArguments = new ArrayList<Long>();
        this.tArguments = new ArrayList<Double>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
    }

    public DynamicCustomOp(String opName, INDArray input, INDArray output, List<Double> tArguments, int[] iArguments) {
        INDArray[] iNDArrayArray;
        INDArray[] iNDArrayArray2;
        if (input == null) {
            iNDArrayArray2 = null;
        } else {
            INDArray[] iNDArrayArray3 = new INDArray[1];
            iNDArrayArray2 = iNDArrayArray3;
            iNDArrayArray3[0] = input;
        }
        if (output == null) {
            iNDArrayArray = null;
        } else {
            INDArray[] iNDArrayArray4 = new INDArray[1];
            iNDArrayArray = iNDArrayArray4;
            iNDArrayArray4[0] = output;
        }
        this(opName, iNDArrayArray2, iNDArrayArray, tArguments, iArguments);
    }

    public DynamicCustomOp(String opName, INDArray[] inputs, INDArray[] outputs, List<Double> tArguments, int[] iArguments) {
        this(opName, inputs, outputs, tArguments, ArrayUtil.toList((int[])iArguments));
    }

    public DynamicCustomOp(String opName, INDArray[] inputs, INDArray[] outputs, List<Double> tArguments, List<Integer> iArguments) {
        this.inputArguments = new ArrayList<INDArray>();
        this.outputArguments = new ArrayList<INDArray>();
        this.tArguments = new ArrayList<Double>();
        this.iArguments = new ArrayList<Long>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
        this.axis = new ArrayList<Integer>();
        if (inputs != null) {
            for (int i = 0; i < inputs.length; ++i) {
                if (inputs[i] != null) continue;
                throw new IllegalArgumentException("Input " + i + " for op " + this.getClass() + " was null!");
            }
            this.inputArguments = new ArrayList<INDArray>(Arrays.asList(inputs));
        }
        if (outputs != null) {
            this.outputArguments = new ArrayList<INDArray>(Arrays.asList(outputs));
        }
        this.opName = opName;
        this.tArguments = tArguments == null ? new ArrayList<Double>() : tArguments;
        this.iArguments = new ArrayList<Long>();
        this.sArguments = new ArrayList<String>();
        if (iArguments != null) {
            for (Integer a : iArguments) {
                this.iArguments.add(a.longValue());
            }
        }
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
    }

    public DynamicCustomOp(INDArray[] inputs, INDArray[] outputs) {
        this(null, inputs, outputs);
    }

    public DynamicCustomOp(String opName, INDArray[] inputs, INDArray[] outputs) {
        this(opName, inputs, outputs, (List<Double>)Lists.newArrayList(), Lists.newArrayList());
    }

    public DynamicCustomOp(String opName, SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(sameDiff, inPlace, args);
        this.inputArguments = new ArrayList<INDArray>();
        this.outputArguments = new ArrayList<INDArray>();
        this.tArguments = new ArrayList<Double>();
        this.iArguments = new ArrayList<Long>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
        this.axis = new ArrayList<Integer>();
        this.opName = opName;
        this.iArguments = new ArrayList<Long>();
        this.tArguments = new ArrayList<Double>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
        this.inplaceCall = inPlace;
    }

    public DynamicCustomOp(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        this(null, sameDiff, args, inPlace);
    }

    protected DynamicCustomOp(String opName) {
        this.inputArguments = new ArrayList<INDArray>();
        this.outputArguments = new ArrayList<INDArray>();
        this.tArguments = new ArrayList<Double>();
        this.iArguments = new ArrayList<Long>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
        this.axis = new ArrayList<Integer>();
        this.opName = opName;
        this.iArguments = new ArrayList<Long>();
        this.tArguments = new ArrayList<Double>();
        this.bArguments = new ArrayList<Boolean>();
        this.dArguments = new ArrayList<DataType>();
        this.sArguments = new ArrayList<String>();
    }

    @Override
    public String opName() {
        return this.opName;
    }

    @Override
    public SDVariable[] outputVariables() {
        return this.outputVariables(this.getOwnName() != null ? this.getOwnName() : this.opName());
    }

    @Override
    public SDVariable[] outputVariables(String baseName) {
        if (this.outputVariables == null) {
            String[] outputNames = this.sameDiff.getOutputsForOp(this);
            if (outputNames != null) {
                this.outputVariables = new SDVariable[outputNames.length];
                for (int i = 0; i < this.outputVariables.length; ++i) {
                    this.outputVariables[i] = this.sameDiff.getVariable(outputNames[i]);
                }
                return this.outputVariables;
            }
            SDVariable[] newVars = this.sameDiff.generateOutputVariableForOp(this, baseName, false);
            if (this.isInplaceCall()) {
                INDArray arr;
                if (this.args().length >= 1 && (arr = this.args()[0].getArr()) != null) {
                    this.sameDiff.setArrayForVariable(newVars[0].name(), arr);
                    this.addOutputArgument(arr);
                }
                return newVars;
            }
            this.outputVariables = newVars;
            this.computeArrays();
            if (this.sameDiff.getOutputsForOp(this) == null) {
                this.sameDiff.addOutgoingFor(this.outputVariables, (DifferentialFunction)this);
            }
            return newVars;
        }
        return this.outputVariables;
    }

    public INDArray generateFake(long ... shape) {
        return Nd4j.ones(Nd4j.defaultFloatingPointType(), shape);
    }

    public INDArray generateFake(DataType dataType, long ... shape) {
        return Nd4j.ones(dataType, shape);
    }

    public void computeArrays() {
        if (this.sameDiff.isEagerMode()) {
            SDVariable[] args = this.args();
            if (this.inputArguments.isEmpty()) {
                for (SDVariable arg : args) {
                    if (arg.getArr() != null && !arg.isPlaceHolder()) {
                        this.addInputArgument(arg.getArr());
                        continue;
                    }
                    if (arg.isPlaceHolder() && arg.getShape() != null) {
                        if (arg.getShape() != null && !this.sameDiff.getEagerArrays().hasArray(arg.name())) {
                            long[] inputShape = ArrayUtil.copy((long[])arg.getShape());
                            for (int i = 0; i < inputShape.length; ++i) {
                                if (inputShape[i] >= 0L) continue;
                                inputShape[i] = 1L;
                            }
                            DataType dtype = arg.dataType();
                            INDArray arr = null;
                            arr = dtype != null ? this.generateFake(dtype, inputShape) : this.generateFake(inputShape);
                            this.sameDiff.setEagerArrForVarName(arg.name(), arr);
                            this.addInputArgument(arr);
                            log.warn("Variable name " + arg.name() + " from  op of type " + this.opName() + " with unique name of " + this.getOwnName() + " was not able to resolve an array for eager computation, inserting dummy array. This can happen with control flow ops. Please validate this if in error.");
                            continue;
                        }
                        this.addInputArgument(this.sameDiff.getEagerArrForVarName(arg.name()));
                        continue;
                    }
                    INDArray add = Nd4j.scalar(1.0f);
                    this.sameDiff.setEagerArrForVarName(arg.name(), add);
                    this.addInputArgument(add);
                    log.warn("Variable name " + arg.name() + " from  op of type " + this.opName() + " with unique name of " + this.getOwnName() + " was not able to resolve an array for eager computation, inserting dummy array. This can happen with control flow ops. Please validate this if in error.");
                }
            }
            if (this.outputVariables.length > 0 && this.outputArguments().isEmpty()) {
                List<LongShapeDescriptor> longShapeDescriptors = Nd4j.getExecutioner().calculateOutputShape(this);
                for (int i = 0; i < this.outputVariables.length; ++i) {
                    if (this.outputVariables[i].getArr() != null) {
                        this.addOutputArgument(this.outputVariables[i].getArr());
                        continue;
                    }
                    long[] shape = longShapeDescriptors.get(i).getShape();
                    DataType defaultType = DataType.FLOAT;
                    if (this.outputVariables[i].dataType() != null) {
                        defaultType = this.outputVariables[i].dataType();
                    }
                    INDArray arr = longShapeDescriptors.get(i).isEmpty() ? Nd4j.create(longShapeDescriptors.get(i)) : Nd4j.create(defaultType, shape);
                    this.addOutputArgument(arr);
                }
                INDArray[] exec = Nd4j.getExecutioner().exec(this);
                if (this.outputVariables.length != exec.length) {
                    log.warn("During eager execution of op " + this.getOwnName() + " of type " + this.opName() + " the output variables had length " + this.outputVariables.length + " while execution output was " + exec.length + " stub scalar variables will be used.");
                }
                for (int i = 0; i < this.outputVariables.length; ++i) {
                    if (i >= exec.length) {
                        INDArray stub = Nd4j.scalar(1.0f).reshape(1L, 1L, 1L, 1L, 1L, 1L, 1L);
                        this.outputVariables[i].setShape(stub.shape());
                        this.sameDiff.setEagerArrForVarName(this.outputVariables[i].name(), stub);
                        continue;
                    }
                    this.outputVariables[i].setShape(exec[i].shape());
                    this.sameDiff.setEagerArrForVarName(this.outputVariables[i].name(), exec[i]);
                }
            }
        }
    }

    @Override
    public long opHash() {
        if (this.hash == 0L) {
            Map<String, CustomOpDescriptor> map = Nd4j.getExecutioner().getCustomOperations();
            CustomOpDescriptor desc = map.get(this.opName());
            if (desc == null) {
                throw new ND4JIllegalStateException("Op name " + this.opName() + " is missing!");
            }
            this.hash = desc.getHash();
        }
        return this.hash;
    }

    @Override
    public int numDArguments() {
        return this.dArguments.size();
    }

    @Override
    public int numSArguments() {
        return this.sArguments == null ? 0 : this.sArguments.size();
    }

    @Override
    public List<INDArray> outputArguments() {
        return this.outputArguments;
    }

    @Override
    public List<INDArray> inputArguments() {
        return this.inputArguments;
    }

    @Override
    public long[] iArgs() {
        return Longs.toArray(this.iArguments);
    }

    @Override
    public double[] tArgs() {
        return Doubles.toArray(this.tArguments);
    }

    @Override
    public DataType[] dArgs() {
        return this.dArguments.toArray(new DataType[this.dArguments.size()]);
    }

    @Override
    public String[] sArgs() {
        return this.sArguments.toArray(new String[this.sArguments.size()]);
    }

    @Override
    public void addIArgument(int ... arg) {
        int[] nArray = arg;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long a = nArray[i];
            this.iArguments.add(a);
        }
    }

    @Override
    public void addIArgument(long ... arg) {
        for (long a : arg) {
            this.iArguments.add(a);
        }
    }

    private void addIArgument(Integer ... arg) {
        for (Integer a : arg) {
            this.addIArgument(a.longValue());
        }
    }

    @Override
    public void removeIArgument(Integer arg) {
        this.iArguments.remove(arg);
    }

    @Override
    public void addSArgument(String ... args) {
        this.sArguments.addAll(Arrays.asList(args));
    }

    @Override
    public void removeSArgument(String argument) {
        this.sArguments.remove(argument);
    }

    @Override
    public String getSArgument(int index) {
        return this.sArguments.get(index);
    }

    @Override
    public Long getIArgument(int index) {
        return this.iArguments.get(index);
    }

    @Override
    public int numIArguments() {
        return this.iArguments == null ? 0 : this.iArguments.size();
    }

    @Override
    public int numBArguments() {
        return this.bArguments == null ? 0 : this.bArguments.size();
    }

    @Override
    public void addTArgument(double ... arg) {
        if (arg != null) {
            this.addTArgument(Doubles.asList((double[])arg).toArray(new Double[arg.length]));
        }
    }

    @Override
    public void addDArgument(DataType ... arg) {
        if (this.dArguments == null) {
            this.dArguments = new ArrayList<DataType>();
        }
        if (arg != null) {
            this.dArguments.addAll(Arrays.asList(arg));
        }
    }

    private void addTArgument(Double ... arg) {
        this.tArguments.addAll(Arrays.asList(arg));
    }

    @Override
    public void removeTArgument(Double arg) {
        this.tArguments.remove(arg);
    }

    @Override
    public Double getTArgument(int index) {
        return this.tArguments.get(index);
    }

    @Override
    public int numTArguments() {
        return this.tArguments == null ? 0 : this.tArguments.size();
    }

    @Override
    public void addInputArgument(INDArray ... arg) {
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] != null) continue;
            throw new ND4JIllegalStateException("Input " + i + " was null!");
        }
        this.inputArguments.addAll(Arrays.asList(arg));
    }

    @Override
    public void removeInputArgument(INDArray arg) {
        this.inputArguments.remove(arg);
    }

    @Override
    public INDArray getInputArgument(int index) {
        if (this.inputArguments == null || index >= this.inputArguments.size()) {
            return null;
        }
        return this.inputArguments.get(index);
    }

    public void setInputArgument(int index, INDArray input) {
        if (index >= this.inputArguments.size()) {
            List<INDArray> oldArgs = this.inputArguments;
            this.inputArguments = new ArrayList<INDArray>(index + 1);
            this.inputArguments.addAll(oldArgs);
            while (this.inputArguments.size() <= index) {
                this.inputArguments.add(null);
            }
        }
        this.inputArguments.set(index, input);
    }

    public void setInputArguments(INDArray ... inputs) {
        this.inputArguments.clear();
        if (inputs != null && inputs.length > 0) {
            Collections.addAll(this.inputArguments, inputs);
        }
    }

    public void setOutputArgument(int index, INDArray output) {
        while (index >= this.outputArguments.size()) {
            this.outputArguments.add(null);
        }
        this.outputArguments.set(index, output);
    }

    @Override
    public int numInputArguments() {
        return this.inputArguments.size();
    }

    @Override
    public void addOutputArgument(INDArray ... arg) {
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] != null) continue;
            throw new ND4JIllegalStateException("Output " + i + " was null!");
        }
        this.outputArguments.addAll(Arrays.asList(arg));
    }

    @Override
    public void removeOutputArgument(INDArray arg) {
        this.outputArguments.remove(arg);
    }

    @Override
    public INDArray getOutputArgument(int index) {
        if (this.outputArguments == null || index >= this.outputArguments.size()) {
            return null;
        }
        return this.outputArguments.get(index);
    }

    @Override
    public int numOutputArguments() {
        return this.outputArguments.size();
    }

    @Override
    public int opNum() {
        return (int)this.opHash();
    }

    public static DynamicCustomOpsBuilder builder(String opName) {
        Map<String, CustomOpDescriptor> map;
        String lcName = (map = Nd4j.getExecutioner().getCustomOperations()).containsKey(opName) ? opName : opName.toLowerCase();
        CustomOpDescriptor desc = map.get(lcName);
        if (desc == null) {
            throw new ND4JIllegalStateException("Unknown operations requested: [" + opName + "]");
        }
        return new DynamicCustomOpsBuilder(lcName, desc.getHash(), desc.getNumInputs(), desc.getNumOutputs(), desc.isAllowsInplace(), desc.getNumTArgs(), desc.getNumIArgs());
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        int nIn;
        int nT;
        int nI;
        CustomOpDescriptor descriptor = this.getDescriptor();
        if (this.outputShapes != null && !this.outputShapes.isEmpty()) {
            return this.outputShapes;
        }
        if (descriptor == null) {
            throw new IllegalStateException("Could not find descriptor for op: " + this.opName() + (DynamicCustomOp.class == this.getClass() ? "" : " - class: " + this.getClass().getName()));
        }
        int n = nI = oc != null ? oc.numIArguments() : this.numIArguments();
        if (descriptor.getNumIArgs() >= 0 && nI < descriptor.getNumIArgs()) {
            if (log.isTraceEnabled()) {
                log.trace("Could not calculate output shape for op {}: not fully initialized ({} IArgs specified, {} required)", new Object[]{this.getClass().getName(), nI, descriptor.getNumIArgs()});
            }
            return Collections.emptyList();
        }
        int n2 = nT = oc != null ? oc.numTArguments() : this.numTArguments();
        if (descriptor.getNumTArgs() >= 0 && nT < descriptor.getNumTArgs()) {
            if (log.isTraceEnabled()) {
                log.trace("Could not calculate output shape for op {}: not fully initialized ({} TArgs specified, {} required)", new Object[]{this.getClass().getName(), nT, descriptor.getNumTArgs()});
            }
            return Collections.emptyList();
        }
        int n3 = nIn = oc != null ? oc.numInputArguments() : this.numInputArguments();
        if (descriptor.getNumInputs() >= 0 && nIn < descriptor.getNumInputs()) {
            if (log.isTraceEnabled()) {
                log.trace("Could not calculate output shape for op {}: not fully initialized ({} input (INDArray) args specified, {} required)", new Object[]{this.getClass().getName(), nIn, descriptor.getNumInputs()});
            }
            return Collections.emptyList();
        }
        List<LongShapeDescriptor> ret = oc == null ? Nd4j.getExecutioner().calculateOutputShape(this) : Nd4j.getExecutioner().calculateOutputShape(this, oc);
        return ret;
    }

    @Override
    public CustomOpDescriptor getDescriptor() {
        Map<String, CustomOpDescriptor> map = Nd4j.getExecutioner().getCustomOperations();
        return map.get(this.opName());
    }

    @Override
    public void assertValidForExecution() {
        CustomOpDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            throw new NoOpNameFoundException("No descriptor found for op name " + this.opName());
        }
        if (descriptor.getNumInputs() > 0 && this.numInputArguments() < descriptor.getNumInputs()) {
            if (this.sameDiff == null) {
                throw new ND4JIllegalStateException("Op [" + this.opName() + "] failure for [" + this.getOwnName() + "]: Number of inputs is invalid for execution. " + this.numInputArguments() + " were provided but " + descriptor.getNumInputs() + " are required for execution");
            }
            Object[] inputNames = this.sameDiff.getInputsForOp(this);
            Object[] arrayShapes = new String[inputNames.length];
            for (int i = 0; i < inputNames.length; ++i) {
                INDArray arr = this.sameDiff.getVariable(inputNames[i]).getArr();
                arrayShapes[i] = arr == null ? "<no array present>" : Arrays.toString(arr.shape());
            }
            throw new ND4JIllegalStateException("Op [" + this.opName() + "] failure for [" + this.getOwnName() + "]: Number of inputs is invalid for execution. " + this.numInputArguments() + " were provided but " + descriptor.getNumInputs() + " are required for execution. Input variable names: " + Arrays.toString(inputNames) + ". Input variable array shapes: " + Arrays.toString(arrayShapes));
        }
        if (descriptor.getNumOutputs() > 0 && this.numOutputArguments() < descriptor.getNumOutputs()) {
            throw new ND4JIllegalStateException("Op [" + this.opName() + "] failure for [" + this.getOwnName() + "]: Number of outputs is invalid for execution. Specified [" + this.numOutputArguments() + "] but should be [" + descriptor.getNumOutputs() + "]");
        }
        if (descriptor.getNumIArgs() >= 0 && this.numIArguments() < descriptor.getNumIArgs()) {
            throw new ND4JIllegalStateException("Op [" + this.opName() + "] failure for [" + this.getOwnName() + "]: Number of integer arguments is invalid for execution. Specified [" + this.numIArguments() + "] but should be [" + descriptor.getNumIArgs() + "]");
        }
        if (descriptor.getNumTArgs() >= 0 && this.numTArguments() < descriptor.getNumTArgs()) {
            throw new ND4JIllegalStateException("Op [" + this.opName() + "] failure for [" + this.getOwnName() + "]: Number of inputs is invalid for execution. Specified [" + this.numTArguments() + "] but should be [" + descriptor.getNumTArgs() + "]");
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Please extend DynamicCustomOp.doDiff to support SameDiff backprop operations. Op: " + this.getClass().getName());
    }

    @Override
    public String toString() {
        return this.opName();
    }

    @Override
    public boolean[] bArgs() {
        boolean[] result = new boolean[this.bArguments == null ? 0 : this.bArguments.size()];
        for (int e = 0; e < result.length; ++e) {
            result[e] = this.bArguments.get(e);
        }
        return result;
    }

    @Override
    public void addBArgument(boolean ... arg) {
        if (arg != null) {
            for (boolean b : arg) {
                this.bArguments.add(b);
            }
        }
    }

    @Override
    public Boolean getBArgument(int index) {
        return this.bArguments.get(index);
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public void clearArrays() {
        this.inputArguments.clear();
        this.outputArguments.clear();
    }

    protected static SDVariable[] wrapOrNull(SDVariable in) {
        SDVariable[] sDVariableArray;
        if (in == null) {
            sDVariableArray = null;
        } else {
            SDVariable[] sDVariableArray2 = new SDVariable[1];
            sDVariableArray = sDVariableArray2;
            sDVariableArray2[0] = in;
        }
        return sDVariableArray;
    }

    protected static INDArray[] wrapOrNull(INDArray in) {
        INDArray[] iNDArrayArray;
        if (in == null) {
            iNDArrayArray = null;
        } else {
            INDArray[] iNDArrayArray2 = new INDArray[1];
            iNDArrayArray = iNDArrayArray2;
            iNDArrayArray2[0] = in;
        }
        return iNDArrayArray;
    }

    protected static <T> T[] wrapFilterNull(T ... in) {
        int count = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            ++count;
        }
        Object[] out = (Object[])Array.newInstance(in.getClass().getComponentType(), count);
        int j = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            out[j++] = in[i];
        }
        return out;
    }

    @Override
    public void configureFromArguments() {
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        return super.mappingsForFunction();
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        super.setPropertiesForFunction(properties);
    }

    @Override
    public Object getValue(Field property) {
        return super.getValue(property);
    }

    @Override
    public void setValueFor(Field target, Object value) {
        super.setValueFor(target, value);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        OpNamespace.OpDescriptor opDescriptor = OpDescriptorHolder.descriptorForOpName(this.opName());
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (OpNamespace.ArgDescriptor argDescriptor : opDescriptor.getArgDescriptorList()) {
            switch (argDescriptor.getArgType()) {
                case STRING: {
                    if (argDescriptor.getArgIndex() >= this.numSArguments()) break;
                    ret.put(argDescriptor.getName(), this.getSArgument(argDescriptor.getArgIndex()));
                    break;
                }
                case BOOL: {
                    if (argDescriptor.getArgIndex() >= this.numBArguments()) break;
                    ret.put(argDescriptor.getName(), this.getBArgument(argDescriptor.getArgIndex()));
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    if (argDescriptor.getArgIndex() >= this.numTArguments()) break;
                    ret.put(argDescriptor.getName(), this.getTArgument(argDescriptor.getArgIndex()));
                    break;
                }
                case INT32: 
                case INT64: {
                    if (argDescriptor.getArgIndex() >= this.numIArguments()) break;
                    ret.put(argDescriptor.getName(), this.getIArgument(argDescriptor.getArgIndex()));
                    break;
                }
                case DATA_TYPE: {
                    if (argDescriptor.getArgIndex() >= this.numDArguments()) break;
                    ret.put(argDescriptor.getName(), (Object)this.dArguments.get(argDescriptor.getArgIndex()));
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isInplaceCall() {
        return this.inplaceCall;
    }

    public void setInplaceCall(boolean inplaceCall) {
        this.inplaceCall = inplaceCall;
    }

    public long getHash() {
        return this.hash;
    }

    public SDVariable[] getOutputVariables() {
        return this.outputVariables;
    }

    public void setOutputVariables(SDVariable[] outputVariables) {
        this.outputVariables = outputVariables;
    }

    public static class DynamicCustomOpsBuilder {
        protected String opName;
        protected int numInputs;
        protected int numOutputs;
        protected int numTArguments;
        protected int numIArguments;
        protected int numBArguments;
        protected int numSArguments;
        protected boolean inplaceCall;
        protected boolean inplaceAllowed;
        protected long opHash;
        protected List<LongShapeDescriptor> outputShapes = new ArrayList<LongShapeDescriptor>();
        private List<INDArray> inputArguments = new ArrayList<INDArray>();
        private List<INDArray> outputArguments = new ArrayList<INDArray>();
        private List<Double> tArguments = new ArrayList<Double>();
        private List<Long> iArguments = new ArrayList<Long>();
        private List<DataType> dArguments = new ArrayList<DataType>();
        private List<Boolean> bArguments = new ArrayList<Boolean>();
        private List<String> sArguments = new ArrayList<String>();

        protected DynamicCustomOpsBuilder(String opName, long hash, int numInputs, int numOutputs, boolean inplaceAllowed, int numTArguments, int numIArguments) {
            this(opName, hash, numInputs, numOutputs, inplaceAllowed, numTArguments, numIArguments, 0);
        }

        protected DynamicCustomOpsBuilder(String opName, long hash, int numInputs, int numOutputs, boolean inplaceAllowed, int numTArguments, int numIArguments, int numSArguments) {
            this.opHash = hash;
            this.opName = opName;
            this.numInputs = numInputs;
            this.numOutputs = numOutputs;
            this.numIArguments = numIArguments;
            this.numTArguments = numTArguments;
            this.numSArguments = numSArguments;
            this.inplaceAllowed = inplaceAllowed;
        }

        public DynamicCustomOpsBuilder addInputs(INDArray ... inputs) {
            if (this.numInputs >= 0) {
                if (inputs == null) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numInputs + " arguments. Null was passed instead.");
                }
                if (this.numInputs > inputs.length) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numInputs + " arguments, but " + inputs.length + " was passed to constructor");
                }
            }
            for (INDArray in : inputs) {
                this.inputArguments.add(in);
            }
            return this;
        }

        public DynamicCustomOpsBuilder addOutputs(INDArray ... outputs) {
            if (this.numOutputs >= 0) {
                if (outputs == null) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numOutputs + " arguments. Null was passed instead.");
                }
                if (this.numOutputs > outputs.length) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numOutputs + " arguments, but " + outputs.length + " was passed to constructor");
                }
            }
            for (INDArray in : outputs) {
                this.outputArguments.add(in);
            }
            return this;
        }

        public DynamicCustomOpsBuilder callInplace(boolean reallyCall) {
            if (reallyCall && !this.inplaceAllowed) {
                throw new ND4JIllegalStateException("Requested op can't be called inplace");
            }
            this.inplaceCall = reallyCall;
            return this;
        }

        public DynamicCustomOpsBuilder addIntegerArguments(List<Integer> iargs) {
            if (this.numIArguments >= 0) {
                if (iargs == null) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects " + this.numIArguments + " integer arguments. Null was passed instead.");
                }
                if (this.numIArguments > iargs.size()) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numIArguments + " integer arguments, but " + iargs.size() + " was passed to constructor");
                }
            }
            for (Integer in : iargs) {
                this.iArguments.add(in.longValue());
            }
            return this;
        }

        public DynamicCustomOpsBuilder addStringArguments(List<String> sArgs) {
            if (this.numSArguments >= 0) {
                if (sArgs == null) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects " + this.numSArguments + " string arguments. Null was passed instead.");
                }
                if (this.numSArguments > sArgs.size()) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numSArguments + " string arguments, but " + sArgs.size() + " was passed to constructor");
                }
            }
            for (String in : sArgs) {
                this.sArguments.add(in);
            }
            return this;
        }

        public DynamicCustomOpsBuilder addStringArguments(String arg) {
            if (this.numSArguments != 1 && this.numSArguments > 0) {
                throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects " + this.numSArguments + " string arguments. One arg was passed instead.");
            }
            this.sArguments.add(arg);
            return this;
        }

        public DynamicCustomOpsBuilder addStringArguments(String ... sArgs) {
            if (this.numSArguments >= 0) {
                if (sArgs == null) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numSArguments + " integer arguments. Null was passed instead.");
                }
                if (this.numSArguments > sArgs.length) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numSArguments + " integer arguments, but " + sArgs.length + " was passed to constructor");
                }
            }
            for (String in : sArgs) {
                this.sArguments.add(in);
            }
            return this;
        }

        public DynamicCustomOpsBuilder addIntegerArguments(long arg) {
            if (this.numIArguments != 1 && this.numIArguments > 0) {
                throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects " + this.numIArguments + " integer arguments. One arg was passed instead.");
            }
            this.iArguments.add(arg);
            return this;
        }

        public DynamicCustomOpsBuilder addIntegerArguments(int ... iargs) {
            if (this.numIArguments >= 0) {
                if (iargs == null) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numIArguments + " integer arguments. Null was passed instead.");
                }
                if (this.numIArguments > iargs.length) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numIArguments + " integer arguments, but " + iargs.length + " was passed to constructor");
                }
            }
            for (int in : iargs) {
                this.iArguments.add(Long.valueOf(in));
            }
            return this;
        }

        public DynamicCustomOpsBuilder addBooleanArguments(boolean ... bargs) {
            for (boolean in : bargs) {
                this.bArguments.add(in);
            }
            return this;
        }

        public DynamicCustomOpsBuilder addFloatingPointArguments(Double ... targs) {
            if (this.numTArguments >= 0) {
                if (targs == null) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numTArguments + " integer arguments. Null was passed instead.");
                }
                if (this.numTArguments > targs.length) {
                    throw new ND4JIllegalStateException("CustomOp [" + this.opName + "] expects at least " + this.numTArguments + " integer arguments, but " + targs.length + " was passed to constructor");
                }
            }
            for (Double in : targs) {
                this.tArguments.add(in);
            }
            return this;
        }

        public DynamicCustomOpsBuilder addOutputShape(LongShapeDescriptor shape) {
            this.outputShapes.add(shape);
            return this;
        }

        public DynamicCustomOp build() {
            DynamicCustomOp result = new DynamicCustomOp(this.opName);
            result.inputArguments = this.inputArguments;
            result.outputArguments = this.outputArguments;
            result.iArguments = this.iArguments;
            result.tArguments = this.tArguments;
            result.bArguments = this.bArguments;
            result.dArguments = this.dArguments;
            result.inplaceCall = this.inplaceCall;
            result.hash = this.opHash;
            result.outputShapes = this.outputShapes;
            return result;
        }

        public int getNumOutputs() {
            return -1;
        }
    }
}

