/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pooling3DDerivative
extends Pooling3D {
    private static final Logger log = LoggerFactory.getLogger(Pooling3DDerivative.class);

    public Pooling3DDerivative(SameDiff sameDiff, SDVariable[] inputs, INDArray[] inputArrays, INDArray[] outputs, boolean inPlace, Pooling3DConfig pooling3DConfig, Pooling3D.Pooling3DType type) {
        super(sameDiff, inputs, inputArrays, outputs, inPlace, pooling3DConfig, type);
    }

    @Override
    public String opName() {
        return this.getPoolingPrefix() + "pool3dnew_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to take derivative of derivative.");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 input data types for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Pooling3DDerivativeBuilder derivativeBuilder() {
        return new Pooling3DDerivativeBuilder();
    }

    public Pooling3DDerivative() {
    }

    public static class Pooling3DDerivativeBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private boolean inPlace;
        private Pooling3DConfig pooling3DConfig;
        private Pooling3D.Pooling3DType type;

        Pooling3DDerivativeBuilder() {
        }

        public Pooling3DDerivativeBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Pooling3DDerivativeBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Pooling3DDerivativeBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Pooling3DDerivativeBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Pooling3DDerivativeBuilder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        public Pooling3DDerivativeBuilder pooling3DConfig(Pooling3DConfig pooling3DConfig) {
            this.pooling3DConfig = pooling3DConfig;
            return this;
        }

        public Pooling3DDerivativeBuilder type(Pooling3D.Pooling3DType type) {
            this.type = type;
            return this;
        }

        public Pooling3DDerivative build() {
            return new Pooling3DDerivative(this.sameDiff, this.inputs, this.inputArrays, this.outputs, this.inPlace, this.pooling3DConfig, this.type);
        }

        public String toString() {
            return "Pooling3DDerivative.Pooling3DDerivativeBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", inPlace=" + this.inPlace + ", pooling3DConfig=" + this.pooling3DConfig + ", type=" + (Object)((Object)this.type) + ")";
        }
    }
}

