/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMActivations;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMDataFormat;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMDirectionMode;

public class LSTMLayerConfig {
    private LSTMDataFormat lstmdataformat;
    private LSTMDirectionMode directionMode;
    private LSTMActivations gateAct;
    private LSTMActivations cellAct;
    private LSTMActivations outAct;
    private boolean retFullSequence;
    private boolean retLastH;
    private boolean retLastC;
    private double cellClip;

    public Map<String, Object> toProperties(boolean includeLSTMDataFormat, boolean includeLSTMDirectionMode) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("gateAct", this.gateAct.toString());
        ret.put("outAct", this.outAct.toString());
        ret.put("cellAct", this.cellAct.toString());
        ret.put("retFullSequence", this.retFullSequence);
        ret.put("retLastH", this.retLastH);
        ret.put("retLastC", this.retLastC);
        ret.put("cellClip", this.cellClip);
        if (includeLSTMDataFormat) {
            ret.put("lstmdataformat", this.lstmdataformat.toString());
        }
        if (includeLSTMDirectionMode) {
            ret.put("directionMode", this.directionMode.toString());
        }
        return ret;
    }

    private static LSTMDataFormat $default$lstmdataformat() {
        return LSTMDataFormat.TNS;
    }

    private static LSTMDirectionMode $default$directionMode() {
        return LSTMDirectionMode.FWD;
    }

    private static LSTMActivations $default$gateAct() {
        return LSTMActivations.SIGMOID;
    }

    private static LSTMActivations $default$cellAct() {
        return LSTMActivations.TANH;
    }

    private static LSTMActivations $default$outAct() {
        return LSTMActivations.TANH;
    }

    private static boolean $default$retFullSequence() {
        return true;
    }

    private static double $default$cellClip() {
        return 0.0;
    }

    public static LSTMLayerConfigBuilder builder() {
        return new LSTMLayerConfigBuilder();
    }

    public LSTMDataFormat getLstmdataformat() {
        return this.lstmdataformat;
    }

    public LSTMDirectionMode getDirectionMode() {
        return this.directionMode;
    }

    public LSTMActivations getGateAct() {
        return this.gateAct;
    }

    public LSTMActivations getCellAct() {
        return this.cellAct;
    }

    public LSTMActivations getOutAct() {
        return this.outAct;
    }

    public boolean isRetFullSequence() {
        return this.retFullSequence;
    }

    public boolean isRetLastH() {
        return this.retLastH;
    }

    public boolean isRetLastC() {
        return this.retLastC;
    }

    public double getCellClip() {
        return this.cellClip;
    }

    public void setLstmdataformat(LSTMDataFormat lstmdataformat) {
        this.lstmdataformat = lstmdataformat;
    }

    public void setDirectionMode(LSTMDirectionMode directionMode) {
        this.directionMode = directionMode;
    }

    public void setGateAct(LSTMActivations gateAct) {
        this.gateAct = gateAct;
    }

    public void setCellAct(LSTMActivations cellAct) {
        this.cellAct = cellAct;
    }

    public void setOutAct(LSTMActivations outAct) {
        this.outAct = outAct;
    }

    public void setRetFullSequence(boolean retFullSequence) {
        this.retFullSequence = retFullSequence;
    }

    public void setRetLastH(boolean retLastH) {
        this.retLastH = retLastH;
    }

    public void setRetLastC(boolean retLastC) {
        this.retLastC = retLastC;
    }

    public void setCellClip(double cellClip) {
        this.cellClip = cellClip;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LSTMLayerConfig)) {
            return false;
        }
        LSTMLayerConfig other = (LSTMLayerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRetFullSequence() != other.isRetFullSequence()) {
            return false;
        }
        if (this.isRetLastH() != other.isRetLastH()) {
            return false;
        }
        if (this.isRetLastC() != other.isRetLastC()) {
            return false;
        }
        if (Double.compare(this.getCellClip(), other.getCellClip()) != 0) {
            return false;
        }
        LSTMDataFormat this$lstmdataformat = this.getLstmdataformat();
        LSTMDataFormat other$lstmdataformat = other.getLstmdataformat();
        if (this$lstmdataformat == null ? other$lstmdataformat != null : !((Object)((Object)this$lstmdataformat)).equals((Object)other$lstmdataformat)) {
            return false;
        }
        LSTMDirectionMode this$directionMode = this.getDirectionMode();
        LSTMDirectionMode other$directionMode = other.getDirectionMode();
        if (this$directionMode == null ? other$directionMode != null : !((Object)((Object)this$directionMode)).equals((Object)other$directionMode)) {
            return false;
        }
        LSTMActivations this$gateAct = this.getGateAct();
        LSTMActivations other$gateAct = other.getGateAct();
        if (this$gateAct == null ? other$gateAct != null : !((Object)((Object)this$gateAct)).equals((Object)other$gateAct)) {
            return false;
        }
        LSTMActivations this$cellAct = this.getCellAct();
        LSTMActivations other$cellAct = other.getCellAct();
        if (this$cellAct == null ? other$cellAct != null : !((Object)((Object)this$cellAct)).equals((Object)other$cellAct)) {
            return false;
        }
        LSTMActivations this$outAct = this.getOutAct();
        LSTMActivations other$outAct = other.getOutAct();
        return !(this$outAct == null ? other$outAct != null : !((Object)((Object)this$outAct)).equals((Object)other$outAct));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LSTMLayerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRetFullSequence() ? 79 : 97);
        result = result * 59 + (this.isRetLastH() ? 79 : 97);
        result = result * 59 + (this.isRetLastC() ? 79 : 97);
        long $cellClip = Double.doubleToLongBits(this.getCellClip());
        result = result * 59 + (int)($cellClip >>> 32 ^ $cellClip);
        LSTMDataFormat $lstmdataformat = this.getLstmdataformat();
        result = result * 59 + ($lstmdataformat == null ? 43 : ((Object)((Object)$lstmdataformat)).hashCode());
        LSTMDirectionMode $directionMode = this.getDirectionMode();
        result = result * 59 + ($directionMode == null ? 43 : ((Object)((Object)$directionMode)).hashCode());
        LSTMActivations $gateAct = this.getGateAct();
        result = result * 59 + ($gateAct == null ? 43 : ((Object)((Object)$gateAct)).hashCode());
        LSTMActivations $cellAct = this.getCellAct();
        result = result * 59 + ($cellAct == null ? 43 : ((Object)((Object)$cellAct)).hashCode());
        LSTMActivations $outAct = this.getOutAct();
        result = result * 59 + ($outAct == null ? 43 : ((Object)((Object)$outAct)).hashCode());
        return result;
    }

    public String toString() {
        return "LSTMLayerConfig(lstmdataformat=" + (Object)((Object)this.getLstmdataformat()) + ", directionMode=" + (Object)((Object)this.getDirectionMode()) + ", gateAct=" + (Object)((Object)this.getGateAct()) + ", cellAct=" + (Object)((Object)this.getCellAct()) + ", outAct=" + (Object)((Object)this.getOutAct()) + ", retFullSequence=" + this.isRetFullSequence() + ", retLastH=" + this.isRetLastH() + ", retLastC=" + this.isRetLastC() + ", cellClip=" + this.getCellClip() + ")";
    }

    public LSTMLayerConfig(LSTMDataFormat lstmdataformat, LSTMDirectionMode directionMode, LSTMActivations gateAct, LSTMActivations cellAct, LSTMActivations outAct, boolean retFullSequence, boolean retLastH, boolean retLastC, double cellClip) {
        this.lstmdataformat = lstmdataformat;
        this.directionMode = directionMode;
        this.gateAct = gateAct;
        this.cellAct = cellAct;
        this.outAct = outAct;
        this.retFullSequence = retFullSequence;
        this.retLastH = retLastH;
        this.retLastC = retLastC;
        this.cellClip = cellClip;
    }

    public LSTMLayerConfig() {
        this.lstmdataformat = LSTMLayerConfig.$default$lstmdataformat();
        this.directionMode = LSTMLayerConfig.$default$directionMode();
        this.gateAct = LSTMLayerConfig.$default$gateAct();
        this.cellAct = LSTMLayerConfig.$default$cellAct();
        this.outAct = LSTMLayerConfig.$default$outAct();
        this.retFullSequence = LSTMLayerConfig.$default$retFullSequence();
        this.cellClip = LSTMLayerConfig.$default$cellClip();
    }

    public static class LSTMLayerConfigBuilder {
        private boolean lstmdataformat$set;
        private LSTMDataFormat lstmdataformat$value;
        private boolean directionMode$set;
        private LSTMDirectionMode directionMode$value;
        private boolean gateAct$set;
        private LSTMActivations gateAct$value;
        private boolean cellAct$set;
        private LSTMActivations cellAct$value;
        private boolean outAct$set;
        private LSTMActivations outAct$value;
        private boolean retFullSequence$set;
        private boolean retFullSequence$value;
        private boolean retLastH;
        private boolean retLastC;
        private boolean cellClip$set;
        private double cellClip$value;

        LSTMLayerConfigBuilder() {
        }

        public LSTMLayerConfigBuilder lstmdataformat(LSTMDataFormat lstmdataformat) {
            this.lstmdataformat$value = lstmdataformat;
            this.lstmdataformat$set = true;
            return this;
        }

        public LSTMLayerConfigBuilder directionMode(LSTMDirectionMode directionMode) {
            this.directionMode$value = directionMode;
            this.directionMode$set = true;
            return this;
        }

        public LSTMLayerConfigBuilder gateAct(LSTMActivations gateAct) {
            this.gateAct$value = gateAct;
            this.gateAct$set = true;
            return this;
        }

        public LSTMLayerConfigBuilder cellAct(LSTMActivations cellAct) {
            this.cellAct$value = cellAct;
            this.cellAct$set = true;
            return this;
        }

        public LSTMLayerConfigBuilder outAct(LSTMActivations outAct) {
            this.outAct$value = outAct;
            this.outAct$set = true;
            return this;
        }

        public LSTMLayerConfigBuilder retFullSequence(boolean retFullSequence) {
            this.retFullSequence$value = retFullSequence;
            this.retFullSequence$set = true;
            return this;
        }

        public LSTMLayerConfigBuilder retLastH(boolean retLastH) {
            this.retLastH = retLastH;
            return this;
        }

        public LSTMLayerConfigBuilder retLastC(boolean retLastC) {
            this.retLastC = retLastC;
            return this;
        }

        public LSTMLayerConfigBuilder cellClip(double cellClip) {
            this.cellClip$value = cellClip;
            this.cellClip$set = true;
            return this;
        }

        public LSTMLayerConfig build() {
            LSTMDataFormat lstmdataformat$value = this.lstmdataformat$value;
            if (!this.lstmdataformat$set) {
                lstmdataformat$value = LSTMLayerConfig.$default$lstmdataformat();
            }
            LSTMDirectionMode directionMode$value = this.directionMode$value;
            if (!this.directionMode$set) {
                directionMode$value = LSTMLayerConfig.$default$directionMode();
            }
            LSTMActivations gateAct$value = this.gateAct$value;
            if (!this.gateAct$set) {
                gateAct$value = LSTMLayerConfig.$default$gateAct();
            }
            LSTMActivations cellAct$value = this.cellAct$value;
            if (!this.cellAct$set) {
                cellAct$value = LSTMLayerConfig.$default$cellAct();
            }
            LSTMActivations outAct$value = this.outAct$value;
            if (!this.outAct$set) {
                outAct$value = LSTMLayerConfig.$default$outAct();
            }
            boolean retFullSequence$value = this.retFullSequence$value;
            if (!this.retFullSequence$set) {
                retFullSequence$value = LSTMLayerConfig.$default$retFullSequence();
            }
            double cellClip$value = this.cellClip$value;
            if (!this.cellClip$set) {
                cellClip$value = LSTMLayerConfig.$default$cellClip();
            }
            return new LSTMLayerConfig(lstmdataformat$value, directionMode$value, gateAct$value, cellAct$value, outAct$value, retFullSequence$value, this.retLastH, this.retLastC, cellClip$value);
        }

        public String toString() {
            return "LSTMLayerConfig.LSTMLayerConfigBuilder(lstmdataformat$value=" + (Object)((Object)this.lstmdataformat$value) + ", directionMode$value=" + (Object)((Object)this.directionMode$value) + ", gateAct$value=" + (Object)((Object)this.gateAct$value) + ", cellAct$value=" + (Object)((Object)this.cellAct$value) + ", outAct$value=" + (Object)((Object)this.outAct$value) + ", retFullSequence$value=" + this.retFullSequence$value + ", retLastH=" + this.retLastH + ", retLastC=" + this.retLastC + ", cellClip$value=" + this.cellClip$value + ")";
        }
    }
}

