/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.reduce.bp.MeanBp;
import org.nd4j.linalg.api.ops.impl.reduce.bp.VarianceBp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.guava.primitives.Ints;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Moments
extends DynamicCustomOp {
    private boolean keepDims;

    public Moments() {
    }

    public Moments(@NonNull INDArray input, boolean keepDims, int ... dimensions) {
        super(new INDArray[]{input}, null);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.dimensions = dimensions;
        this.keepDims = keepDims;
        this.addArgs();
    }

    public Moments(@NonNull INDArray input, int ... dimensions) {
        super(new INDArray[]{input}, null);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.dimensions = dimensions;
        this.addArgs();
    }

    public Moments(SameDiff sameDiff, SDVariable input) {
        this(sameDiff, input, null);
        this.addArgs();
    }

    public Moments(SameDiff sameDiff, SDVariable input, int[] axes) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        this.dimensions = axes;
        this.addArgs();
    }

    public Moments(INDArray in, INDArray outMean, INDArray outStd, int ... axes) {
        super(null, new INDArray[]{in}, new INDArray[]{outMean, outStd}, null, axes);
        this.dimensions = axes;
        this.addArgs();
    }

    public Moments(INDArray input, int[] axes, boolean keepDims) {
        super(null, new INDArray[]{input}, null);
        this.keepDims = keepDims;
        this.dimensions = axes;
        this.addArgs();
    }

    public Moments(INDArray input, INDArray axes, boolean keepDims) {
        super(null, new INDArray[]{input, axes}, null);
        this.keepDims = keepDims;
        this.addArgs();
    }

    public Moments(SameDiff sd, SDVariable input, int[] axes, boolean keepDims) {
        super(null, sd, new SDVariable[]{input}, false);
        this.keepDims = keepDims;
        this.dimensions = axes;
        this.addArgs();
    }

    public Moments(SameDiff sd, SDVariable input, SDVariable axes, boolean keepDims) {
        super(null, sd, new SDVariable[]{input, axes}, false);
        this.keepDims = keepDims;
        this.addArgs();
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public String opName() {
        return "moments";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable dLdMean = grad.get(0);
        SDVariable dLdVar = grad.get(1);
        if (this.dimensions != null) {
            SDVariable meanBp = new MeanBp(this.sameDiff, this.arg(), dLdMean, this.keepDims, this.dimensions).outputVariable();
            SDVariable varBp = new VarianceBp(this.sameDiff, this.arg(), dLdVar, false, this.keepDims, this.dimensions).outputVariable();
            return Collections.singletonList(meanBp.add(varBp));
        }
        if (this.numIArguments() > 0) {
            int[] newDimensions = Ints.toArray((Collection)this.iArguments);
            this.dimensions = newDimensions;
            SDVariable meanBp = new MeanBp(this.sameDiff, this.arg(), dLdMean, this.keepDims, newDimensions).outputVariable();
            SDVariable varBp = new VarianceBp(this.sameDiff, this.arg(), dLdVar, false, this.keepDims, newDimensions).outputVariable();
            return Collections.singletonList(meanBp.add(varBp));
        }
        if (this.numInputArguments() > 1) {
            SDVariable meanBp = new MeanBp(this.sameDiff, this.arg(), dLdMean, this.keepDims, this.arg(1)).outputVariable();
            SDVariable varBp = new VarianceBp(this.sameDiff, this.arg(), dLdVar, false, this.keepDims, this.arg(1)).outputVariable();
            return Collections.singletonList(meanBp.add(varBp));
        }
        SDVariable meanBp = new MeanBp(this.sameDiff, this.arg(), dLdMean, this.keepDims, this.dimensions).outputVariable();
        SDVariable varBp = new VarianceBp(this.sameDiff, this.arg(), dLdVar, false, this.keepDims, this.dimensions).outputVariable();
        return Collections.singletonList(meanBp.add(varBp));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 datatype for %s, got %s", this.getClass(), dataTypes);
        if (dataTypes.get(0).isFPType()) {
            return Arrays.asList(dataTypes.get(0), dataTypes.get(0));
        }
        return Arrays.asList(Nd4j.defaultFloatingPointType(), Nd4j.defaultFloatingPointType());
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("keepDims", this.keepDims);
        properties.put("dimensions", this.dimensions);
        return properties;
    }

    protected void addArgs() {
        this.addBArgument(this.keepDims);
        if (this.dimensions != null && this.dimensions.length > 0 && (this.dimensions.length != 1 || this.dimensions[0] != Integer.MAX_VALUE)) {
            this.addIArgument(this.dimensions);
        }
    }
}

