/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.shade.guava.primitives.Ints;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Transpose
extends DynamicCustomOp {
    protected int[] permuteDims;

    public Transpose(SameDiff sameDiff, SDVariable i_v) {
        super(null, sameDiff, new SDVariable[]{i_v});
    }

    public Transpose(SameDiff sameDiff, SDVariable in, int[] permuteDims) {
        super(null, sameDiff, new SDVariable[]{in});
        this.permuteDims = permuteDims;
    }

    protected Transpose(SameDiff sameDiff, SDVariable in, SDVariable permuteDims) {
        super(null, sameDiff, new SDVariable[]{in, permuteDims});
    }

    public Transpose(INDArray input, INDArray result) {
        INDArray[] iNDArrayArray;
        INDArray[] iNDArrayArray2 = new INDArray[]{input};
        if (result == null) {
            iNDArrayArray = null;
        } else {
            INDArray[] iNDArrayArray3 = new INDArray[1];
            iNDArrayArray = iNDArrayArray3;
            iNDArrayArray3[0] = result;
        }
        super(null, iNDArrayArray2, iNDArrayArray, null, (List<Integer>)null);
    }

    public Transpose(INDArray input) {
        this(input, null);
    }

    public Transpose() {
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        LinkedHashMap<String, Map<String, PropertyMapping>> ret = new LinkedHashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> map = new LinkedHashMap<String, PropertyMapping>();
        PropertyMapping mapping = PropertyMapping.builder().onnxAttrName("perm").propertyNames(new String[]{"permuteDims"}).tfInputPosition(1).build();
        map.put("permuteDims", mapping);
        ret.put(this.tensorflowName(), map);
        ret.put(this.onnxName(), map);
        return ret;
    }

    @Override
    public String opName() {
        return "transpose";
    }

    @Override
    public String onnxName() {
        return "Transpose";
    }

    @Override
    public String tensorflowName() {
        return "Transpose";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        if (nodeDef.getInputCount() < 2) {
            return;
        }
        NodeDef permuteDimsNode = null;
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            if (!graph.getNode(i).getName().equals(nodeDef.getInput(1))) continue;
            permuteDimsNode = graph.getNode(i);
        }
        INDArray permuteArrayOp = TFGraphMapper.getNDArrayFromTensor(permuteDimsNode);
        if (permuteArrayOp != null) {
            this.permuteDims = permuteArrayOp.data().asInt();
        }
        if (this.arg().getShape() == null || this.arg().getVariableType() == VariableType.PLACEHOLDER || this.arg().getArr() == null) {
            return;
        }
        INDArray arr = this.sameDiff.getArrForVarName(this.arg().name());
        if (permuteArrayOp != null) {
            this.addInputArgument(arr, permuteArrayOp);
        } else {
            this.addInputArgument(arr);
        }
        if (arr != null && this.permuteDims == null) {
            this.permuteDims = ArrayUtil.reverseCopy((int[])ArrayUtil.range((int)0, (int)arr.rank()));
        }
        if (this.permuteDims != null && this.permuteDims.length < this.arg().getShape().length) {
            throw new ND4JIllegalStateException("Illegal permute found. Not all dimensions specified");
        }
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
        if (attributesForNode.containsKey("perm")) {
            this.permuteDims = Ints.toArray(attributesForNode.get("perm").getIntsList());
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret;
        if (this.permuteDims == null) {
            ret = this.sameDiff.transpose(i_v.get(0));
        } else {
            int[] reverse = ArrayUtil.invertPermutation((int[])this.permuteDims);
            ret = this.sameDiff.permute(i_v.get(0), reverse);
        }
        return Collections.singletonList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && (dataTypes.size() == 1 || dataTypes.size() == 2) ? 1 : 0) != 0, (String)"Expected list with 1 or 2 datatype for %s, got %s", this.getClass(), dataTypes);
        if (this.dArguments != null && !this.dArguments.isEmpty()) {
            return Collections.singletonList(this.dArguments.get(0));
        }
        return Collections.singletonList(dataTypes.get(0));
    }
}

