/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class RandomShuffle
extends DynamicCustomOp {
    public RandomShuffle(@NonNull INDArray value, int ... seeds) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.addInputArgument(value);
        this.addIArgument(seeds);
    }

    public RandomShuffle(@NonNull INDArray value) {
        this(value, 0, 0);
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public RandomShuffle(@NonNull SameDiff sameDiff, @NonNull SDVariable value, int ... seeds) {
        super(null, sameDiff, new SDVariable[]{value});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.addIArgument(seeds);
    }

    @Override
    public String opName() {
        return "random_shuffle";
    }

    @Override
    public String tensorflowName() {
        return "RandomShuffle";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public RandomShuffle() {
    }
}

