/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.util.Arrays;
import java.util.Map;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.AdaMaxUpdater;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class AdaMax
implements IUpdater {
    public static final double DEFAULT_ADAMAX_LEARNING_RATE = 0.001;
    public static final double DEFAULT_ADAMAX_EPSILON = 1.0E-8;
    public static final double DEFAULT_ADAMAX_BETA1_MEAN_DECAY = 0.9;
    public static final double DEFAULT_ADAMAX_BETA2_VAR_DECAY = 0.999;
    private double learningRate = 0.001;
    private ISchedule learningRateSchedule;
    private double beta1 = 0.9;
    private double beta2 = 0.999;
    private double epsilon = 1.0E-8;

    public AdaMax() {
        this(0.001);
    }

    public AdaMax(double learningRate) {
        this(learningRate, null, 0.9, 0.999, 1.0E-8);
    }

    public AdaMax(ISchedule learningRateSchedule) {
        this(Double.NaN, learningRateSchedule, 0.9, 0.999, 1.0E-8);
    }

    public AdaMax(double learningRate, double beta1, double beta2, double epsilon) {
        this(learningRate, null, beta1, beta2, epsilon);
    }

    private AdaMax(@JsonProperty(value="learningRate") double learningRate, @JsonProperty(value="learningRateSchedule") ISchedule learningRateSchedule, @JsonProperty(value="beta1") double beta1, @JsonProperty(value="beta2") double beta2, @JsonProperty(value="epsilon") double epsilon) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
    }

    @Override
    public long stateSize(long numParams) {
        return 2L * numParams;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        AdaMaxUpdater a = new AdaMaxUpdater(this);
        long[] gradientShape = viewArray.shape();
        gradientShape = Arrays.copyOf(gradientShape, gradientShape.length);
        gradientShape[1] = gradientShape[1] / 2L;
        a.setStateViewArray(viewArray, gradientShape, viewArray.ordering(), initializeViewArray);
        return a;
    }

    @Override
    public GradientUpdater instantiate(Map<String, INDArray> updaterState, boolean initializeStateArrays) {
        AdaMaxUpdater u = new AdaMaxUpdater(this);
        u.setState(updaterState, initializeStateArrays);
        return u;
    }

    @Override
    public IUpdater clone() {
        return new AdaMax(this.learningRate, this.learningRateSchedule, this.beta1, this.beta2, this.epsilon);
    }

    @Override
    public double getLearningRate(int iteration, int epoch) {
        if (this.learningRateSchedule != null) {
            return this.learningRateSchedule.valueAt(iteration, epoch);
        }
        return this.learningRate;
    }

    @Override
    public boolean hasLearningRate() {
        return true;
    }

    @Override
    public void setLrAndSchedule(double lr, ISchedule lrSchedule) {
        this.learningRate = lr;
        this.learningRateSchedule = lrSchedule;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public ISchedule getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public double getBeta1() {
        return this.beta1;
    }

    public double getBeta2() {
        return this.beta2;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ISchedule learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setBeta1(double beta1) {
        this.beta1 = beta1;
    }

    public void setBeta2(double beta2) {
        this.beta2 = beta2;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaMax)) {
            return false;
        }
        AdaMax other = (AdaMax)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta1(), other.getBeta1()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta2(), other.getBeta2()) != 0) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        ISchedule this$learningRateSchedule = this.getLearningRateSchedule();
        ISchedule other$learningRateSchedule = other.getLearningRateSchedule();
        return !(this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaMax;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $beta1 = Double.doubleToLongBits(this.getBeta1());
        result = result * 59 + (int)($beta1 >>> 32 ^ $beta1);
        long $beta2 = Double.doubleToLongBits(this.getBeta2());
        result = result * 59 + (int)($beta2 >>> 32 ^ $beta2);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        ISchedule $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        return result;
    }

    public String toString() {
        return "AdaMax(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", beta1=" + this.getBeta1() + ", beta2=" + this.getBeta2() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public static class Builder {
    }
}

