/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.tools;

import java.util.Properties;

public class PropertyParser {
    private Properties properties;

    public PropertyParser(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String parseString(String name) {
        String property = this.getProperties().getProperty(name);
        if (property == null) {
            throw new NullPointerException();
        }
        return property;
    }

    public int parseInt(String name) {
        return Integer.parseInt(this.getProperties().getProperty(name));
    }

    public boolean parseBoolean(String name) {
        String property = this.getProperties().getProperty(name);
        if (property == null) {
            throw new IllegalArgumentException();
        }
        return Boolean.parseBoolean(property);
    }

    public float parseFloat(String name) {
        return Float.parseFloat(this.getProperties().getProperty(name));
    }

    public double parseDouble(String name) {
        return Double.parseDouble(this.getProperties().getProperty(name));
    }

    public long parseLong(String name) {
        return Long.parseLong(this.getProperties().getProperty(name));
    }

    public char parseChar(String name) {
        String property = this.getProperties().getProperty(name);
        if (property.length() != 1) {
            throw new IllegalArgumentException(name + " property is't char");
        }
        return property.charAt(0);
    }

    public String toString(String name) {
        return this.toString(name, "");
    }

    public int toInt(String name) {
        return this.toInt(name, 0);
    }

    public boolean toBoolean(String name) {
        return this.toBoolean(name, false);
    }

    public float toFloat(String name) {
        return this.toFloat(name, 0.0f);
    }

    public double toDouble(String name) {
        return this.toDouble(name, 0.0);
    }

    public long toLong(String name) {
        return this.toLong(name, 0L);
    }

    public char toChar(String name) {
        return this.toChar(name, '\u0000');
    }

    public String toString(String name, String defaultValue) {
        String property = this.getProperties().getProperty(name);
        return property != null ? property : defaultValue;
    }

    public int toInt(String name, int defaultValue) {
        try {
            return this.parseInt(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean toBoolean(String name, boolean defaultValue) {
        String property = this.getProperties().getProperty(name);
        return property != null ? Boolean.parseBoolean(property) : defaultValue;
    }

    public float toFloat(String name, float defaultValue) {
        try {
            return this.parseFloat(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double toDouble(String name, double defaultValue) {
        try {
            return this.parseDouble(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long toLong(String name, long defaultValue) {
        try {
            return this.parseLong(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public char toChar(String name, char defaultValue) {
        try {
            return this.parseChar(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

