/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v1;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.messaging.AbstractMessageWriter;
import org.neo4j.driver.internal.messaging.MessageEncoder;
import org.neo4j.driver.internal.messaging.ValuePacker;
import org.neo4j.driver.internal.messaging.encode.DiscardAllMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.InitMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.PullAllMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.ResetMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.RunMessageEncoder;
import org.neo4j.driver.internal.messaging.v1.ValuePackerV1;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.util.Iterables;

public class MessageWriterV1
extends AbstractMessageWriter {
    public MessageWriterV1(PackOutput output) {
        this(new ValuePackerV1(output));
    }

    protected MessageWriterV1(ValuePacker packer) {
        super(packer, MessageWriterV1.buildEncoders());
    }

    private static Map<Byte, MessageEncoder> buildEncoders() {
        HashMap<Byte, MessageEncoder> result = Iterables.newHashMapWithSize(6);
        result.put((byte)47, new DiscardAllMessageEncoder());
        result.put((byte)1, new InitMessageEncoder());
        result.put((byte)63, new PullAllMessageEncoder());
        result.put((byte)15, new ResetMessageEncoder());
        result.put((byte)16, new RunMessageEncoder());
        return result;
    }
}

