/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="2020.1.0")
public final class ListOperator
implements Expression {
    private static final Literal<String> DOTS = new Literal<String>(".."){

        @Override
        public String asString() {
            return (String)super.getContent();
        }
    };
    private final Expression targetExpression;
    private final Details details;

    static ListOperator subList(Expression targetExpression, Expression start, Expression end) {
        Assertions.notNull(targetExpression, "The range's target expression must not be null.");
        Assertions.notNull(start, "The start of the range must not be null.");
        Assertions.notNull(end, "The end of the range must not be null.");
        return new ListOperator(targetExpression, start, DOTS, end);
    }

    static ListOperator subListFrom(Expression targetExpression, Expression start) {
        Assertions.notNull(targetExpression, "The range's target expression must not be null.");
        Assertions.notNull(start, "The start of the range must not be null.");
        return new ListOperator(targetExpression, start, DOTS, null);
    }

    static ListOperator subListUntil(Expression targetExpression, Expression end) {
        Assertions.notNull(targetExpression, "The range's target expression must not be null.");
        Assertions.notNull(end, "The end of the range must not be null.");
        return new ListOperator(targetExpression, null, DOTS, end);
    }

    static ListOperator valueAt(Expression targetExpression, Expression index) {
        Assertions.notNull(targetExpression, "The range's target expression must not be null.");
        Assertions.notNull(index, "The index of the range must not be null.");
        return new ListOperator(targetExpression, index, null, null);
    }

    private ListOperator(Expression targetExpression, Expression optionalStart, Literal<String> dots, Expression optionalEnd) {
        this.targetExpression = targetExpression;
        this.details = new Details(optionalStart, dots, optionalEnd);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.targetExpression.accept(visitor);
        this.details.accept(visitor);
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static final class Details
    implements Visitable {
        private final Expression optionalStart;
        private final Literal<String> dots;
        private final Expression optionalEnd;

        Details(Expression optionalStart, Literal<String> dots, Expression optionalEnd) {
            this.optionalStart = optionalStart;
            this.dots = dots;
            this.optionalEnd = optionalEnd;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            Visitable.visitIfNotNull(this.optionalStart, visitor);
            Visitable.visitIfNotNull(this.dots, visitor);
            Visitable.visitIfNotNull(this.optionalEnd, visitor);
            visitor.leave(this);
        }
    }
}

