/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.MultiPartQuery;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.SinglePartQuery;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.UnionQuery;
import org.neo4j.cypherdsl.core.support.Neo4jVersion;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="2020.1.2")
@Neo4jVersion(minimum="4.0.0")
public final class Subquery
implements Visitable {
    private final Statement statement;

    static Subquery call(Statement statement) {
        boolean validReturn = false;
        if (statement instanceof SinglePartQuery) {
            validReturn = ((SinglePartQuery)statement).doesReturnElements();
        } else if (statement instanceof MultiPartQuery) {
            validReturn = ((MultiPartQuery)statement).doesReturnElements();
        } else if (statement instanceof ProcedureCall) {
            validReturn = ((ProcedureCall)statement).doesReturnElements();
        } else if (statement instanceof UnionQuery) {
            validReturn = true;
        }
        if (!validReturn) {
            throw new IllegalArgumentException("Only a statement that returns elements, either via RETURN or YIELD, can be used in a subquery.");
        }
        return new Subquery(statement);
    }

    Subquery(Statement statement) {
        this.statement = statement;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.statement.accept(visitor);
        visitor.leave(this);
    }
}

