/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;

@API(status=API.Status.INTERNAL, since="1.0")
final class Pattern
extends TypedSubtree<PatternElement> {
    static Pattern of(PatternElement requiredPattern, PatternElement ... patternElement) {
        List<PatternElement> elements;
        if (patternElement == null || patternElement.length == 0) {
            elements = List.of(requiredPattern);
        } else {
            elements = new ArrayList<PatternElement>();
            elements.add(requiredPattern);
            elements.addAll(Arrays.asList(patternElement));
        }
        return Pattern.of(elements);
    }

    static Pattern of(Collection<? extends PatternElement> elements) {
        return new Pattern(elements.stream().map(PatternElement.class::cast).toList());
    }

    private Pattern(List<PatternElement> patternElements) {
        super(patternElements);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

