/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.Eggg;
import org.noear.eggg.ExecutableEggg;
import org.noear.eggg.ParamEggg;

public class ConstrEggg
implements ExecutableEggg {
    private final ClassEggg ownerEggg;
    private final Executable constr;
    private final boolean isCreator;
    private final Object digest;
    private final Map<String, ParamEggg> paramAliasMap;
    private final List<ParamEggg> paramAry;
    private final boolean security;
    private Annotation[] annotations;

    public ConstrEggg(Eggg eggg, ClassEggg ownerEggg, Executable constr, boolean isCreator) {
        Objects.requireNonNull(eggg, "eggg");
        Objects.requireNonNull(ownerEggg, "ownerEggg");
        Objects.requireNonNull(constr, "constr");
        this.ownerEggg = ownerEggg;
        this.constr = constr;
        this.isCreator = isCreator;
        if (constr.getParameterCount() == 0) {
            this.paramAliasMap = Collections.emptyMap();
            this.paramAry = Collections.emptyList();
        } else {
            this.paramAliasMap = new LinkedHashMap<String, ParamEggg>(constr.getParameterCount());
            this.paramAry = new ArrayList<ParamEggg>(constr.getParameterCount());
            for (Parameter p1 : constr.getParameters()) {
                ParamEggg pe = eggg.newParamEggg(ownerEggg, this, p1);
                this.paramAliasMap.put(pe.getAlias(), pe);
                this.paramAry.add(pe);
            }
        }
        this.security = constr.getParameterCount() == 0 || isCreator || ownerEggg.isRealRecordClass();
        this.digest = eggg.findDigest(ownerEggg, this, null);
    }

    public ClassEggg getOwnerEggg() {
        return this.ownerEggg;
    }

    public Executable getConstr() {
        return this.constr;
    }

    @Override
    public Map<String, Type> getDeclaredGenericInfo() {
        return this.ownerEggg.getTypeEggg().getGenericInfo();
    }

    protected boolean isCreator() {
        return this.isCreator;
    }

    @Override
    public AnnotatedElement getElement() {
        return this.constr;
    }

    @Override
    public <T> T getDigest() {
        return (T)this.digest;
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.constr.getAnnotations();
        }
        return this.annotations;
    }

    public boolean isSecurity() {
        return this.security;
    }

    public int getParamCount() {
        return this.constr.getParameterCount();
    }

    public Collection<ParamEggg> getParamEgggAry() {
        return this.paramAry;
    }

    public ParamEggg getParamEgggAt(int idx) {
        return this.paramAry.get(idx);
    }

    public ParamEggg getParamEgggByAlias(String alias) {
        return this.paramAliasMap.get(alias);
    }

    public boolean hasParamEgggByAlias(String alias) {
        return this.paramAliasMap.containsKey(alias);
    }

    public <T> T newInstance(Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.constr.isAccessible()) {
            this.constr.setAccessible(true);
        }
        if (this.constr instanceof Constructor) {
            return ((Constructor)this.constr).newInstance(args);
        }
        return (T)((Method)this.constr).invoke((Object)args, new Object[0]);
    }

    public String toString() {
        return this.constr.toString();
    }
}

