/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.Eggg;

public class TypeEggg {
    private static final Set<Class<?>> PRIMITIVE_NUMBER_TYPES = new HashSet<Class>(Arrays.asList(Byte.TYPE, Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
    private final Eggg eggg;
    private final Type originType;
    private final Type genericType;
    private final Map<String, Type> genericInfo;
    private Class<?> type = Object.class;
    private ClassEggg classEggg;

    public TypeEggg(Eggg eggg, Type originType) {
        this.eggg = eggg;
        this.originType = originType;
        if (originType instanceof Class) {
            this.genericInfo = Collections.unmodifiableMap(eggg.createGenericInfo(originType));
            this.genericType = originType;
            this.type = (Class)originType;
        } else {
            Type tmp;
            this.genericInfo = Collections.unmodifiableMap(eggg.createGenericInfo(originType));
            this.genericType = eggg.reviewType(originType, this.genericInfo);
            if (this.isParameterizedType()) {
                Type tmp2 = this.getParameterizedType().getRawType();
                if (tmp2 instanceof Class) {
                    this.type = (Class)tmp2;
                }
            } else if (this.isGenericArrayType()) {
                this.type = Object[].class;
            } else if (this.isTypeVariable() && (tmp = this.getTypeVariable().getBounds()[0]) instanceof Class) {
                this.type = (Class)tmp;
            }
        }
    }

    public ClassEggg getClassEggg() {
        if (this.classEggg == null) {
            this.classEggg = this.eggg.getClassEggg(this);
        }
        return this.classEggg;
    }

    public ClassEggg newClassEggg() {
        return this.eggg.newClassEggg(this);
    }

    public Type getOriginType() {
        return this.originType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Map<String, Type> getGenericInfo() {
        return this.genericInfo;
    }

    public boolean isInterface() {
        return this.type.isInterface();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.type.getModifiers());
    }

    public boolean isArray() {
        return this.type.isArray();
    }

    public boolean isEnum() {
        return this.type.isEnum();
    }

    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    public boolean isList() {
        return List.class.isAssignableFrom(this.type);
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.type);
    }

    public boolean isString() {
        return this.type == String.class;
    }

    public boolean isBoolean() {
        return this.type == Boolean.class || this.type == Boolean.TYPE;
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.type) || PRIMITIVE_NUMBER_TYPES.contains(this.type);
    }

    public boolean isParameterizedType() {
        return this.genericType instanceof ParameterizedType;
    }

    public ParameterizedType getParameterizedType() {
        return (ParameterizedType)this.genericType;
    }

    public Type[] getActualTypeArguments() {
        return this.getParameterizedType().getActualTypeArguments();
    }

    public boolean isGenericArrayType() {
        return this.genericType instanceof GenericArrayType;
    }

    public GenericArrayType getGenericArrayType() {
        return (GenericArrayType)this.genericType;
    }

    public boolean isTypeVariable() {
        return this.genericType instanceof TypeVariable;
    }

    public TypeVariable getTypeVariable() {
        return (TypeVariable)this.genericType;
    }

    public int hashCode() {
        return this.genericType.hashCode();
    }

    public String toString() {
        return this.genericType.toString();
    }
}

