/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Objects;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.Eggg;
import org.noear.eggg.Property;
import org.noear.eggg.PropertyMethodEggg;
import org.noear.eggg.TypeEggg;

public class FieldEggg
implements Property {
    private final ClassEggg ownerEggg;
    private final Field field;
    private final TypeEggg fieldTypeEggg;
    protected PropertyMethodEggg getterEggg;
    protected PropertyMethodEggg setterEggg;
    private final String name;
    private final String alias;
    private final Object digest;
    private Annotation[] annotations;

    public FieldEggg(Eggg eggg, ClassEggg ownerEggg, Field field) {
        Objects.requireNonNull(eggg, "eggg");
        Objects.requireNonNull(ownerEggg, "ownerEggg");
        Objects.requireNonNull(field, "field");
        this.ownerEggg = ownerEggg;
        this.field = field;
        this.fieldTypeEggg = eggg.getTypeEggg(eggg.reviewType(field.getGenericType(), eggg.findGenericInfo(ownerEggg.getTypeEggg(), field.getDeclaringClass())));
        this.name = field.getName();
        this.digest = eggg.findDigest(ownerEggg, this, null);
        this.alias = eggg.findAlias(ownerEggg, this, this.name);
    }

    public ClassEggg getOwnerEggg() {
        return this.ownerEggg;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public AnnotatedElement getElement() {
        return this.field;
    }

    @Override
    public <T> T getDigest() {
        return (T)this.digest;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    @Override
    public Object getValue(Object target) {
        try {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
            return this.field.get(target);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object getValue(Object target, boolean allowGetter) {
        if (allowGetter && this.getterEggg != null) {
            return this.getterEggg.getValue(target);
        }
        return this.getValue(target);
    }

    @Override
    public void setValue(Object target, Object value) {
        if (!this.isFinal()) {
            try {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                this.field.set(target, value);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void setValue(Object target, Object value, boolean allowSetter) {
        if (allowSetter && this.setterEggg != null) {
            this.setterEggg.setValue(target, value);
        } else {
            this.setValue(target, value);
        }
    }

    @Override
    public TypeEggg getTypeEggg() {
        return this.fieldTypeEggg;
    }

    public Class<?> getType() {
        return this.fieldTypeEggg.getType();
    }

    public Type getGenericType() {
        return this.fieldTypeEggg.getGenericType();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.field.getAnnotations();
        }
        return this.annotations;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return this.field.toString();
    }
}

