/*
 * Decompiled with CFR 0.152.
 */
package org.noear.eggg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import org.noear.eggg.ClassEggg;
import org.noear.eggg.Eggg;
import org.noear.eggg.FieldEggg;
import org.noear.eggg.MethodEggg;
import org.noear.eggg.Property;
import org.noear.eggg.TypeEggg;

public class PropertyMethodEggg
implements Property {
    private final ClassEggg ownerEggg;
    private final MethodEggg methodEggg;
    private final TypeEggg propertyTypeEggg;
    private final FieldEggg fieldEggg;
    private final String name;
    private final String alias;
    private final Object digest;

    public PropertyMethodEggg(Eggg eggg, ClassEggg ownerEggg, MethodEggg methodEggg) {
        Objects.requireNonNull(eggg, "eggg");
        Objects.requireNonNull(ownerEggg, "ownerEggg");
        Objects.requireNonNull(methodEggg, "methodEggg");
        this.ownerEggg = ownerEggg;
        this.methodEggg = methodEggg;
        this.propertyTypeEggg = methodEggg.getReturnTypeEggg().getType() != Void.TYPE ? methodEggg.getReturnTypeEggg() : methodEggg.getParamEgggAt(0).getTypeEggg();
        this.name = Property.resolvePropertyName(methodEggg.getName());
        this.fieldEggg = ownerEggg.getFieldEgggByName(this.name);
        this.digest = this.fieldEggg == null ? eggg.findDigest(ownerEggg, this, null) : eggg.findDigest(ownerEggg, this, this.fieldEggg.getDigest());
        this.alias = eggg.findAlias(ownerEggg, this, this.name);
    }

    public ClassEggg getOwnerEggg() {
        return this.ownerEggg;
    }

    public Method getMethod() {
        return this.methodEggg.getMethod();
    }

    @Override
    public AnnotatedElement getElement() {
        return this.methodEggg.getMethod();
    }

    @Override
    public <T> T getDigest() {
        return (T)this.digest;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.methodEggg.getAnnotations();
    }

    @Override
    public boolean isTransient() {
        return this.fieldEggg != null && this.fieldEggg.isTransient();
    }

    public boolean isReadMode() {
        return this.methodEggg.getReturnTypeEggg().getType() != Void.TYPE;
    }

    @Override
    public Object getValue(Object target) {
        if (this.isReadMode()) {
            try {
                return this.methodEggg.invoke(target, new Object[0]);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    @Override
    public void setValue(Object target, Object value) {
        if (!this.isReadMode()) {
            try {
                this.methodEggg.invoke(target, value);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public TypeEggg getTypeEggg() {
        return this.propertyTypeEggg;
    }

    public Class<?> getType() {
        return this.propertyTypeEggg.getType();
    }

    public Type getGenericType() {
        return this.propertyTypeEggg.getGenericType();
    }

    public FieldEggg getFieldEggg() {
        return this.fieldEggg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public int hashCode() {
        return this.methodEggg.hashCode();
    }

    public String toString() {
        return this.methodEggg.toString();
    }
}

