/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.noear.solon.admin.server.data.Application;
import org.noear.solon.admin.server.services.ApplicationService;
import org.noear.solon.annotation.Body;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Delete;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Param;
import org.noear.solon.annotation.Post;
import org.noear.solon.annotation.Put;
import org.noear.solon.core.handle.Result;

@Controller
@Mapping(value="/solon-admin/api/application")
public class ApplicationController {
    @Inject
    private ApplicationService applicationService;

    @Put
    @Mapping(value="/register")
    public Result<String> register(@Body Application application) {
        this.applicationService.registerApplication(application);
        return Result.succeed();
    }

    @Delete
    @Mapping(value="/unregister")
    public Result<String> unregister(@Body Application application) {
        this.applicationService.unregisterApplication(application);
        return Result.succeed();
    }

    @Post
    @Mapping(value="/heartbeat")
    public Result<String> heartbeat(@Body Application application) {
        return this.applicationService.heartbeatApplication(application);
    }

    @Get
    @Mapping(value="/?")
    public Application getByNameAndBaseUrl(@Param(value="name") String name, @Param(value="baseUrl") String baseUrl) throws UnsupportedEncodingException {
        name = URLDecoder.decode(name, "UTF-8");
        baseUrl = URLDecoder.decode(baseUrl, "UTF-8");
        return this.applicationService.getApplication(name, baseUrl);
    }
}

