/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.noear.solon.admin.server.config.ServerProperties;
import org.noear.solon.admin.server.data.Application;
import org.noear.solon.admin.server.data.ApplicationWebsocketTransfer;
import org.noear.solon.admin.server.services.ClientMonitorService;
import org.noear.solon.admin.server.utils.JsonUtils;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.handle.Result;
import org.noear.solon.net.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ApplicationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApplicationService.class);
    private final Map<String, Application> applications = new HashMap<String, Application>();
    private final Map<Application, Runnable> runningHeartbeatTasks = new HashMap<Application, Runnable>();
    private final Map<Application, Runnable> runningClientMonitorTasks = new HashMap<Application, Runnable>();
    @Inject
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Inject
    private ServerProperties serverProperties;
    @Inject(value="applicationWebsocketSessions")
    private List<WebSocket> sessions;
    @Inject
    private ClientMonitorService clientMonitorService;

    public void registerApplication(Application application) {
        String key = application.toKey();
        Application persisted = this.applications.get(key);
        if (persisted != null) {
            persisted.replace(application);
            return;
        }
        this.applications.put(key, application);
        this.scheduleHeartbeatCheck(application);
        this.sessions.forEach(it -> it.send(JsonUtils.toJson(new ApplicationWebsocketTransfer<Application>(null, "registerApplication", application))));
        this.scheduleClientMonitor(application);
        log.info("Application registered: {}", (Object)application);
    }

    public void unregisterApplication(Application application) {
        Optional<Application> find = this.applications.values().stream().filter(it -> it.equals(application)).findFirst();
        if (!find.isPresent()) {
            return;
        }
        this.applications.remove(find.get().toKey());
        this.scheduledThreadPoolExecutor.remove(this.runningHeartbeatTasks.get(find.get()));
        this.scheduledThreadPoolExecutor.remove(this.runningClientMonitorTasks.get(find.get()));
        this.sessions.forEach(it -> it.send(JsonUtils.toJson(new ApplicationWebsocketTransfer(null, "unregisterApplication", find.get()))));
        log.info("Application unregistered: {}", (Object)find.get());
    }

    public Result<String> heartbeatApplication(Application application) {
        Optional<Application> find = this.applications.values().stream().filter(it -> it.equals(application)).findFirst();
        if (!find.isPresent()) {
            return Result.failure();
        }
        find.get().setLastHeartbeat(System.currentTimeMillis());
        if (application.getStatus() == Application.Status.UP) {
            return Result.succeed();
        }
        find.get().setStatus(Application.Status.UP);
        find.get().setLastUpTime(System.currentTimeMillis());
        this.sessions.forEach(it -> it.send(JsonUtils.toJson(new ApplicationWebsocketTransfer(null, "updateApplication", find.get()))));
        log.trace("Application heartbeat: {}", (Object)find.get());
        return Result.succeed();
    }

    private void scheduleHeartbeatCheck(Application application) {
        Runnable heartbeatCallback = () -> {
            this.runHeartbeatCheck(application);
            this.scheduleHeartbeatCheck(application);
        };
        this.runningHeartbeatTasks.put(application, heartbeatCallback);
        this.scheduledThreadPoolExecutor.schedule(heartbeatCallback, this.serverProperties.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
    }

    private void runHeartbeatCheck(Application application) {
        if (System.currentTimeMillis() - application.getLastHeartbeat() <= this.serverProperties.getHeartbeatInterval()) {
            return;
        }
        if (application.getStatus() == Application.Status.DOWN) {
            return;
        }
        application.setStatus(Application.Status.DOWN);
        application.setLastDownTime(System.currentTimeMillis());
        this.sessions.forEach(it -> it.send(JsonUtils.toJson(new ApplicationWebsocketTransfer<Application>(null, "updateApplication", application))));
    }

    private void scheduleClientMonitor(Application application) {
        Runnable clientMonitorCallback = () -> {
            this.runClientMonitor(application);
            this.scheduleClientMonitor(application);
        };
        this.runningClientMonitorTasks.put(application, clientMonitorCallback);
        this.scheduledThreadPoolExecutor.schedule(clientMonitorCallback, this.serverProperties.getClientMonitorPeriod(), TimeUnit.MILLISECONDS);
    }

    private void runClientMonitor(Application application) {
        application.setMonitors(this.clientMonitorService.getMonitors(application));
        this.sessions.forEach(it -> it.send(JsonUtils.toJson(new ApplicationWebsocketTransfer<Application>(null, "updateApplication", application))));
    }

    public Collection<Application> getApplications() {
        return this.applications.values();
    }

    public Application getApplication(String name, String baseUrl) {
        Optional<Application> find = this.applications.values().stream().filter(it -> it.getName().equals(name) && it.getBaseUrl().equals(baseUrl)).findFirst();
        return find.orElse(null);
    }
}

