/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.admin.server.services;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.noear.snack.core.TypeRef;
import org.noear.solon.admin.server.data.Application;
import org.noear.solon.admin.server.data.Detector;
import org.noear.solon.admin.server.utils.JsonUtils;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ClientMonitorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientMonitorService.class);
    @Inject
    private OkHttpClient client;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Detector> getMonitors(Application application) {
        String clientUrl = application.getBaseUrl().replaceAll("/+$", "");
        try (Response response = this.client.newCall(new Request.Builder().url(new URL(clientUrl + "/solon-admin/api/monitor/data")).header("TOKEN", application.getToken()).get().build()).execute();){
            if (response.isSuccessful()) {
                String json = Objects.requireNonNull(response.body()).string();
                Collection collection = (Collection)JsonUtils.fromJson(json, new TypeRef<List<Detector>>(){}.getClass());
                return collection;
            }
            log.warn("Failed to get monitors of {} with status code {}", (Object)application, (Object)response.code());
            throw new RuntimeException("Failed to get monitors of " + application);
        }
        catch (Exception ex) {
            log.error("Unexpected error occurred during getting monitors:", (Throwable)ex);
        }
        throw new RuntimeException("Failed to get monitors of " + application);
    }
}

