/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.chat.ChatChoice;
import org.noear.solon.ai.chat.ChatConfig;
import org.noear.solon.ai.chat.ChatException;
import org.noear.solon.ai.chat.ChatOptions;
import org.noear.solon.ai.chat.ChatResponseDefault;
import org.noear.solon.ai.chat.dialect.AbstractChatDialect;
import org.noear.solon.ai.chat.message.AssistantMessage;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.ai.media.Audio;
import org.noear.solon.ai.media.Image;

public class DashscopeChatDialect
extends AbstractChatDialect {
    private static DashscopeChatDialect instance = new DashscopeChatDialect();

    public static DashscopeChatDialect getInstance() {
        return instance;
    }

    public boolean matched(ChatConfig config) {
        return "dashscope".equals(config.getProvider());
    }

    public String buildRequestJson(ChatConfig config, ChatOptions options, List<ChatMessage> messages, boolean isStream) {
        return new ONode().build(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("input").getOrNew("messages").build(n1 -> {
                for (ChatMessage m1 : messages) {
                    if (m1.isThinking()) continue;
                    n1.add((Object)this.buildChatMessageNode(m1));
                }
            });
            n.set("stream", (Object)isStream);
            n.getOrNew("parameters").build(n1 -> {
                for (Map.Entry kv : options.options().entrySet()) {
                    n1.set((String)kv.getKey(), kv.getValue());
                }
                n1.set("result_format", (Object)"message");
                this.buildReqToolsNodeDo((ONode)n1, config.getDefaultTools());
                this.buildReqToolsNodeDo((ONode)n1, options.tools());
            });
        }).toJson();
    }

    public boolean parseResponseJson(ChatConfig config, ChatResponseDefault resp, String json) {
        if ("[DONE]".equals(json)) {
            if (!resp.isFinished()) {
                resp.addChoice(new ChatChoice(0, new Date(), "stop", new AssistantMessage("")));
                resp.setFinished(true);
            }
            return true;
        }
        ONode oResp = ONode.load((Object)json);
        if (!oResp.isObject()) {
            return false;
        }
        if (oResp.contains("code") && !Utils.isEmpty((String)oResp.get("code").getString())) {
            resp.setError(new ChatException(oResp.get("code").getString() + ": " + oResp.get("message").getString()));
        } else {
            ONode oUsage;
            resp.setModel(config.getModel());
            int index = 0;
            Date created = null;
            for (ONode oChoice1 : oResp.get("output").get("choices").ary()) {
                String finish_reason = oChoice1.get("finish_reason").getString();
                List<AssistantMessage> messageList = this.parseAssistantMessage(resp, oChoice1.get("message"));
                for (AssistantMessage msg1 : messageList) {
                    resp.addChoice(new ChatChoice(index, created, finish_reason, msg1));
                }
                if (Utils.isNotEmpty((String)finish_reason)) {
                    resp.setFinished(true);
                }
                ++index;
            }
            if (resp.isFinished() && !resp.hasChoices()) {
                resp.addChoice(new ChatChoice(0, created, "stop", new AssistantMessage("")));
            }
            if ((oUsage = oResp.getOrNull("usage")) != null) {
                long promptTokens = oUsage.get("input_tokens").getLong();
                long completionTokens = oUsage.get("output_tokens").getLong();
                long totalTokens = oUsage.get("total_tokens").getLong();
                resp.setUsage(new AiUsage(promptTokens, completionTokens, totalTokens));
            }
        }
        return true;
    }

    public List<AssistantMessage> parseAssistantMessage(ChatResponseDefault resp, ONode oMessage) {
        ONode contentArray;
        String content = oMessage.get("content").getString();
        if (oMessage.get("content").isArray() && (contentArray = oMessage.get("content")).ary().size() > 0) {
            content = contentArray.get(0).get("text").getString();
        }
        oMessage.set("content", (Object)content);
        return super.parseAssistantMessage(resp, oMessage);
    }

    protected void buildChatMessageNodeDo(ONode oNode, UserMessage msg) {
        List<AiMedia> medias = msg.getMedias();
        String content = msg.getContent();
        if (medias == null) {
            medias = Arrays.asList(new AiMedia[0]);
        }
        List<AiMedia> finalMedias = medias;
        ONode contentNode = new ONode().build(n -> {
            for (AiMedia media : finalMedias) {
                if (media instanceof Image) {
                    n.add((Object)new ONode().build(n1 -> n1.set("image", (Object)media.toDataString(true))));
                    continue;
                }
                if (!(media instanceof Audio)) continue;
                n.add((Object)new ONode().build(n1 -> n1.set("audio", (Object)media.toDataString(true))));
            }
            if (Utils.isNotEmpty((String)content)) {
                n.add((Object)new ONode().build(n1 -> n1.set("text", (Object)content)));
            }
        });
        oNode.set("role", (Object)msg.getRole().name().toLowerCase());
        oNode.set("content", (Object)contentNode);
    }
}

