/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.image.ImageConfig;
import org.noear.solon.ai.image.ImageException;
import org.noear.solon.ai.image.ImageOptions;
import org.noear.solon.ai.image.ImageResponse;
import org.noear.solon.ai.image.dialect.AbstractImageDialect;
import org.noear.solon.ai.media.Image;

public class DashscopeImageDialect
extends AbstractImageDialect {
    private static DashscopeImageDialect instance = new DashscopeImageDialect();

    public static DashscopeImageDialect getInstance() {
        return instance;
    }

    public boolean matched(ImageConfig config) {
        return "dashscope".equals(config.getProvider());
    }

    public String buildRequestJson(ImageConfig config, ImageOptions options, String prompt) {
        return new ONode().build(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            if (Utils.isNotEmpty((String)prompt)) {
                n.getOrNew("input").set("prompt", (Object)prompt);
            }
            n.getOrNew("parameters").build(n1 -> {
                for (Map.Entry kv : options.options().entrySet()) {
                    n1.set((String)kv.getKey(), kv.getValue());
                }
            });
        }).toJson();
    }

    public ImageResponse parseResponseJson(ImageConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("code") && !Utils.isEmpty((String)oResp.get("code").getString())) {
            return new ImageResponse(model, new ImageException(oResp.get("code").getString() + ": " + oResp.get("message").getString()), null, null);
        }
        List<Image> data = null;
        ONode oOutput = oResp.get("output");
        if (oOutput.contains("results")) {
            data = oOutput.get("results").toObjectList(Image.class);
        } else {
            String url = "https://dashscope.aliyuncs.com/api/v1/tasks/" + oOutput.get("task_id").getString();
            data = Arrays.asList(Image.ofUrl((String)url));
        }
        return new ImageResponse(model, null, (List)data, null);
    }
}

