/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.snack4.codec.TypeRef;
import org.noear.solon.Utils;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateContent;
import org.noear.solon.ai.generate.GenerateException;
import org.noear.solon.ai.generate.GenerateOptions;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.ai.generate.dialect.AbstractGenerateDialect;

public class DashscopeGenerateDialect
extends AbstractGenerateDialect {
    private static final String URL_PREFIX = "https://dashscope.aliyuncs.com/api/v1/services/";
    private static DashscopeGenerateDialect instance = new DashscopeGenerateDialect();

    public static DashscopeGenerateDialect getInstance() {
        return instance;
    }

    public boolean matched(GenerateConfig config) {
        if ("dashscope".equals(config.getProvider())) {
            return true;
        }
        return config.getApiUrl().startsWith(URL_PREFIX);
    }

    public String buildRequestJson(GenerateConfig config, GenerateOptions options, String promptStr, Map promptMap) {
        return new ONode().then(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            if (Utils.isNotEmpty((String)promptStr)) {
                n.getOrNew("input").set("prompt", (Object)promptStr);
            } else if (Utils.isNotEmpty((Map)promptMap)) {
                n.set("input", (Object)ONode.ofBean((Object)promptMap, (Feature[])new Feature[0]));
            }
            n.getOrNew("parameters").then(n1 -> {
                for (Map.Entry kv : options.options().entrySet()) {
                    n1.set((String)kv.getKey(), kv.getValue());
                }
            });
        }).toJson();
    }

    public GenerateResponse parseResponseJson(GenerateConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("code") && !Utils.isEmpty((String)oResp.get("code").getString())) {
            return new GenerateResponse(model, new GenerateException(oResp.get("code").getString() + ": " + oResp.get("message").getString()), null, null);
        }
        List<GenerateContent> data = null;
        ONode oOutput = oResp.get("output");
        if (oOutput.hasKey("task_id")) {
            String url = config.getTaskUrlAndId(oOutput.get("task_id").getString());
            data = Arrays.asList(GenerateContent.builder().url(url).build());
        } else if (oOutput.hasKey("results")) {
            data = (List<GenerateContent>)oOutput.get("results").toBean((TypeRef)new TypeRef<List<GenerateContent>>(){});
        }
        return new GenerateResponse(model, null, data, null);
    }
}

