/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.openai;

import java.util.Arrays;
import java.util.List;
import org.noear.snack.ONode;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.generate.GenerateConfig;
import org.noear.solon.ai.generate.GenerateContent;
import org.noear.solon.ai.generate.GenerateException;
import org.noear.solon.ai.generate.GenerateResponse;
import org.noear.solon.ai.generate.dialect.AbstractGenerateDialect;

public class OpenaiGenerateDialect
extends AbstractGenerateDialect {
    private static OpenaiGenerateDialect instance = new OpenaiGenerateDialect();

    public static OpenaiGenerateDialect getInstance() {
        return instance;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean matched(GenerateConfig config) {
        return false;
    }

    public GenerateResponse parseResponseJson(GenerateConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("error")) {
            return new GenerateResponse(model, new GenerateException(oResp.get("error").getString()), null, null);
        }
        List<GenerateContent> data = null;
        if (oResp.contains("task_id")) {
            String url = config.getTaskUrlAndId(oResp.get("task_id").getString());
            data = Arrays.asList(GenerateContent.builder().url(url).build());
        } else if (oResp.contains("data")) {
            data = oResp.get("data").toObjectList(GenerateContent.class);
        }
        AiUsage usage = null;
        if (oResp.contains("usage")) {
            ONode oUsage = oResp.get("usage");
            usage = new AiUsage((long)oUsage.get("prompt_tokens").getInt(), 0L, (long)oUsage.get("total_tokens").getInt());
        }
        return new GenerateResponse(model, null, (List)data, usage);
    }
}

