/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.modelcontextprotocol.client.LifecycleInitializer;
import io.modelcontextprotocol.client.McpClientFeatures;
import io.modelcontextprotocol.spec.McpClientSession;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class McpAsyncClient {
    private static final Logger logger = LoggerFactory.getLogger(McpAsyncClient.class);
    private static final TypeReference<Void> VOID_TYPE_REFERENCE = new TypeReference<Void>(){};
    public static final TypeReference<Object> OBJECT_TYPE_REF = new TypeReference<Object>(){};
    public static final TypeReference<McpSchema.PaginatedRequest> PAGINATED_REQUEST_TYPE_REF = new TypeReference<McpSchema.PaginatedRequest>(){};
    public static final TypeReference<McpSchema.InitializeResult> INITIALIZE_RESULT_TYPE_REF = new TypeReference<McpSchema.InitializeResult>(){};
    public static final TypeReference<McpSchema.CreateMessageRequest> CREATE_MESSAGE_REQUEST_TYPE_REF = new TypeReference<McpSchema.CreateMessageRequest>(){};
    public static final TypeReference<McpSchema.LoggingMessageNotification> LOGGING_MESSAGE_NOTIFICATION_TYPE_REF = new TypeReference<McpSchema.LoggingMessageNotification>(){};
    public static final TypeReference<McpSchema.ProgressNotification> PROGRESS_NOTIFICATION_TYPE_REF = new TypeReference<McpSchema.ProgressNotification>(){};
    private final McpSchema.ClientCapabilities clientCapabilities;
    private final McpSchema.Implementation clientInfo;
    private final ConcurrentHashMap<String, McpSchema.Root> roots;
    private Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler;
    private Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler;
    private final McpClientTransport transport;
    private final LifecycleInitializer initializer;
    private static final TypeReference<McpSchema.CallToolResult> CALL_TOOL_RESULT_TYPE_REF = new TypeReference<McpSchema.CallToolResult>(){};
    private static final TypeReference<McpSchema.ListToolsResult> LIST_TOOLS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListToolsResult>(){};
    private static final TypeReference<McpSchema.ListResourcesResult> LIST_RESOURCES_RESULT_TYPE_REF = new TypeReference<McpSchema.ListResourcesResult>(){};
    private static final TypeReference<McpSchema.ReadResourceResult> READ_RESOURCE_RESULT_TYPE_REF = new TypeReference<McpSchema.ReadResourceResult>(){};
    private static final TypeReference<McpSchema.ListResourceTemplatesResult> LIST_RESOURCE_TEMPLATES_RESULT_TYPE_REF = new TypeReference<McpSchema.ListResourceTemplatesResult>(){};
    private static final TypeReference<McpSchema.ListPromptsResult> LIST_PROMPTS_RESULT_TYPE_REF = new TypeReference<McpSchema.ListPromptsResult>(){};
    private static final TypeReference<McpSchema.GetPromptResult> GET_PROMPT_RESULT_TYPE_REF = new TypeReference<McpSchema.GetPromptResult>(){};
    private static final TypeReference<McpSchema.CompleteResult> COMPLETION_COMPLETE_RESULT_TYPE_REF = new TypeReference<McpSchema.CompleteResult>(){};

    McpAsyncClient(McpClientTransport transport, Duration requestTimeout, Duration initializationTimeout, McpClientFeatures.Async features) {
        Assert.notNull(transport, "Transport must not be null");
        Assert.notNull(requestTimeout, "Request timeout must not be null");
        Assert.notNull(initializationTimeout, "Initialization timeout must not be null");
        this.clientInfo = features.getClientInfo();
        this.clientCapabilities = features.getClientCapabilities();
        this.transport = transport;
        this.roots = new ConcurrentHashMap<String, McpSchema.Root>(features.getRoots());
        HashMap requestHandlers = new HashMap();
        requestHandlers.put("ping", params -> {
            logger.debug("Received ping: {}", (Object)LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            return Mono.just((Object)Utils.asMap(new Object[0]));
        });
        if (this.clientCapabilities.getRoots() != null) {
            requestHandlers.put("roots/list", this.rootsListRequestHandler());
        }
        if (this.clientCapabilities.getSampling() != null) {
            if (features.getSamplingHandler() == null) {
                throw new IllegalArgumentException("Sampling handler must not be null when client capabilities include sampling");
            }
            this.samplingHandler = features.getSamplingHandler();
            requestHandlers.put("sampling/createMessage", this.samplingCreateMessageHandler());
        }
        if (this.clientCapabilities.getElicitation() != null) {
            if (features.getElicitationHandler() == null) {
                throw new IllegalArgumentException("Elicitation handler must not be null when client capabilities include elicitation");
            }
            this.elicitationHandler = features.getElicitationHandler();
            requestHandlers.put("elicitation/create", this.elicitationCreateHandler());
        }
        HashMap<String, McpClientSession.NotificationHandler> notificationHandlers = new HashMap<String, McpClientSession.NotificationHandler>();
        ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumersFinal = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>();
        toolsChangeConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Tools changed: {}", notification)));
        if (!Utils.isEmpty(features.getToolsChangeConsumers())) {
            toolsChangeConsumersFinal.addAll(features.getToolsChangeConsumers());
        }
        notificationHandlers.put("notifications/tools/list_changed", this.asyncToolsChangeNotificationHandler(toolsChangeConsumersFinal));
        ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumersFinal = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>();
        resourcesChangeConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Resources changed: {}", notification)));
        if (!Utils.isEmpty(features.getResourcesChangeConsumers())) {
            resourcesChangeConsumersFinal.addAll(features.getResourcesChangeConsumers());
        }
        notificationHandlers.put("notifications/resources/list_changed", this.asyncResourcesChangeNotificationHandler(resourcesChangeConsumersFinal));
        ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumersFinal = new ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>>();
        resourcesUpdateConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Resources updated: {}", notification)));
        if (!Utils.isEmpty(features.getResourcesUpdateConsumers())) {
            resourcesUpdateConsumersFinal.addAll(features.getResourcesUpdateConsumers());
        }
        notificationHandlers.put("notifications/resources/updated", this.asyncResourcesUpdatedNotificationHandler(resourcesUpdateConsumersFinal));
        ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumersFinal = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>();
        promptsChangeConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Prompts changed: {}", notification)));
        if (!Utils.isEmpty(features.getPromptsChangeConsumers())) {
            promptsChangeConsumersFinal.addAll(features.getPromptsChangeConsumers());
        }
        notificationHandlers.put("notifications/prompts/list_changed", this.asyncPromptsChangeNotificationHandler(promptsChangeConsumersFinal));
        ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumersFinal = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>();
        loggingConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Logging: {}", notification)));
        if (!Utils.isEmpty(features.getLoggingConsumers())) {
            loggingConsumersFinal.addAll(features.getLoggingConsumers());
        }
        notificationHandlers.put("notifications/message", this.asyncLoggingNotificationHandler(loggingConsumersFinal));
        ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumersFinal = new ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>>();
        progressConsumersFinal.add(notification -> Mono.fromRunnable(() -> logger.debug("Progress: {}", notification)));
        if (!Utils.isEmpty(features.getProgressConsumers())) {
            progressConsumersFinal.addAll(features.getProgressConsumers());
        }
        notificationHandlers.put("notifications/progress", this.asyncProgressNotificationHandler(progressConsumersFinal));
        this.initializer = new LifecycleInitializer(this.clientCapabilities, this.clientInfo, transport.protocolVersions(), initializationTimeout, ctx -> new McpClientSession(requestTimeout, transport, requestHandlers, notificationHandlers, con -> con.contextWrite(ctx)));
        this.transport.setExceptionHandler(this.initializer::handleException);
    }

    public McpSchema.InitializeResult getCurrentInitializationResult() {
        return this.initializer.currentInitializationResult();
    }

    public McpSchema.ServerCapabilities getServerCapabilities() {
        McpSchema.InitializeResult initializeResult = this.initializer.currentInitializationResult();
        return initializeResult != null ? initializeResult.getCapabilities() : null;
    }

    public String getServerInstructions() {
        McpSchema.InitializeResult initializeResult = this.initializer.currentInitializationResult();
        return initializeResult != null ? initializeResult.getInstructions() : null;
    }

    public McpSchema.Implementation getServerInfo() {
        McpSchema.InitializeResult initializeResult = this.initializer.currentInitializationResult();
        return initializeResult != null ? initializeResult.getServerInfo() : null;
    }

    public boolean isInitialized() {
        return this.initializer.isInitialized();
    }

    public McpSchema.ClientCapabilities getClientCapabilities() {
        return this.clientCapabilities;
    }

    public McpSchema.Implementation getClientInfo() {
        return this.clientInfo;
    }

    public void close() {
        this.initializer.close();
        this.transport.close();
    }

    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> this.initializer.closeGracefully().then(this.transport.closeGracefully()));
    }

    public Mono<McpSchema.InitializeResult> initialize() {
        return this.initializer.withIntitialization("by explicit API call", init -> Mono.just((Object)init.initializeResult()));
    }

    public Mono<Object> ping() {
        return this.initializer.withIntitialization("pinging the server", init -> init.mcpSession().sendRequest("ping", null, OBJECT_TYPE_REF));
    }

    public Mono<Void> addRoot(McpSchema.Root root) {
        if (root == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Root must not be null"));
        }
        if (this.clientCapabilities.getRoots() == null) {
            return Mono.error((Throwable)new IllegalStateException("Client must be configured with roots capabilities"));
        }
        if (this.roots.containsKey(root.getUri())) {
            return Mono.error((Throwable)new IllegalStateException("Root with uri '" + root.getUri() + "' already exists"));
        }
        this.roots.put(root.getUri(), root);
        logger.debug("Added root: {}", (Object)root);
        if (this.clientCapabilities.getRoots().getListChanged().booleanValue()) {
            if (this.isInitialized()) {
                return this.rootsListChangedNotification();
            }
            logger.warn("Client is not initialized, ignore sending a roots list changed notification");
        }
        return Mono.empty();
    }

    public Mono<Void> removeRoot(String rootUri) {
        if (rootUri == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Root uri must not be null"));
        }
        if (this.clientCapabilities.getRoots() == null) {
            return Mono.error((Throwable)new IllegalStateException("Client must be configured with roots capabilities"));
        }
        McpSchema.Root removed = this.roots.remove(rootUri);
        if (removed != null) {
            logger.debug("Removed Root: {}", (Object)rootUri);
            if (this.clientCapabilities.getRoots().getListChanged().booleanValue()) {
                if (this.isInitialized()) {
                    return this.rootsListChangedNotification();
                }
                logger.warn("Client is not initialized, ignore sending a roots list changed notification");
            }
            return Mono.empty();
        }
        return Mono.error((Throwable)new IllegalStateException("Root with uri '" + rootUri + "' not found"));
    }

    public Mono<Void> rootsListChangedNotification() {
        return this.initializer.withIntitialization("sending roots list changed notification", init -> init.mcpSession().sendNotification("notifications/roots/list_changed"));
    }

    private McpClientSession.RequestHandler<McpSchema.ListRootsResult> rootsListRequestHandler() {
        return params -> {
            McpSchema.PaginatedRequest request = this.transport.unmarshalFrom(params, PAGINATED_REQUEST_TYPE_REF);
            List<McpSchema.Root> roots = this.roots.values().stream().collect(Collectors.toList());
            return Mono.just((Object)new McpSchema.ListRootsResult(roots));
        };
    }

    private McpClientSession.RequestHandler<McpSchema.CreateMessageResult> samplingCreateMessageHandler() {
        return params -> {
            McpSchema.CreateMessageRequest request = this.transport.unmarshalFrom(params, CREATE_MESSAGE_REQUEST_TYPE_REF);
            return this.samplingHandler.apply(request);
        };
    }

    private McpClientSession.RequestHandler<McpSchema.ElicitResult> elicitationCreateHandler() {
        return params -> {
            McpSchema.ElicitRequest request = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.ElicitRequest>(){});
            return this.elicitationHandler.apply(request);
        };
    }

    public Mono<McpSchema.CallToolResult> callTool(McpSchema.CallToolRequest callToolRequest) {
        return this.initializer.withIntitialization("calling tools", init -> {
            if (init.initializeResult().getCapabilities().getTools() == null) {
                return Mono.error((Throwable)new IllegalStateException("Server does not provide tools capability"));
            }
            return init.mcpSession().sendRequest("tools/call", callToolRequest, CALL_TOOL_RESULT_TYPE_REF);
        });
    }

    public Mono<McpSchema.ListToolsResult> listTools() {
        return this.listTools(McpSchema.FIRST_PAGE).expand(result -> result.getNextCursor() != null ? this.listTools(result.getNextCursor()) : Mono.empty()).reduce((Object)new McpSchema.ListToolsResult(new ArrayList<McpSchema.Tool>(), null), (allToolsResult, result) -> {
            allToolsResult.getTools().addAll(result.getTools());
            return allToolsResult;
        }).map(result -> new McpSchema.ListToolsResult(Collections.unmodifiableList(result.getTools()), null));
    }

    public Mono<McpSchema.ListToolsResult> listTools(String cursor) {
        return this.initializer.withIntitialization("listing tools", init -> {
            if (init.initializeResult().getCapabilities().getTools() == null) {
                return Mono.error((Throwable)new IllegalStateException("Server does not provide tools capability"));
            }
            return init.mcpSession().sendRequest("tools/list", new McpSchema.PaginatedRequest(cursor), LIST_TOOLS_RESULT_TYPE_REF);
        });
    }

    private McpClientSession.NotificationHandler asyncToolsChangeNotificationHandler(List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers) {
        return params -> this.listTools().flatMap(listToolsResult -> Flux.fromIterable((Iterable)toolsChangeConsumers).flatMap(consumer -> (Mono)consumer.apply(listToolsResult.getTools())).onErrorResume(error -> {
            logger.error("Error handling tools list change notification", error);
            return Mono.empty();
        }).then());
    }

    public Mono<McpSchema.ListResourcesResult> listResources() {
        return this.listResources(McpSchema.FIRST_PAGE).expand(result -> result.getNextCursor() != null ? this.listResources(result.getNextCursor()) : Mono.empty()).reduce((Object)new McpSchema.ListResourcesResult(new ArrayList<McpSchema.Resource>(), null), (allResourcesResult, result) -> {
            allResourcesResult.getResources().addAll(result.getResources());
            return allResourcesResult;
        }).map(result -> new McpSchema.ListResourcesResult(Collections.unmodifiableList(result.getResources()), null));
    }

    public Mono<McpSchema.ListResourcesResult> listResources(String cursor) {
        return this.initializer.withIntitialization("listing resources", init -> {
            if (init.initializeResult().getCapabilities().getResources() == null) {
                return Mono.error((Throwable)new IllegalStateException("Server does not provide the resources capability"));
            }
            return init.mcpSession().sendRequest("resources/list", new McpSchema.PaginatedRequest(cursor), LIST_RESOURCES_RESULT_TYPE_REF);
        });
    }

    public Mono<McpSchema.ReadResourceResult> readResource(McpSchema.Resource resource) {
        return this.readResource(new McpSchema.ReadResourceRequest(resource.getUri()));
    }

    public Mono<McpSchema.ReadResourceResult> readResource(McpSchema.ReadResourceRequest readResourceRequest) {
        return this.initializer.withIntitialization("reading resources", init -> {
            if (init.initializeResult().getCapabilities().getResources() == null) {
                return Mono.error((Throwable)new IllegalStateException("Server does not provide the resources capability"));
            }
            return init.mcpSession().sendRequest("resources/read", readResourceRequest, READ_RESOURCE_RESULT_TYPE_REF);
        });
    }

    public Mono<McpSchema.ListResourceTemplatesResult> listResourceTemplates() {
        return this.listResourceTemplates(McpSchema.FIRST_PAGE).expand(result -> result.getNextCursor() != null ? this.listResourceTemplates(result.getNextCursor()) : Mono.empty()).reduce((Object)new McpSchema.ListResourceTemplatesResult(new ArrayList<McpSchema.ResourceTemplate>(), null), (allResourceTemplatesResult, result) -> {
            allResourceTemplatesResult.getResourceTemplates().addAll(result.getResourceTemplates());
            return allResourceTemplatesResult;
        }).map(result -> new McpSchema.ListResourceTemplatesResult(Collections.unmodifiableList(result.getResourceTemplates()), null));
    }

    public Mono<McpSchema.ListResourceTemplatesResult> listResourceTemplates(String cursor) {
        return this.initializer.withIntitialization("listing resource templates", init -> {
            if (init.initializeResult().getCapabilities().getResources() == null) {
                return Mono.error((Throwable)new IllegalStateException("Server does not provide the resources capability"));
            }
            return init.mcpSession().sendRequest("resources/templates/list", new McpSchema.PaginatedRequest(cursor), LIST_RESOURCE_TEMPLATES_RESULT_TYPE_REF);
        });
    }

    public Mono<Void> subscribeResource(McpSchema.SubscribeRequest subscribeRequest) {
        return this.initializer.withIntitialization("subscribing to resources", init -> init.mcpSession().sendRequest("resources/subscribe", subscribeRequest, VOID_TYPE_REFERENCE));
    }

    public Mono<Void> unsubscribeResource(McpSchema.UnsubscribeRequest unsubscribeRequest) {
        return this.initializer.withIntitialization("unsubscribing from resources", init -> init.mcpSession().sendRequest("resources/unsubscribe", unsubscribeRequest, VOID_TYPE_REFERENCE));
    }

    private McpClientSession.NotificationHandler asyncResourcesChangeNotificationHandler(List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers) {
        return params -> this.listResources().flatMap(listResourcesResult -> Flux.fromIterable((Iterable)resourcesChangeConsumers).flatMap(consumer -> (Mono)consumer.apply(listResourcesResult.getResources())).onErrorResume(error -> {
            logger.error("Error handling resources list change notification", error);
            return Mono.empty();
        }).then());
    }

    private McpClientSession.NotificationHandler asyncResourcesUpdatedNotificationHandler(List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers) {
        return params -> {
            McpSchema.ResourcesUpdatedNotification resourcesUpdatedNotification = this.transport.unmarshalFrom(params, new TypeReference<McpSchema.ResourcesUpdatedNotification>(){});
            return this.readResource(new McpSchema.ReadResourceRequest(resourcesUpdatedNotification.getUri())).flatMap(readResourceResult -> Flux.fromIterable((Iterable)resourcesUpdateConsumers).flatMap(consumer -> (Mono)consumer.apply(readResourceResult.getContents())).onErrorResume(error -> {
                logger.error("Error handling resource update notification", error);
                return Mono.empty();
            }).then());
        };
    }

    public Mono<McpSchema.ListPromptsResult> listPrompts() {
        return this.listPrompts(McpSchema.FIRST_PAGE).expand(result -> result.getNextCursor() != null ? this.listPrompts(result.getNextCursor()) : Mono.empty()).reduce((Object)new McpSchema.ListPromptsResult(new ArrayList<McpSchema.Prompt>(), null), (allPromptsResult, result) -> {
            allPromptsResult.getPrompts().addAll(result.getPrompts());
            return allPromptsResult;
        }).map(result -> new McpSchema.ListPromptsResult(Collections.unmodifiableList(result.getPrompts()), null));
    }

    public Mono<McpSchema.ListPromptsResult> listPrompts(String cursor) {
        return this.initializer.withIntitialization("listing prompts", init -> init.mcpSession().sendRequest("prompts/list", new McpSchema.PaginatedRequest(cursor), LIST_PROMPTS_RESULT_TYPE_REF));
    }

    public Mono<McpSchema.GetPromptResult> getPrompt(McpSchema.GetPromptRequest getPromptRequest) {
        return this.initializer.withIntitialization("getting prompts", init -> init.mcpSession().sendRequest("prompts/get", getPromptRequest, GET_PROMPT_RESULT_TYPE_REF));
    }

    private McpClientSession.NotificationHandler asyncPromptsChangeNotificationHandler(List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers) {
        return params -> this.listPrompts().flatMap(listPromptsResult -> Flux.fromIterable((Iterable)promptsChangeConsumers).flatMap(consumer -> (Mono)consumer.apply(listPromptsResult.getPrompts())).onErrorResume(error -> {
            logger.error("Error handling prompts list change notification", error);
            return Mono.empty();
        }).then());
    }

    private McpClientSession.NotificationHandler asyncLoggingNotificationHandler(List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers) {
        return params -> {
            McpSchema.LoggingMessageNotification loggingMessageNotification = this.transport.unmarshalFrom(params, LOGGING_MESSAGE_NOTIFICATION_TYPE_REF);
            return Flux.fromIterable((Iterable)loggingConsumers).flatMap(consumer -> (Mono)consumer.apply(loggingMessageNotification)).then();
        };
    }

    public Mono<Void> setLoggingLevel(McpSchema.LoggingLevel loggingLevel) {
        if (loggingLevel == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Logging level must not be null"));
        }
        return this.initializer.withIntitialization("setting logging level", init -> {
            McpSchema.SetLevelRequest params = new McpSchema.SetLevelRequest(loggingLevel);
            return init.mcpSession().sendRequest("logging/setLevel", params, OBJECT_TYPE_REF).then();
        });
    }

    private McpClientSession.NotificationHandler asyncProgressNotificationHandler(List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers) {
        return params -> {
            McpSchema.ProgressNotification progressNotification = this.transport.unmarshalFrom(params, PROGRESS_NOTIFICATION_TYPE_REF);
            return Flux.fromIterable((Iterable)progressConsumers).flatMap(consumer -> (Mono)consumer.apply(progressNotification)).then();
        };
    }

    void setProtocolVersions(List<String> protocolVersions) {
        this.initializer.setProtocolVersions(protocolVersions);
    }

    public Mono<McpSchema.CompleteResult> completeCompletion(McpSchema.CompleteRequest completeRequest) {
        return this.initializer.withIntitialization("complete completions", init -> init.mcpSession().sendRequest("completion/complete", completeRequest, COMPLETION_COMPLETE_RESULT_TYPE_REF));
    }
}

