/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class McpClientFeatures {
    McpClientFeatures() {
    }

    public static class Sync {
        McpSchema.Implementation clientInfo;
        McpSchema.ClientCapabilities clientCapabilities;
        Map<String, McpSchema.Root> roots;
        List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers;
        List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers;
        List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers;
        List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers;
        List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers;
        List<Consumer<McpSchema.ProgressNotification>> progressConsumers;
        Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler;
        Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler;

        public Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, List<Consumer<McpSchema.ProgressNotification>> progressConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler, Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null, elicitationHandler != null ? new McpSchema.ClientCapabilities.Elicitation() : null);
            this.roots = roots != null ? new HashMap<String, McpSchema.Root>(roots) : new HashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : new ArrayList();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : new ArrayList();
            this.resourcesUpdateConsumers = resourcesUpdateConsumers != null ? resourcesUpdateConsumers : new ArrayList();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : new ArrayList();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : new ArrayList();
            this.progressConsumers = progressConsumers != null ? progressConsumers : new ArrayList();
            this.samplingHandler = samplingHandler;
            this.elicitationHandler = elicitationHandler;
        }

        public Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler, Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler) {
            this(clientInfo, clientCapabilities, roots, toolsChangeConsumers, resourcesChangeConsumers, resourcesUpdateConsumers, promptsChangeConsumers, loggingConsumers, new ArrayList<Consumer<McpSchema.ProgressNotification>>(), samplingHandler, elicitationHandler);
        }

        @Generated
        public McpSchema.Implementation getClientInfo() {
            return this.clientInfo;
        }

        @Generated
        public McpSchema.ClientCapabilities getClientCapabilities() {
            return this.clientCapabilities;
        }

        @Generated
        public Map<String, McpSchema.Root> getRoots() {
            return this.roots;
        }

        @Generated
        public List<Consumer<List<McpSchema.Tool>>> getToolsChangeConsumers() {
            return this.toolsChangeConsumers;
        }

        @Generated
        public List<Consumer<List<McpSchema.Resource>>> getResourcesChangeConsumers() {
            return this.resourcesChangeConsumers;
        }

        @Generated
        public List<Consumer<List<McpSchema.ResourceContents>>> getResourcesUpdateConsumers() {
            return this.resourcesUpdateConsumers;
        }

        @Generated
        public List<Consumer<List<McpSchema.Prompt>>> getPromptsChangeConsumers() {
            return this.promptsChangeConsumers;
        }

        @Generated
        public List<Consumer<McpSchema.LoggingMessageNotification>> getLoggingConsumers() {
            return this.loggingConsumers;
        }

        @Generated
        public List<Consumer<McpSchema.ProgressNotification>> getProgressConsumers() {
            return this.progressConsumers;
        }

        @Generated
        public Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> getSamplingHandler() {
            return this.samplingHandler;
        }

        @Generated
        public Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> getElicitationHandler() {
            return this.elicitationHandler;
        }

        @Generated
        public void setClientInfo(McpSchema.Implementation clientInfo) {
            this.clientInfo = clientInfo;
        }

        @Generated
        public void setClientCapabilities(McpSchema.ClientCapabilities clientCapabilities) {
            this.clientCapabilities = clientCapabilities;
        }

        @Generated
        public void setRoots(Map<String, McpSchema.Root> roots) {
            this.roots = roots;
        }

        @Generated
        public void setToolsChangeConsumers(List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers) {
            this.toolsChangeConsumers = toolsChangeConsumers;
        }

        @Generated
        public void setResourcesChangeConsumers(List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers) {
            this.resourcesChangeConsumers = resourcesChangeConsumers;
        }

        @Generated
        public void setResourcesUpdateConsumers(List<Consumer<List<McpSchema.ResourceContents>>> resourcesUpdateConsumers) {
            this.resourcesUpdateConsumers = resourcesUpdateConsumers;
        }

        @Generated
        public void setPromptsChangeConsumers(List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers) {
            this.promptsChangeConsumers = promptsChangeConsumers;
        }

        @Generated
        public void setLoggingConsumers(List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers) {
            this.loggingConsumers = loggingConsumers;
        }

        @Generated
        public void setProgressConsumers(List<Consumer<McpSchema.ProgressNotification>> progressConsumers) {
            this.progressConsumers = progressConsumers;
        }

        @Generated
        public void setSamplingHandler(Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
            this.samplingHandler = samplingHandler;
        }

        @Generated
        public void setElicitationHandler(Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> elicitationHandler) {
            this.elicitationHandler = elicitationHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sync)) {
                return false;
            }
            Sync other = (Sync)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Implementation this$clientInfo = this.getClientInfo();
            McpSchema.Implementation other$clientInfo = other.getClientInfo();
            if (this$clientInfo == null ? other$clientInfo != null : !((Object)this$clientInfo).equals(other$clientInfo)) {
                return false;
            }
            McpSchema.ClientCapabilities this$clientCapabilities = this.getClientCapabilities();
            McpSchema.ClientCapabilities other$clientCapabilities = other.getClientCapabilities();
            if (this$clientCapabilities == null ? other$clientCapabilities != null : !((Object)this$clientCapabilities).equals(other$clientCapabilities)) {
                return false;
            }
            Map<String, McpSchema.Root> this$roots = this.getRoots();
            Map<String, McpSchema.Root> other$roots = other.getRoots();
            if (this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots)) {
                return false;
            }
            List<Consumer<List<McpSchema.Tool>>> this$toolsChangeConsumers = this.getToolsChangeConsumers();
            List<Consumer<List<McpSchema.Tool>>> other$toolsChangeConsumers = other.getToolsChangeConsumers();
            if (this$toolsChangeConsumers == null ? other$toolsChangeConsumers != null : !((Object)this$toolsChangeConsumers).equals(other$toolsChangeConsumers)) {
                return false;
            }
            List<Consumer<List<McpSchema.Resource>>> this$resourcesChangeConsumers = this.getResourcesChangeConsumers();
            List<Consumer<List<McpSchema.Resource>>> other$resourcesChangeConsumers = other.getResourcesChangeConsumers();
            if (this$resourcesChangeConsumers == null ? other$resourcesChangeConsumers != null : !((Object)this$resourcesChangeConsumers).equals(other$resourcesChangeConsumers)) {
                return false;
            }
            List<Consumer<List<McpSchema.ResourceContents>>> this$resourcesUpdateConsumers = this.getResourcesUpdateConsumers();
            List<Consumer<List<McpSchema.ResourceContents>>> other$resourcesUpdateConsumers = other.getResourcesUpdateConsumers();
            if (this$resourcesUpdateConsumers == null ? other$resourcesUpdateConsumers != null : !((Object)this$resourcesUpdateConsumers).equals(other$resourcesUpdateConsumers)) {
                return false;
            }
            List<Consumer<List<McpSchema.Prompt>>> this$promptsChangeConsumers = this.getPromptsChangeConsumers();
            List<Consumer<List<McpSchema.Prompt>>> other$promptsChangeConsumers = other.getPromptsChangeConsumers();
            if (this$promptsChangeConsumers == null ? other$promptsChangeConsumers != null : !((Object)this$promptsChangeConsumers).equals(other$promptsChangeConsumers)) {
                return false;
            }
            List<Consumer<McpSchema.LoggingMessageNotification>> this$loggingConsumers = this.getLoggingConsumers();
            List<Consumer<McpSchema.LoggingMessageNotification>> other$loggingConsumers = other.getLoggingConsumers();
            if (this$loggingConsumers == null ? other$loggingConsumers != null : !((Object)this$loggingConsumers).equals(other$loggingConsumers)) {
                return false;
            }
            List<Consumer<McpSchema.ProgressNotification>> this$progressConsumers = this.getProgressConsumers();
            List<Consumer<McpSchema.ProgressNotification>> other$progressConsumers = other.getProgressConsumers();
            if (this$progressConsumers == null ? other$progressConsumers != null : !((Object)this$progressConsumers).equals(other$progressConsumers)) {
                return false;
            }
            Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> this$samplingHandler = this.getSamplingHandler();
            Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> other$samplingHandler = other.getSamplingHandler();
            if (this$samplingHandler == null ? other$samplingHandler != null : !this$samplingHandler.equals(other$samplingHandler)) {
                return false;
            }
            Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> this$elicitationHandler = this.getElicitationHandler();
            Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> other$elicitationHandler = other.getElicitationHandler();
            return !(this$elicitationHandler == null ? other$elicitationHandler != null : !this$elicitationHandler.equals(other$elicitationHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sync;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Implementation $clientInfo = this.getClientInfo();
            result = result * 59 + ($clientInfo == null ? 43 : ((Object)$clientInfo).hashCode());
            McpSchema.ClientCapabilities $clientCapabilities = this.getClientCapabilities();
            result = result * 59 + ($clientCapabilities == null ? 43 : ((Object)$clientCapabilities).hashCode());
            Map<String, McpSchema.Root> $roots = this.getRoots();
            result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
            List<Consumer<List<McpSchema.Tool>>> $toolsChangeConsumers = this.getToolsChangeConsumers();
            result = result * 59 + ($toolsChangeConsumers == null ? 43 : ((Object)$toolsChangeConsumers).hashCode());
            List<Consumer<List<McpSchema.Resource>>> $resourcesChangeConsumers = this.getResourcesChangeConsumers();
            result = result * 59 + ($resourcesChangeConsumers == null ? 43 : ((Object)$resourcesChangeConsumers).hashCode());
            List<Consumer<List<McpSchema.ResourceContents>>> $resourcesUpdateConsumers = this.getResourcesUpdateConsumers();
            result = result * 59 + ($resourcesUpdateConsumers == null ? 43 : ((Object)$resourcesUpdateConsumers).hashCode());
            List<Consumer<List<McpSchema.Prompt>>> $promptsChangeConsumers = this.getPromptsChangeConsumers();
            result = result * 59 + ($promptsChangeConsumers == null ? 43 : ((Object)$promptsChangeConsumers).hashCode());
            List<Consumer<McpSchema.LoggingMessageNotification>> $loggingConsumers = this.getLoggingConsumers();
            result = result * 59 + ($loggingConsumers == null ? 43 : ((Object)$loggingConsumers).hashCode());
            List<Consumer<McpSchema.ProgressNotification>> $progressConsumers = this.getProgressConsumers();
            result = result * 59 + ($progressConsumers == null ? 43 : ((Object)$progressConsumers).hashCode());
            Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> $samplingHandler = this.getSamplingHandler();
            result = result * 59 + ($samplingHandler == null ? 43 : $samplingHandler.hashCode());
            Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> $elicitationHandler = this.getElicitationHandler();
            result = result * 59 + ($elicitationHandler == null ? 43 : $elicitationHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpClientFeatures.Sync(clientInfo=" + this.getClientInfo() + ", clientCapabilities=" + this.getClientCapabilities() + ", roots=" + this.getRoots() + ", toolsChangeConsumers=" + this.getToolsChangeConsumers() + ", resourcesChangeConsumers=" + this.getResourcesChangeConsumers() + ", resourcesUpdateConsumers=" + this.getResourcesUpdateConsumers() + ", promptsChangeConsumers=" + this.getPromptsChangeConsumers() + ", loggingConsumers=" + this.getLoggingConsumers() + ", progressConsumers=" + this.getProgressConsumers() + ", samplingHandler=" + this.getSamplingHandler() + ", elicitationHandler=" + this.getElicitationHandler() + ")";
        }

        @Generated
        public Sync() {
        }
    }

    public static class Async {
        McpSchema.Implementation clientInfo;
        McpSchema.ClientCapabilities clientCapabilities;
        Map<String, McpSchema.Root> roots;
        List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers;
        List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers;
        List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers;
        List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers;
        List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers;
        List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers;
        Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler;
        Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler;

        public Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler, Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null, elicitationHandler != null ? new McpSchema.ClientCapabilities.Elicitation() : null);
            this.roots = roots != null ? new ConcurrentHashMap<String, McpSchema.Root>(roots) : new ConcurrentHashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : new ArrayList();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : new ArrayList();
            this.resourcesUpdateConsumers = resourcesUpdateConsumers != null ? resourcesUpdateConsumers : new ArrayList();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : new ArrayList();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : new ArrayList();
            this.progressConsumers = progressConsumers != null ? progressConsumers : new ArrayList();
            this.samplingHandler = samplingHandler;
            this.elicitationHandler = elicitationHandler;
        }

        public Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler, Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler) {
            this(clientInfo, clientCapabilities, roots, toolsChangeConsumers, resourcesChangeConsumers, resourcesUpdateConsumers, promptsChangeConsumers, loggingConsumers, new ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>>(), samplingHandler, elicitationHandler);
        }

        public static Async fromSync(Sync syncSpec) {
            ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Tool>> consumer : syncSpec.getToolsChangeConsumers()) {
                toolsChangeConsumers.add(t -> Mono.fromRunnable(() -> consumer.accept(t)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Resource>> consumer : syncSpec.getResourcesChangeConsumers()) {
                resourcesChangeConsumers.add(r -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Resource>)r)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>> arrayList = new ArrayList<Function<List<McpSchema.ResourceContents>, Mono<Void>>>();
            for (Consumer<List<McpSchema.ResourceContents>> consumer : syncSpec.getResourcesUpdateConsumers()) {
                arrayList.add(r -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.ResourceContents>)r)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>> arrayList2 = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Prompt>> consumer : syncSpec.getPromptsChangeConsumers()) {
                arrayList2.add(p -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Prompt>)p)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> arrayList3 = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>();
            for (Consumer<McpSchema.LoggingMessageNotification> consumer : syncSpec.getLoggingConsumers()) {
                arrayList3.add(l -> Mono.fromRunnable(() -> consumer.accept((McpSchema.LoggingMessageNotification)l)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>> arrayList4 = new ArrayList<Function<McpSchema.ProgressNotification, Mono<Void>>>();
            for (Consumer<McpSchema.ProgressNotification> consumer : syncSpec.getProgressConsumers()) {
                arrayList4.add(l -> Mono.fromRunnable(() -> consumer.accept(l)).subscribeOn(Schedulers.boundedElastic()));
            }
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> function = r -> Mono.fromCallable(() -> syncSpec.getSamplingHandler().apply((McpSchema.CreateMessageRequest)r)).subscribeOn(Schedulers.boundedElastic());
            Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> function2 = r -> Mono.fromCallable(() -> syncSpec.getElicitationHandler().apply((McpSchema.ElicitRequest)r)).subscribeOn(Schedulers.boundedElastic());
            return new Async(syncSpec.getClientInfo(), syncSpec.getClientCapabilities(), syncSpec.getRoots(), toolsChangeConsumers, resourcesChangeConsumers, arrayList, arrayList2, arrayList3, arrayList4, function, function2);
        }

        @Generated
        public McpSchema.Implementation getClientInfo() {
            return this.clientInfo;
        }

        @Generated
        public McpSchema.ClientCapabilities getClientCapabilities() {
            return this.clientCapabilities;
        }

        @Generated
        public Map<String, McpSchema.Root> getRoots() {
            return this.roots;
        }

        @Generated
        public List<Function<List<McpSchema.Tool>, Mono<Void>>> getToolsChangeConsumers() {
            return this.toolsChangeConsumers;
        }

        @Generated
        public List<Function<List<McpSchema.Resource>, Mono<Void>>> getResourcesChangeConsumers() {
            return this.resourcesChangeConsumers;
        }

        @Generated
        public List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> getResourcesUpdateConsumers() {
            return this.resourcesUpdateConsumers;
        }

        @Generated
        public List<Function<List<McpSchema.Prompt>, Mono<Void>>> getPromptsChangeConsumers() {
            return this.promptsChangeConsumers;
        }

        @Generated
        public List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> getLoggingConsumers() {
            return this.loggingConsumers;
        }

        @Generated
        public List<Function<McpSchema.ProgressNotification, Mono<Void>>> getProgressConsumers() {
            return this.progressConsumers;
        }

        @Generated
        public Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> getSamplingHandler() {
            return this.samplingHandler;
        }

        @Generated
        public Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> getElicitationHandler() {
            return this.elicitationHandler;
        }

        @Generated
        public void setClientInfo(McpSchema.Implementation clientInfo) {
            this.clientInfo = clientInfo;
        }

        @Generated
        public void setClientCapabilities(McpSchema.ClientCapabilities clientCapabilities) {
            this.clientCapabilities = clientCapabilities;
        }

        @Generated
        public void setRoots(Map<String, McpSchema.Root> roots) {
            this.roots = roots;
        }

        @Generated
        public void setToolsChangeConsumers(List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers) {
            this.toolsChangeConsumers = toolsChangeConsumers;
        }

        @Generated
        public void setResourcesChangeConsumers(List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers) {
            this.resourcesChangeConsumers = resourcesChangeConsumers;
        }

        @Generated
        public void setResourcesUpdateConsumers(List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> resourcesUpdateConsumers) {
            this.resourcesUpdateConsumers = resourcesUpdateConsumers;
        }

        @Generated
        public void setPromptsChangeConsumers(List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers) {
            this.promptsChangeConsumers = promptsChangeConsumers;
        }

        @Generated
        public void setLoggingConsumers(List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers) {
            this.loggingConsumers = loggingConsumers;
        }

        @Generated
        public void setProgressConsumers(List<Function<McpSchema.ProgressNotification, Mono<Void>>> progressConsumers) {
            this.progressConsumers = progressConsumers;
        }

        @Generated
        public void setSamplingHandler(Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler) {
            this.samplingHandler = samplingHandler;
        }

        @Generated
        public void setElicitationHandler(Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> elicitationHandler) {
            this.elicitationHandler = elicitationHandler;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Async)) {
                return false;
            }
            Async other = (Async)o;
            if (!other.canEqual(this)) {
                return false;
            }
            McpSchema.Implementation this$clientInfo = this.getClientInfo();
            McpSchema.Implementation other$clientInfo = other.getClientInfo();
            if (this$clientInfo == null ? other$clientInfo != null : !((Object)this$clientInfo).equals(other$clientInfo)) {
                return false;
            }
            McpSchema.ClientCapabilities this$clientCapabilities = this.getClientCapabilities();
            McpSchema.ClientCapabilities other$clientCapabilities = other.getClientCapabilities();
            if (this$clientCapabilities == null ? other$clientCapabilities != null : !((Object)this$clientCapabilities).equals(other$clientCapabilities)) {
                return false;
            }
            Map<String, McpSchema.Root> this$roots = this.getRoots();
            Map<String, McpSchema.Root> other$roots = other.getRoots();
            if (this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots)) {
                return false;
            }
            List<Function<List<McpSchema.Tool>, Mono<Void>>> this$toolsChangeConsumers = this.getToolsChangeConsumers();
            List<Function<List<McpSchema.Tool>, Mono<Void>>> other$toolsChangeConsumers = other.getToolsChangeConsumers();
            if (this$toolsChangeConsumers == null ? other$toolsChangeConsumers != null : !((Object)this$toolsChangeConsumers).equals(other$toolsChangeConsumers)) {
                return false;
            }
            List<Function<List<McpSchema.Resource>, Mono<Void>>> this$resourcesChangeConsumers = this.getResourcesChangeConsumers();
            List<Function<List<McpSchema.Resource>, Mono<Void>>> other$resourcesChangeConsumers = other.getResourcesChangeConsumers();
            if (this$resourcesChangeConsumers == null ? other$resourcesChangeConsumers != null : !((Object)this$resourcesChangeConsumers).equals(other$resourcesChangeConsumers)) {
                return false;
            }
            List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> this$resourcesUpdateConsumers = this.getResourcesUpdateConsumers();
            List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> other$resourcesUpdateConsumers = other.getResourcesUpdateConsumers();
            if (this$resourcesUpdateConsumers == null ? other$resourcesUpdateConsumers != null : !((Object)this$resourcesUpdateConsumers).equals(other$resourcesUpdateConsumers)) {
                return false;
            }
            List<Function<List<McpSchema.Prompt>, Mono<Void>>> this$promptsChangeConsumers = this.getPromptsChangeConsumers();
            List<Function<List<McpSchema.Prompt>, Mono<Void>>> other$promptsChangeConsumers = other.getPromptsChangeConsumers();
            if (this$promptsChangeConsumers == null ? other$promptsChangeConsumers != null : !((Object)this$promptsChangeConsumers).equals(other$promptsChangeConsumers)) {
                return false;
            }
            List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> this$loggingConsumers = this.getLoggingConsumers();
            List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> other$loggingConsumers = other.getLoggingConsumers();
            if (this$loggingConsumers == null ? other$loggingConsumers != null : !((Object)this$loggingConsumers).equals(other$loggingConsumers)) {
                return false;
            }
            List<Function<McpSchema.ProgressNotification, Mono<Void>>> this$progressConsumers = this.getProgressConsumers();
            List<Function<McpSchema.ProgressNotification, Mono<Void>>> other$progressConsumers = other.getProgressConsumers();
            if (this$progressConsumers == null ? other$progressConsumers != null : !((Object)this$progressConsumers).equals(other$progressConsumers)) {
                return false;
            }
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> this$samplingHandler = this.getSamplingHandler();
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> other$samplingHandler = other.getSamplingHandler();
            if (this$samplingHandler == null ? other$samplingHandler != null : !this$samplingHandler.equals(other$samplingHandler)) {
                return false;
            }
            Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> this$elicitationHandler = this.getElicitationHandler();
            Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> other$elicitationHandler = other.getElicitationHandler();
            return !(this$elicitationHandler == null ? other$elicitationHandler != null : !this$elicitationHandler.equals(other$elicitationHandler));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Async;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            McpSchema.Implementation $clientInfo = this.getClientInfo();
            result = result * 59 + ($clientInfo == null ? 43 : ((Object)$clientInfo).hashCode());
            McpSchema.ClientCapabilities $clientCapabilities = this.getClientCapabilities();
            result = result * 59 + ($clientCapabilities == null ? 43 : ((Object)$clientCapabilities).hashCode());
            Map<String, McpSchema.Root> $roots = this.getRoots();
            result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
            List<Function<List<McpSchema.Tool>, Mono<Void>>> $toolsChangeConsumers = this.getToolsChangeConsumers();
            result = result * 59 + ($toolsChangeConsumers == null ? 43 : ((Object)$toolsChangeConsumers).hashCode());
            List<Function<List<McpSchema.Resource>, Mono<Void>>> $resourcesChangeConsumers = this.getResourcesChangeConsumers();
            result = result * 59 + ($resourcesChangeConsumers == null ? 43 : ((Object)$resourcesChangeConsumers).hashCode());
            List<Function<List<McpSchema.ResourceContents>, Mono<Void>>> $resourcesUpdateConsumers = this.getResourcesUpdateConsumers();
            result = result * 59 + ($resourcesUpdateConsumers == null ? 43 : ((Object)$resourcesUpdateConsumers).hashCode());
            List<Function<List<McpSchema.Prompt>, Mono<Void>>> $promptsChangeConsumers = this.getPromptsChangeConsumers();
            result = result * 59 + ($promptsChangeConsumers == null ? 43 : ((Object)$promptsChangeConsumers).hashCode());
            List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> $loggingConsumers = this.getLoggingConsumers();
            result = result * 59 + ($loggingConsumers == null ? 43 : ((Object)$loggingConsumers).hashCode());
            List<Function<McpSchema.ProgressNotification, Mono<Void>>> $progressConsumers = this.getProgressConsumers();
            result = result * 59 + ($progressConsumers == null ? 43 : ((Object)$progressConsumers).hashCode());
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> $samplingHandler = this.getSamplingHandler();
            result = result * 59 + ($samplingHandler == null ? 43 : $samplingHandler.hashCode());
            Function<McpSchema.ElicitRequest, Mono<McpSchema.ElicitResult>> $elicitationHandler = this.getElicitationHandler();
            result = result * 59 + ($elicitationHandler == null ? 43 : $elicitationHandler.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpClientFeatures.Async(clientInfo=" + this.getClientInfo() + ", clientCapabilities=" + this.getClientCapabilities() + ", roots=" + this.getRoots() + ", toolsChangeConsumers=" + this.getToolsChangeConsumers() + ", resourcesChangeConsumers=" + this.getResourcesChangeConsumers() + ", resourcesUpdateConsumers=" + this.getResourcesUpdateConsumers() + ", promptsChangeConsumers=" + this.getPromptsChangeConsumers() + ", loggingConsumers=" + this.getLoggingConsumers() + ", progressConsumers=" + this.getProgressConsumers() + ", samplingHandler=" + this.getSamplingHandler() + ", elicitationHandler=" + this.getElicitationHandler() + ")";
        }

        @Generated
        public Async() {
        }
    }
}

