/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpSchema {
    private static final Logger logger = LoggerFactory.getLogger(McpSchema.class);
    @Deprecated
    public static final String LATEST_PROTOCOL_VERSION = "2025-03-26";
    public static final String JSONRPC_VERSION = "2.0";
    public static final String FIRST_PAGE = null;
    public static final String METHOD_INITIALIZE = "initialize";
    public static final String METHOD_NOTIFICATION_INITIALIZED = "notifications/initialized";
    public static final String METHOD_PING = "ping";
    public static final String METHOD_NOTIFICATION_PROGRESS = "notifications/progress";
    public static final String METHOD_TOOLS_LIST = "tools/list";
    public static final String METHOD_TOOLS_CALL = "tools/call";
    public static final String METHOD_NOTIFICATION_TOOLS_LIST_CHANGED = "notifications/tools/list_changed";
    public static final String METHOD_RESOURCES_LIST = "resources/list";
    public static final String METHOD_RESOURCES_READ = "resources/read";
    public static final String METHOD_NOTIFICATION_RESOURCES_LIST_CHANGED = "notifications/resources/list_changed";
    public static final String METHOD_NOTIFICATION_RESOURCES_UPDATED = "notifications/resources/updated";
    public static final String METHOD_RESOURCES_TEMPLATES_LIST = "resources/templates/list";
    public static final String METHOD_RESOURCES_SUBSCRIBE = "resources/subscribe";
    public static final String METHOD_RESOURCES_UNSUBSCRIBE = "resources/unsubscribe";
    public static final String METHOD_PROMPT_LIST = "prompts/list";
    public static final String METHOD_PROMPT_GET = "prompts/get";
    public static final String METHOD_NOTIFICATION_PROMPTS_LIST_CHANGED = "notifications/prompts/list_changed";
    public static final String METHOD_COMPLETION_COMPLETE = "completion/complete";
    public static final String METHOD_LOGGING_SET_LEVEL = "logging/setLevel";
    public static final String METHOD_NOTIFICATION_MESSAGE = "notifications/message";
    public static final String METHOD_ROOTS_LIST = "roots/list";
    public static final String METHOD_NOTIFICATION_ROOTS_LIST_CHANGED = "notifications/roots/list_changed";
    public static final String METHOD_SAMPLING_CREATE_MESSAGE = "sampling/createMessage";
    public static final String METHOD_ELICITATION_CREATE = "elicitation/create";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, Object>> MAP_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};

    private McpSchema() {
    }

    public static JSONRPCMessage deserializeJsonRpcMessage(ObjectMapper objectMapper, String jsonText) throws IOException {
        logger.debug("Received JSON message: {}", (Object)jsonText);
        HashMap map = (HashMap)objectMapper.readValue(jsonText, MAP_TYPE_REF);
        if (map.containsKey("method") && map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCRequest.class);
        }
        if (map.containsKey("method") && !map.containsKey("id")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCNotification.class);
        }
        if (map.containsKey("result") || map.containsKey("error")) {
            return (JSONRPCMessage)objectMapper.convertValue((Object)map, JSONRPCResponse.class);
        }
        throw new IllegalArgumentException("Cannot deserialize JSONRPCMessage: " + jsonText);
    }

    private static Map<String, Object> schemaToMap(String schema) {
        try {
            return (Map)OBJECT_MAPPER.readValue(schema, MAP_TYPE_REF);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid schema: " + schema, e);
        }
    }

    private static JsonSchema parseSchema(String schema) {
        try {
            return (JsonSchema)OBJECT_MAPPER.readValue(schema, JsonSchema.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid schema: " + schema, e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListRootsResult
    implements Result {
        @JsonProperty(value="roots")
        List<Root> roots;
        @JsonProperty(value="nextCursor")
        String nextCursor;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ListRootsResult(List<Root> roots) {
            this(roots, null);
        }

        public ListRootsResult(List<Root> roots, String nextCursor) {
            this(roots, nextCursor, null);
        }

        @Generated
        public List<Root> getRoots() {
            return this.roots;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="roots")
        @Generated
        public void setRoots(List<Root> roots) {
            this.roots = roots;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListRootsResult)) {
                return false;
            }
            ListRootsResult other = (ListRootsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Root> this$roots = this.getRoots();
            List<Root> other$roots = other.getRoots();
            if (this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            if (this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListRootsResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Root> $roots = this.getRoots();
            result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListRootsResult(roots=" + this.getRoots() + ", nextCursor=" + this.getNextCursor() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ListRootsResult(List<Root> roots, String nextCursor, Map<String, Object> meta) {
            this.roots = roots;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        @Generated
        public ListRootsResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Root {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public Root(String uri, String name) {
            this(uri, name, null);
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Root)) {
                return false;
            }
            Root other = (Root)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Root;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Root(uri=" + this.getUri() + ", name=" + this.getName() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public Root(String uri, String name, Map<String, Object> meta) {
            this.uri = uri;
            this.name = name;
            this.meta = meta;
        }

        @Generated
        public Root() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceLink
    implements Annotated,
    Content,
    ResourceContent {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="size")
        Long size;
        @JsonProperty(value="annotations")
        Annotations annotations;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        @Deprecated
        public ResourceLink(String name, String title, String uri, String description, String mimeType, Long size, Annotations annotations) {
            this(name, title, uri, description, mimeType, size, annotations, null);
        }

        @Deprecated
        public ResourceLink(String name, String uri, String description, String mimeType, Long size, Annotations annotations) {
            this(name, null, uri, description, mimeType, size, annotations);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Override
        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        @Generated
        public Long getSize() {
            return this.size;
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="size")
        @Generated
        public void setSize(Long size) {
            this.size = size;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceLink)) {
                return false;
            }
            ResourceLink other = (ResourceLink)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$size = this.getSize();
            Long other$size = other.getSize();
            if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourceLink;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ResourceLink(name=" + this.getName() + ", title=" + this.getTitle() + ", uri=" + this.getUri() + ", description=" + this.getDescription() + ", mimeType=" + this.getMimeType() + ", size=" + this.getSize() + ", annotations=" + this.getAnnotations() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ResourceLink(String name, String title, String uri, String description, String mimeType, Long size, Annotations annotations, Map<String, Object> meta) {
            this.name = name;
            this.title = title;
            this.uri = uri;
            this.description = description;
            this.mimeType = mimeType;
            this.size = size;
            this.annotations = annotations;
            this.meta = meta;
        }

        @Generated
        public ResourceLink() {
        }

        public static class Builder {
            private String name;
            private String title;
            private String uri;
            private String description;
            private String mimeType;
            private Annotations annotations;
            private Long size;
            private Map<String, Object> meta;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder annotations(Annotations annotations) {
                this.annotations = annotations;
                return this;
            }

            public Builder size(Long size) {
                this.size = size;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public ResourceLink build() {
                Assert.hasText(this.uri, "uri must not be empty");
                Assert.hasText(this.name, "name must not be empty");
                return new ResourceLink(this.name, this.title, this.uri, this.description, this.mimeType, this.size, this.annotations, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class EmbeddedResource
    implements Annotated,
    Content {
        @JsonProperty(value="annotations")
        Annotations annotations;
        @JsonProperty(value="resource")
        ResourceContents resource;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public EmbeddedResource(Annotations annotations, ResourceContents resource) {
            this(annotations, resource, null);
        }

        @Deprecated
        public EmbeddedResource(List<Role> audience, Double priority, ResourceContents resource) {
            this(audience != null || priority != null ? new Annotations(audience, priority) : null, resource, null);
        }

        @Deprecated
        public List<Role> getAudience() {
            return this.annotations == null ? null : this.annotations.getAudience();
        }

        @Deprecated
        public Double getPriority() {
            return this.annotations == null ? null : this.annotations.getPriority();
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public ResourceContents getResource() {
            return this.resource;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="resource")
        @Generated
        public void setResource(ResourceContents resource) {
            this.resource = resource;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EmbeddedResource)) {
                return false;
            }
            EmbeddedResource other = (EmbeddedResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            ResourceContents this$resource = this.getResource();
            ResourceContents other$resource = other.getResource();
            if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EmbeddedResource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            ResourceContents $resource = this.getResource();
            result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.EmbeddedResource(annotations=" + this.getAnnotations() + ", resource=" + this.getResource() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public EmbeddedResource(Annotations annotations, ResourceContents resource, Map<String, Object> meta) {
            this.annotations = annotations;
            this.resource = resource;
            this.meta = meta;
        }

        @Generated
        public EmbeddedResource() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AudioContent
    implements Annotated,
    Content {
        @JsonProperty(value="annotations")
        Annotations annotations;
        @JsonProperty(value="data")
        String data;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public AudioContent(Annotations annotations, String data, String mimeType) {
            this(annotations, data, mimeType, null);
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="data")
        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AudioContent)) {
                return false;
            }
            AudioContent other = (AudioContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AudioContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.AudioContent(annotations=" + this.getAnnotations() + ", data=" + this.getData() + ", mimeType=" + this.getMimeType() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public AudioContent(Annotations annotations, String data, String mimeType, Map<String, Object> meta) {
            this.annotations = annotations;
            this.data = data;
            this.mimeType = mimeType;
            this.meta = meta;
        }

        @Generated
        public AudioContent() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ImageContent
    implements Annotated,
    Content {
        @JsonProperty(value="annotations")
        Annotations annotations;
        @JsonProperty(value="data")
        String data;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ImageContent(Annotations annotations, String data, String mimeType) {
            this(annotations, data, mimeType, null);
        }

        @Deprecated
        public ImageContent(List<Role> audience, Double priority, String data, String mimeType) {
            this(audience != null || priority != null ? new Annotations(audience, priority) : null, data, mimeType, null);
        }

        @Deprecated
        public List<Role> getAudience() {
            return this.annotations == null ? null : this.annotations.getAudience();
        }

        @Deprecated
        public Double getPriority() {
            return this.annotations == null ? null : this.annotations.getPriority();
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="data")
        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageContent)) {
                return false;
            }
            ImageContent other = (ImageContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ImageContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ImageContent(annotations=" + this.getAnnotations() + ", data=" + this.getData() + ", mimeType=" + this.getMimeType() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ImageContent(Annotations annotations, String data, String mimeType, Map<String, Object> meta) {
            this.annotations = annotations;
            this.data = data;
            this.mimeType = mimeType;
            this.meta = meta;
        }

        @Generated
        public ImageContent() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextContent
    implements Annotated,
    Content {
        @JsonProperty(value="annotations")
        Annotations annotations;
        @JsonProperty(value="text")
        String text;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public TextContent(Annotations annotations, String text) {
            this(annotations, text, null);
        }

        public TextContent(String content) {
            this(null, content, null);
        }

        @Deprecated
        public TextContent(List<Role> audience, Double priority, String content) {
            this(audience != null || priority != null ? new Annotations(audience, priority) : null, content, null);
        }

        @Deprecated
        public List<Role> getAudience() {
            return this.annotations == null ? null : this.annotations.getAudience();
        }

        @Deprecated
        public Double getPriority() {
            return this.annotations == null ? null : this.annotations.getPriority();
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="text")
        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextContent)) {
                return false;
            }
            TextContent other = (TextContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TextContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.TextContent(annotations=" + this.getAnnotations() + ", text=" + this.getText() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public TextContent(Annotations annotations, String text, Map<String, Object> meta) {
            this.annotations = annotations;
            this.text = text;
            this.meta = meta;
        }

        @Generated
        public TextContent() {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextContent.class, name="text"), @JsonSubTypes.Type(value=ImageContent.class, name="image"), @JsonSubTypes.Type(value=AudioContent.class, name="audio"), @JsonSubTypes.Type(value=EmbeddedResource.class, name="resource"), @JsonSubTypes.Type(value=ResourceLink.class, name="resource_link")})
    public static interface Content {
        public Map<String, Object> getMeta();

        default public String type() {
            if (this instanceof TextContent) {
                return "text";
            }
            if (this instanceof ImageContent) {
                return "image";
            }
            if (this instanceof AudioContent) {
                return "audio";
            }
            if (this instanceof EmbeddedResource) {
                return "resource";
            }
            if (this instanceof ResourceLink) {
                return "resource_link";
            }
            throw new IllegalArgumentException("Unknown content type: " + this);
        }
    }

    public static class CompleteResult
    implements Result {
        @JsonProperty(value="completion")
        CompleteCompletion completion;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public CompleteResult(CompleteCompletion completion) {
            this(completion, null);
        }

        @Generated
        public CompleteCompletion getCompletion() {
            return this.completion;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="completion")
        @Generated
        public void setCompletion(CompleteCompletion completion) {
            this.completion = completion;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompleteResult)) {
                return false;
            }
            CompleteResult other = (CompleteResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompleteCompletion this$completion = this.getCompletion();
            CompleteCompletion other$completion = other.getCompletion();
            if (this$completion == null ? other$completion != null : !((Object)this$completion).equals(other$completion)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CompleteResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompleteCompletion $completion = this.getCompletion();
            result = result * 59 + ($completion == null ? 43 : ((Object)$completion).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CompleteResult(completion=" + this.getCompletion() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public CompleteResult(CompleteCompletion completion, Map<String, Object> meta) {
            this.completion = completion;
            this.meta = meta;
        }

        @Generated
        public CompleteResult() {
        }

        public static class CompleteCompletion {
            @JsonProperty(value="values")
            List<String> values;
            @JsonProperty(value="total")
            Integer total;
            @JsonProperty(value="hasMore")
            Boolean hasMore;

            @Generated
            public List<String> getValues() {
                return this.values;
            }

            @Generated
            public Integer getTotal() {
                return this.total;
            }

            @Generated
            public Boolean getHasMore() {
                return this.hasMore;
            }

            @JsonProperty(value="values")
            @Generated
            public void setValues(List<String> values) {
                this.values = values;
            }

            @JsonProperty(value="total")
            @Generated
            public void setTotal(Integer total) {
                this.total = total;
            }

            @JsonProperty(value="hasMore")
            @Generated
            public void setHasMore(Boolean hasMore) {
                this.hasMore = hasMore;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CompleteCompletion)) {
                    return false;
                }
                CompleteCompletion other = (CompleteCompletion)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$total = this.getTotal();
                Integer other$total = other.getTotal();
                if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                    return false;
                }
                Boolean this$hasMore = this.getHasMore();
                Boolean other$hasMore = other.getHasMore();
                if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
                    return false;
                }
                List<String> this$values = this.getValues();
                List<String> other$values = other.getValues();
                return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CompleteCompletion;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $total = this.getTotal();
                result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
                Boolean $hasMore = this.getHasMore();
                result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
                List<String> $values = this.getValues();
                result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.CompleteResult.CompleteCompletion(values=" + this.getValues() + ", total=" + this.getTotal() + ", hasMore=" + this.getHasMore() + ")";
            }

            @Generated
            public CompleteCompletion(List<String> values, Integer total, Boolean hasMore) {
                this.values = values;
                this.total = total;
                this.hasMore = hasMore;
            }

            @Generated
            public CompleteCompletion() {
            }
        }
    }

    public static class CompleteRequest
    implements Request {
        @JsonProperty(value="ref")
        CompleteReference ref;
        @JsonProperty(value="argument")
        CompleteArgument argument;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;
        @JsonProperty(value="context")
        CompleteContext context;

        public CompleteRequest(CompleteReference ref, CompleteArgument argument, Map<String, Object> meta) {
            this(ref, argument, meta, null);
        }

        public CompleteRequest(CompleteReference ref, CompleteArgument argument, CompleteContext context) {
            this(ref, argument, null, context);
        }

        public CompleteRequest(CompleteReference ref, CompleteArgument argument) {
            this(ref, argument, null, null);
        }

        @Generated
        public CompleteReference getRef() {
            return this.ref;
        }

        @Generated
        public CompleteArgument getArgument() {
            return this.argument;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @Generated
        public CompleteContext getContext() {
            return this.context;
        }

        @JsonProperty(value="ref")
        @Generated
        public void setRef(CompleteReference ref) {
            this.ref = ref;
        }

        @JsonProperty(value="argument")
        @Generated
        public void setArgument(CompleteArgument argument) {
            this.argument = argument;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @JsonProperty(value="context")
        @Generated
        public void setContext(CompleteContext context) {
            this.context = context;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompleteRequest)) {
                return false;
            }
            CompleteRequest other = (CompleteRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompleteReference this$ref = this.getRef();
            CompleteReference other$ref = other.getRef();
            if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
                return false;
            }
            CompleteArgument this$argument = this.getArgument();
            CompleteArgument other$argument = other.getArgument();
            if (this$argument == null ? other$argument != null : !((Object)this$argument).equals(other$argument)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
                return false;
            }
            CompleteContext this$context = this.getContext();
            CompleteContext other$context = other.getContext();
            return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CompleteRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompleteReference $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
            CompleteArgument $argument = this.getArgument();
            result = result * 59 + ($argument == null ? 43 : ((Object)$argument).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            CompleteContext $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CompleteRequest(ref=" + this.getRef() + ", argument=" + this.getArgument() + ", meta=" + this.getMeta() + ", context=" + this.getContext() + ")";
        }

        @Generated
        public CompleteRequest(CompleteReference ref, CompleteArgument argument, Map<String, Object> meta, CompleteContext context) {
            this.ref = ref;
            this.argument = argument;
            this.meta = meta;
            this.context = context;
        }

        @Generated
        public CompleteRequest() {
        }

        public static class CompleteContext {
            @JsonProperty(value="arguments")
            Map<String, String> arguments;

            @Generated
            public Map<String, String> getArguments() {
                return this.arguments;
            }

            @JsonProperty(value="arguments")
            @Generated
            public void setArguments(Map<String, String> arguments) {
                this.arguments = arguments;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CompleteContext)) {
                    return false;
                }
                CompleteContext other = (CompleteContext)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, String> this$arguments = this.getArguments();
                Map<String, String> other$arguments = other.getArguments();
                return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CompleteContext;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, String> $arguments = this.getArguments();
                result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.CompleteRequest.CompleteContext(arguments=" + this.getArguments() + ")";
            }

            @Generated
            public CompleteContext(Map<String, String> arguments) {
                this.arguments = arguments;
            }

            @Generated
            public CompleteContext() {
            }
        }

        public static class CompleteArgument {
            @JsonProperty(value="name")
            String name;
            @JsonProperty(value="value")
            String value;

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @JsonProperty(value="name")
            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @JsonProperty(value="value")
            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CompleteArgument)) {
                    return false;
                }
                CompleteArgument other = (CompleteArgument)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CompleteArgument;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.CompleteRequest.CompleteArgument(name=" + this.getName() + ", value=" + this.getValue() + ")";
            }

            @Generated
            public CompleteArgument(String name, String value) {
                this.name = name;
                this.value = value;
            }

            @Generated
            public CompleteArgument() {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceReference
    implements CompleteReference {
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="uri")
        String uri;

        public ResourceReference(String uri) {
            this("ref/resource", uri);
        }

        @Override
        public String getIdentifier() {
            return this.getUri();
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @JsonProperty(value="type")
        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceReference)) {
                return false;
            }
            ResourceReference other = (ResourceReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourceReference;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ResourceReference(type=" + this.getType() + ", uri=" + this.getUri() + ")";
        }

        @Generated
        public ResourceReference(String type, String uri) {
            this.type = type;
            this.uri = uri;
        }

        @Generated
        public ResourceReference() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptReference
    implements CompleteReference,
    BaseMetadata {
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;

        public PromptReference(String type, String name) {
            this(type, name, null);
        }

        public PromptReference(String name) {
            this("ref/prompt", name, null);
        }

        @Override
        public String getIdentifier() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PromptReference that = (PromptReference)obj;
            return Objects.equals(this.getIdentifier(), that.getIdentifier()) && Objects.equals(this.getType(), that.getType());
        }

        public int hashCode() {
            return Objects.hash(this.getIdentifier(), this.getType());
        }

        @Override
        @Generated
        public String getType() {
            return this.type;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="type")
        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public String toString() {
            return "McpSchema.PromptReference(type=" + this.getType() + ", name=" + this.getName() + ", title=" + this.getTitle() + ")";
        }

        @Generated
        public PromptReference(String type, String name, String title) {
            this.type = type;
            this.name = name;
            this.title = title;
        }

        @Generated
        public PromptReference() {
        }
    }

    public static interface CompleteReference {
        public String getType();

        public String getIdentifier();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SetLevelRequest {
        @JsonProperty(value="level")
        LoggingLevel level;

        @Generated
        public LoggingLevel getLevel() {
            return this.level;
        }

        @JsonProperty(value="level")
        @Generated
        public void setLevel(LoggingLevel level) {
            this.level = level;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetLevelRequest)) {
                return false;
            }
            SetLevelRequest other = (SetLevelRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoggingLevel this$level = this.getLevel();
            LoggingLevel other$level = other.getLevel();
            return !(this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SetLevelRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoggingLevel $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.SetLevelRequest(level=" + (Object)((Object)this.getLevel()) + ")";
        }

        @Generated
        public SetLevelRequest(LoggingLevel level) {
            this.level = level;
        }

        @Generated
        public SetLevelRequest() {
        }
    }

    public static enum LoggingLevel {
        DEBUG(0),
        INFO(1),
        NOTICE(2),
        WARNING(3),
        ERROR(4),
        CRITICAL(5),
        ALERT(6),
        EMERGENCY(7);

        private final int level;

        private LoggingLevel(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoggingMessageNotification
    implements Notification {
        @JsonProperty(value="level")
        LoggingLevel level;
        @JsonProperty(value="logger")
        String logger;
        @JsonProperty(value="data")
        String data;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public LoggingMessageNotification(LoggingLevel level, String logger, String data) {
            this(level, logger, data, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public LoggingLevel getLevel() {
            return this.level;
        }

        @Generated
        public String getLogger() {
            return this.logger;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="level")
        @Generated
        public void setLevel(LoggingLevel level) {
            this.level = level;
        }

        @JsonProperty(value="logger")
        @Generated
        public void setLogger(String logger) {
            this.logger = logger;
        }

        @JsonProperty(value="data")
        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoggingMessageNotification)) {
                return false;
            }
            LoggingMessageNotification other = (LoggingMessageNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoggingLevel this$level = this.getLevel();
            LoggingLevel other$level = other.getLevel();
            if (this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level)) {
                return false;
            }
            String this$logger = this.getLogger();
            String other$logger = other.getLogger();
            if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoggingMessageNotification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoggingLevel $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
            String $logger = this.getLogger();
            result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.LoggingMessageNotification(level=" + (Object)((Object)this.getLevel()) + ", logger=" + this.getLogger() + ", data=" + this.getData() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public LoggingMessageNotification(LoggingLevel level, String logger, String data, Map<String, Object> meta) {
            this.level = level;
            this.logger = logger;
            this.data = data;
            this.meta = meta;
        }

        @Generated
        public LoggingMessageNotification() {
        }

        public static class Builder {
            private LoggingLevel level = LoggingLevel.INFO;
            private String logger = "server";
            private String data;
            private Map<String, Object> meta;

            public Builder level(LoggingLevel level) {
                this.level = level;
                return this;
            }

            public Builder logger(String logger) {
                this.logger = logger;
                return this;
            }

            public Builder data(String data) {
                this.data = data;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public LoggingMessageNotification build() {
                return new LoggingMessageNotification(this.level, this.logger, this.data, this.meta);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourcesUpdatedNotification
    implements Notification {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ResourcesUpdatedNotification(String uri) {
            this(uri, null);
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourcesUpdatedNotification)) {
                return false;
            }
            ResourcesUpdatedNotification other = (ResourcesUpdatedNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourcesUpdatedNotification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ResourcesUpdatedNotification(uri=" + this.getUri() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ResourcesUpdatedNotification(String uri, Map<String, Object> meta) {
            this.uri = uri;
            this.meta = meta;
        }

        @Generated
        public ResourcesUpdatedNotification() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProgressNotification
    implements Notification {
        @JsonProperty(value="progressToken")
        String progressToken;
        @JsonProperty(value="progress")
        double progress;
        @JsonProperty(value="total")
        Double total;
        @JsonProperty(value="message")
        String message;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ProgressNotification(String progressToken, double progress, Double total, String message) {
            this(progressToken, progress, total, message, null);
        }

        @Generated
        public String getProgressToken() {
            return this.progressToken;
        }

        @Generated
        public double getProgress() {
            return this.progress;
        }

        @Generated
        public Double getTotal() {
            return this.total;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="progressToken")
        @Generated
        public void setProgressToken(String progressToken) {
            this.progressToken = progressToken;
        }

        @JsonProperty(value="progress")
        @Generated
        public void setProgress(double progress) {
            this.progress = progress;
        }

        @JsonProperty(value="total")
        @Generated
        public void setTotal(Double total) {
            this.total = total;
        }

        @JsonProperty(value="message")
        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProgressNotification)) {
                return false;
            }
            ProgressNotification other = (ProgressNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getProgress(), other.getProgress()) != 0) {
                return false;
            }
            Double this$total = this.getTotal();
            Double other$total = other.getTotal();
            if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
                return false;
            }
            String this$progressToken = this.getProgressToken();
            String other$progressToken = other.getProgressToken();
            if (this$progressToken == null ? other$progressToken != null : !this$progressToken.equals(other$progressToken)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProgressNotification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $progress = Double.doubleToLongBits(this.getProgress());
            result = result * 59 + (int)($progress >>> 32 ^ $progress);
            Double $total = this.getTotal();
            result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
            String $progressToken = this.getProgressToken();
            result = result * 59 + ($progressToken == null ? 43 : $progressToken.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ProgressNotification(progressToken=" + this.getProgressToken() + ", progress=" + this.getProgress() + ", total=" + this.getTotal() + ", message=" + this.getMessage() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ProgressNotification(String progressToken, double progress, Double total, String message, Map<String, Object> meta) {
            this.progressToken = progressToken;
            this.progress = progress;
            this.total = total;
            this.message = message;
            this.meta = meta;
        }

        @Generated
        public ProgressNotification() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedResult
    implements Result {
        @JsonProperty(value="nextCursor")
        String nextCursor;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public PaginatedResult(String nextCursor) {
            this(nextCursor, null);
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginatedResult)) {
                return false;
            }
            PaginatedResult other = (PaginatedResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            if (this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaginatedResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PaginatedResult(nextCursor=" + this.getNextCursor() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public PaginatedResult(String nextCursor, Map<String, Object> meta) {
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        @Generated
        public PaginatedResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PaginatedRequest
    implements Request {
        @JsonProperty(value="cursor")
        String cursor;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public PaginatedRequest(String cursor) {
            this(cursor, null);
        }

        public PaginatedRequest() {
            this(null);
        }

        @Generated
        public String getCursor() {
            return this.cursor;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="cursor")
        @Generated
        public void setCursor(String cursor) {
            this.cursor = cursor;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginatedRequest)) {
                return false;
            }
            PaginatedRequest other = (PaginatedRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$cursor = this.getCursor();
            String other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaginatedRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PaginatedRequest(cursor=" + this.getCursor() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public PaginatedRequest(String cursor, Map<String, Object> meta) {
            this.cursor = cursor;
            this.meta = meta;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ElicitResult
    implements Result {
        @JsonProperty(value="action")
        Action action;
        @JsonProperty(value="content")
        Map<String, Object> content;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ElicitResult(Action action, Map<String, Object> content) {
            this(action, content, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Action getAction() {
            return this.action;
        }

        @Generated
        public Map<String, Object> getContent() {
            return this.content;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="action")
        @Generated
        public void setAction(Action action) {
            this.action = action;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(Map<String, Object> content) {
            this.content = content;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElicitResult)) {
                return false;
            }
            ElicitResult other = (ElicitResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            Map<String, Object> this$content = this.getContent();
            Map<String, Object> other$content = other.getContent();
            if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ElicitResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            Map<String, Object> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ElicitResult(action=" + (Object)((Object)this.getAction()) + ", content=" + this.getContent() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ElicitResult(Action action, Map<String, Object> content, Map<String, Object> meta) {
            this.action = action;
            this.content = content;
            this.meta = meta;
        }

        @Generated
        public ElicitResult() {
        }

        public static class Builder {
            private Action action;
            private Map<String, Object> content;
            private Map<String, Object> meta;

            public Builder message(Action action) {
                this.action = action;
                return this;
            }

            public Builder content(Map<String, Object> content) {
                this.content = content;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public ElicitResult build() {
                return new ElicitResult(this.action, this.content, this.meta);
            }
        }

        public static enum Action {
            ACCEPT,
            DECLINE,
            CANCEL;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ElicitRequest
    implements Request {
        @JsonProperty(value="message")
        String message;
        @JsonProperty(value="requestedSchema")
        Map<String, Object> requestedSchema;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ElicitRequest(String message, Map<String, Object> requestedSchema) {
            this(message, requestedSchema, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public Map<String, Object> getRequestedSchema() {
            return this.requestedSchema;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="message")
        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="requestedSchema")
        @Generated
        public void setRequestedSchema(Map<String, Object> requestedSchema) {
            this.requestedSchema = requestedSchema;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElicitRequest)) {
                return false;
            }
            ElicitRequest other = (ElicitRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Map<String, Object> this$requestedSchema = this.getRequestedSchema();
            Map<String, Object> other$requestedSchema = other.getRequestedSchema();
            if (this$requestedSchema == null ? other$requestedSchema != null : !((Object)this$requestedSchema).equals(other$requestedSchema)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ElicitRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Map<String, Object> $requestedSchema = this.getRequestedSchema();
            result = result * 59 + ($requestedSchema == null ? 43 : ((Object)$requestedSchema).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ElicitRequest(message=" + this.getMessage() + ", requestedSchema=" + this.getRequestedSchema() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ElicitRequest(String message, Map<String, Object> requestedSchema, Map<String, Object> meta) {
            this.message = message;
            this.requestedSchema = requestedSchema;
            this.meta = meta;
        }

        @Generated
        public ElicitRequest() {
        }

        public static class Builder {
            private String message;
            private Map<String, Object> requestedSchema;
            private Map<String, Object> meta;

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public Builder requestedSchema(Map<String, Object> requestedSchema) {
                this.requestedSchema = requestedSchema;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(String progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public ElicitRequest build() {
                return new ElicitRequest(this.message, this.requestedSchema, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageResult
    implements Result {
        @JsonProperty(value="role")
        Role role;
        @JsonProperty(value="content")
        Content content;
        @JsonProperty(value="model")
        String model;
        @JsonProperty(value="stopReason")
        StopReason stopReason;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public CreateMessageResult(Role role, Content content, String model, StopReason stopReason) {
            this(role, content, model, stopReason, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Role getRole() {
            return this.role;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public StopReason getStopReason() {
            return this.stopReason;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="role")
        @Generated
        public void setRole(Role role) {
            this.role = role;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @JsonProperty(value="model")
        @Generated
        public void setModel(String model) {
            this.model = model;
        }

        @JsonProperty(value="stopReason")
        @Generated
        public void setStopReason(StopReason stopReason) {
            this.stopReason = stopReason;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateMessageResult)) {
                return false;
            }
            CreateMessageResult other = (CreateMessageResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            StopReason this$stopReason = this.getStopReason();
            StopReason other$stopReason = other.getStopReason();
            if (this$stopReason == null ? other$stopReason != null : !((Object)((Object)this$stopReason)).equals((Object)other$stopReason)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateMessageResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            StopReason $stopReason = this.getStopReason();
            result = result * 59 + ($stopReason == null ? 43 : ((Object)((Object)$stopReason)).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CreateMessageResult(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ", model=" + this.getModel() + ", stopReason=" + (Object)((Object)this.getStopReason()) + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public CreateMessageResult(Role role, Content content, String model, StopReason stopReason, Map<String, Object> meta) {
            this.role = role;
            this.content = content;
            this.model = model;
            this.stopReason = stopReason;
            this.meta = meta;
        }

        @Generated
        public CreateMessageResult() {
        }

        public static class Builder {
            private Role role = Role.ASSISTANT;
            private Content content;
            private String model;
            private StopReason stopReason = StopReason.END_TURN;
            private Map<String, Object> meta;

            public Builder role(Role role) {
                this.role = role;
                return this;
            }

            public Builder content(Content content) {
                this.content = content;
                return this;
            }

            public Builder model(String model) {
                this.model = model;
                return this;
            }

            public Builder stopReason(StopReason stopReason) {
                this.stopReason = stopReason;
                return this;
            }

            public Builder message(String message) {
                this.content = new TextContent(message);
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public CreateMessageResult build() {
                return new CreateMessageResult(this.role, this.content, this.model, this.stopReason, this.meta);
            }
        }

        public static enum StopReason {
            END_TURN("endTurn"),
            STOP_SEQUENCE("stopSequence"),
            MAX_TOKENS("maxTokens"),
            UNKNOWN("unknown");

            private final String value;

            private StopReason(String value) {
                this.value = value;
            }

            @JsonCreator
            private static StopReason of(String value) {
                return Arrays.stream(StopReason.values()).filter(stopReason -> stopReason.value.equals(value)).findFirst().orElse(UNKNOWN);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CreateMessageRequest
    implements Request {
        @JsonProperty(value="messages")
        List<SamplingMessage> messages;
        @JsonProperty(value="modelPreferences")
        ModelPreferences modelPreferences;
        @JsonProperty(value="systemPrompt")
        String systemPrompt;
        @JsonProperty(value="includeContext")
        ContextInclusionStrategy includeContext;
        @JsonProperty(value="temperature")
        Double temperature;
        @JsonProperty(value="maxTokens")
        int maxTokens;
        @JsonProperty(value="stopSequences")
        List<String> stopSequences;
        @JsonProperty(value="metadata")
        Map<String, Object> metadata;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public CreateMessageRequest(List<SamplingMessage> messages, ModelPreferences modelPreferences, String systemPrompt, ContextInclusionStrategy includeContext, Double temperature, int maxTokens, List<String> stopSequences, Map<String, Object> metadata) {
            this(messages, modelPreferences, systemPrompt, includeContext, temperature, maxTokens, stopSequences, metadata, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<SamplingMessage> getMessages() {
            return this.messages;
        }

        @Generated
        public ModelPreferences getModelPreferences() {
            return this.modelPreferences;
        }

        @Generated
        public String getSystemPrompt() {
            return this.systemPrompt;
        }

        @Generated
        public ContextInclusionStrategy getIncludeContext() {
            return this.includeContext;
        }

        @Generated
        public Double getTemperature() {
            return this.temperature;
        }

        @Generated
        public int getMaxTokens() {
            return this.maxTokens;
        }

        @Generated
        public List<String> getStopSequences() {
            return this.stopSequences;
        }

        @Generated
        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="messages")
        @Generated
        public void setMessages(List<SamplingMessage> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="modelPreferences")
        @Generated
        public void setModelPreferences(ModelPreferences modelPreferences) {
            this.modelPreferences = modelPreferences;
        }

        @JsonProperty(value="systemPrompt")
        @Generated
        public void setSystemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
        }

        @JsonProperty(value="includeContext")
        @Generated
        public void setIncludeContext(ContextInclusionStrategy includeContext) {
            this.includeContext = includeContext;
        }

        @JsonProperty(value="temperature")
        @Generated
        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        @JsonProperty(value="maxTokens")
        @Generated
        public void setMaxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
        }

        @JsonProperty(value="stopSequences")
        @Generated
        public void setStopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
        }

        @JsonProperty(value="metadata")
        @Generated
        public void setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateMessageRequest)) {
                return false;
            }
            CreateMessageRequest other = (CreateMessageRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxTokens() != other.getMaxTokens()) {
                return false;
            }
            Double this$temperature = this.getTemperature();
            Double other$temperature = other.getTemperature();
            if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
                return false;
            }
            List<SamplingMessage> this$messages = this.getMessages();
            List<SamplingMessage> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            ModelPreferences this$modelPreferences = this.getModelPreferences();
            ModelPreferences other$modelPreferences = other.getModelPreferences();
            if (this$modelPreferences == null ? other$modelPreferences != null : !((Object)this$modelPreferences).equals(other$modelPreferences)) {
                return false;
            }
            String this$systemPrompt = this.getSystemPrompt();
            String other$systemPrompt = other.getSystemPrompt();
            if (this$systemPrompt == null ? other$systemPrompt != null : !this$systemPrompt.equals(other$systemPrompt)) {
                return false;
            }
            ContextInclusionStrategy this$includeContext = this.getIncludeContext();
            ContextInclusionStrategy other$includeContext = other.getIncludeContext();
            if (this$includeContext == null ? other$includeContext != null : !((Object)((Object)this$includeContext)).equals((Object)other$includeContext)) {
                return false;
            }
            List<String> this$stopSequences = this.getStopSequences();
            List<String> other$stopSequences = other.getStopSequences();
            if (this$stopSequences == null ? other$stopSequences != null : !((Object)this$stopSequences).equals(other$stopSequences)) {
                return false;
            }
            Map<String, Object> this$metadata = this.getMetadata();
            Map<String, Object> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateMessageRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxTokens();
            Double $temperature = this.getTemperature();
            result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
            List<SamplingMessage> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            ModelPreferences $modelPreferences = this.getModelPreferences();
            result = result * 59 + ($modelPreferences == null ? 43 : ((Object)$modelPreferences).hashCode());
            String $systemPrompt = this.getSystemPrompt();
            result = result * 59 + ($systemPrompt == null ? 43 : $systemPrompt.hashCode());
            ContextInclusionStrategy $includeContext = this.getIncludeContext();
            result = result * 59 + ($includeContext == null ? 43 : ((Object)((Object)$includeContext)).hashCode());
            List<String> $stopSequences = this.getStopSequences();
            result = result * 59 + ($stopSequences == null ? 43 : ((Object)$stopSequences).hashCode());
            Map<String, Object> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CreateMessageRequest(messages=" + this.getMessages() + ", modelPreferences=" + this.getModelPreferences() + ", systemPrompt=" + this.getSystemPrompt() + ", includeContext=" + (Object)((Object)this.getIncludeContext()) + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", stopSequences=" + this.getStopSequences() + ", metadata=" + this.getMetadata() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public CreateMessageRequest(List<SamplingMessage> messages, ModelPreferences modelPreferences, String systemPrompt, ContextInclusionStrategy includeContext, Double temperature, int maxTokens, List<String> stopSequences, Map<String, Object> metadata, Map<String, Object> meta) {
            this.messages = messages;
            this.modelPreferences = modelPreferences;
            this.systemPrompt = systemPrompt;
            this.includeContext = includeContext;
            this.temperature = temperature;
            this.maxTokens = maxTokens;
            this.stopSequences = stopSequences;
            this.metadata = metadata;
            this.meta = meta;
        }

        @Generated
        public CreateMessageRequest() {
        }

        public static class Builder {
            private List<SamplingMessage> messages;
            private ModelPreferences modelPreferences;
            private String systemPrompt;
            private ContextInclusionStrategy includeContext;
            private Double temperature;
            private int maxTokens;
            private List<String> stopSequences;
            private Map<String, Object> metadata;
            private Map<String, Object> meta;

            public Builder messages(List<SamplingMessage> messages) {
                this.messages = messages;
                return this;
            }

            public Builder modelPreferences(ModelPreferences modelPreferences) {
                this.modelPreferences = modelPreferences;
                return this;
            }

            public Builder systemPrompt(String systemPrompt) {
                this.systemPrompt = systemPrompt;
                return this;
            }

            public Builder includeContext(ContextInclusionStrategy includeContext) {
                this.includeContext = includeContext;
                return this;
            }

            public Builder temperature(Double temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder maxTokens(int maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder stopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder metadata(Map<String, Object> metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(String progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public CreateMessageRequest build() {
                return new CreateMessageRequest(this.messages, this.modelPreferences, this.systemPrompt, this.includeContext, this.temperature, this.maxTokens, this.stopSequences, this.metadata, this.meta);
            }
        }

        public static enum ContextInclusionStrategy {
            NONE,
            THIS_SERVER,
            ALL_SERVERS;

        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SamplingMessage {
        @JsonProperty(value="role")
        Role role;
        @JsonProperty(value="content")
        Content content;

        @Generated
        public Role getRole() {
            return this.role;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }

        @JsonProperty(value="role")
        @Generated
        public void setRole(Role role) {
            this.role = role;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SamplingMessage)) {
                return false;
            }
            SamplingMessage other = (SamplingMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SamplingMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.SamplingMessage(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ")";
        }

        @Generated
        public SamplingMessage(Role role, Content content) {
            this.role = role;
            this.content = content;
        }

        @Generated
        public SamplingMessage() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelHint {
        @JsonProperty(value="name")
        String name;

        public static ModelHint of(String name) {
            return new ModelHint(name);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelHint)) {
                return false;
            }
            ModelHint other = (ModelHint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModelHint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ModelHint(name=" + this.getName() + ")";
        }

        @Generated
        public ModelHint(String name) {
            this.name = name;
        }

        @Generated
        public ModelHint() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ModelPreferences {
        @JsonProperty(value="hints")
        List<ModelHint> hints;
        @JsonProperty(value="costPriority")
        Double costPriority;
        @JsonProperty(value="speedPriority")
        Double speedPriority;
        @JsonProperty(value="intelligencePriority")
        Double intelligencePriority;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<ModelHint> getHints() {
            return this.hints;
        }

        @Generated
        public Double getCostPriority() {
            return this.costPriority;
        }

        @Generated
        public Double getSpeedPriority() {
            return this.speedPriority;
        }

        @Generated
        public Double getIntelligencePriority() {
            return this.intelligencePriority;
        }

        @JsonProperty(value="hints")
        @Generated
        public void setHints(List<ModelHint> hints) {
            this.hints = hints;
        }

        @JsonProperty(value="costPriority")
        @Generated
        public void setCostPriority(Double costPriority) {
            this.costPriority = costPriority;
        }

        @JsonProperty(value="speedPriority")
        @Generated
        public void setSpeedPriority(Double speedPriority) {
            this.speedPriority = speedPriority;
        }

        @JsonProperty(value="intelligencePriority")
        @Generated
        public void setIntelligencePriority(Double intelligencePriority) {
            this.intelligencePriority = intelligencePriority;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelPreferences)) {
                return false;
            }
            ModelPreferences other = (ModelPreferences)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$costPriority = this.getCostPriority();
            Double other$costPriority = other.getCostPriority();
            if (this$costPriority == null ? other$costPriority != null : !((Object)this$costPriority).equals(other$costPriority)) {
                return false;
            }
            Double this$speedPriority = this.getSpeedPriority();
            Double other$speedPriority = other.getSpeedPriority();
            if (this$speedPriority == null ? other$speedPriority != null : !((Object)this$speedPriority).equals(other$speedPriority)) {
                return false;
            }
            Double this$intelligencePriority = this.getIntelligencePriority();
            Double other$intelligencePriority = other.getIntelligencePriority();
            if (this$intelligencePriority == null ? other$intelligencePriority != null : !((Object)this$intelligencePriority).equals(other$intelligencePriority)) {
                return false;
            }
            List<ModelHint> this$hints = this.getHints();
            List<ModelHint> other$hints = other.getHints();
            return !(this$hints == null ? other$hints != null : !((Object)this$hints).equals(other$hints));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModelPreferences;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $costPriority = this.getCostPriority();
            result = result * 59 + ($costPriority == null ? 43 : ((Object)$costPriority).hashCode());
            Double $speedPriority = this.getSpeedPriority();
            result = result * 59 + ($speedPriority == null ? 43 : ((Object)$speedPriority).hashCode());
            Double $intelligencePriority = this.getIntelligencePriority();
            result = result * 59 + ($intelligencePriority == null ? 43 : ((Object)$intelligencePriority).hashCode());
            List<ModelHint> $hints = this.getHints();
            result = result * 59 + ($hints == null ? 43 : ((Object)$hints).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ModelPreferences(hints=" + this.getHints() + ", costPriority=" + this.getCostPriority() + ", speedPriority=" + this.getSpeedPriority() + ", intelligencePriority=" + this.getIntelligencePriority() + ")";
        }

        @Generated
        public ModelPreferences(List<ModelHint> hints, Double costPriority, Double speedPriority, Double intelligencePriority) {
            this.hints = hints;
            this.costPriority = costPriority;
            this.speedPriority = speedPriority;
            this.intelligencePriority = intelligencePriority;
        }

        @Generated
        public ModelPreferences() {
        }

        public static class Builder {
            private List<ModelHint> hints;
            private Double costPriority;
            private Double speedPriority;
            private Double intelligencePriority;

            public Builder hints(List<ModelHint> hints) {
                this.hints = hints;
                return this;
            }

            public Builder addHint(String name) {
                if (this.hints == null) {
                    this.hints = new ArrayList<ModelHint>();
                }
                this.hints.add(new ModelHint(name));
                return this;
            }

            public Builder costPriority(Double costPriority) {
                this.costPriority = costPriority;
                return this;
            }

            public Builder speedPriority(Double speedPriority) {
                this.speedPriority = speedPriority;
                return this;
            }

            public Builder intelligencePriority(Double intelligencePriority) {
                this.intelligencePriority = intelligencePriority;
                return this;
            }

            public ModelPreferences build() {
                return new ModelPreferences(this.hints, this.costPriority, this.speedPriority, this.intelligencePriority);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CallToolResult
    implements Result {
        @JsonProperty(value="content")
        List<Content> content;
        @JsonProperty(value="isError")
        Boolean isError;
        @JsonProperty(value="structuredContent")
        Map<String, Object> structuredContent;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public CallToolResult(List<Content> content, Boolean isError) {
            this(content, isError, null, null);
        }

        public CallToolResult(List<Content> content, Boolean isError, Map<String, Object> structuredContent) {
            this(content, isError, structuredContent, null);
        }

        public CallToolResult(String content, Boolean isError) {
            this(Utils.asList(new TextContent(content)), isError, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<Content> getContent() {
            return this.content;
        }

        @Generated
        public Boolean getIsError() {
            return this.isError;
        }

        @Generated
        public Map<String, Object> getStructuredContent() {
            return this.structuredContent;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(List<Content> content) {
            this.content = content;
        }

        @JsonProperty(value="isError")
        @Generated
        public void setIsError(Boolean isError) {
            this.isError = isError;
        }

        @JsonProperty(value="structuredContent")
        @Generated
        public void setStructuredContent(Map<String, Object> structuredContent) {
            this.structuredContent = structuredContent;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallToolResult)) {
                return false;
            }
            CallToolResult other = (CallToolResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isError = this.getIsError();
            Boolean other$isError = other.getIsError();
            if (this$isError == null ? other$isError != null : !((Object)this$isError).equals(other$isError)) {
                return false;
            }
            List<Content> this$content = this.getContent();
            List<Content> other$content = other.getContent();
            if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
                return false;
            }
            Map<String, Object> this$structuredContent = this.getStructuredContent();
            Map<String, Object> other$structuredContent = other.getStructuredContent();
            if (this$structuredContent == null ? other$structuredContent != null : !((Object)this$structuredContent).equals(other$structuredContent)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CallToolResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isError = this.getIsError();
            result = result * 59 + ($isError == null ? 43 : ((Object)$isError).hashCode());
            List<Content> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            Map<String, Object> $structuredContent = this.getStructuredContent();
            result = result * 59 + ($structuredContent == null ? 43 : ((Object)$structuredContent).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CallToolResult(content=" + this.getContent() + ", isError=" + this.getIsError() + ", structuredContent=" + this.getStructuredContent() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public CallToolResult(List<Content> content, Boolean isError, Map<String, Object> structuredContent, Map<String, Object> meta) {
            this.content = content;
            this.isError = isError;
            this.structuredContent = structuredContent;
            this.meta = meta;
        }

        @Generated
        public CallToolResult() {
        }

        public static class Builder {
            private List<Content> content = new ArrayList<Content>();
            private Boolean isError = false;
            private Map<String, Object> structuredContent;
            private Map<String, Object> meta;

            public Builder content(List<Content> content) {
                Assert.notNull(content, "content must not be null");
                this.content = content;
                return this;
            }

            public Builder structuredContent(Map<String, Object> structuredContent) {
                Assert.notNull(structuredContent, "structuredContent must not be null");
                this.structuredContent = structuredContent;
                return this;
            }

            public Builder structuredContent(String structuredContent) {
                Assert.hasText(structuredContent, "structuredContent must not be empty");
                try {
                    this.structuredContent = (Map)OBJECT_MAPPER.readValue(structuredContent, MAP_TYPE_REF);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid structured content: " + structuredContent, e);
                }
                return this;
            }

            public Builder textContent(List<String> textContent) {
                Assert.notNull(textContent, "textContent must not be null");
                textContent.stream().map(TextContent::new).forEach(this.content::add);
                return this;
            }

            public Builder addContent(Content contentItem) {
                Assert.notNull(contentItem, "contentItem must not be null");
                if (this.content == null) {
                    this.content = new ArrayList<Content>();
                }
                this.content.add(contentItem);
                return this;
            }

            public Builder addTextContent(String text) {
                Assert.notNull(text, "text must not be null");
                return this.addContent(new TextContent(text));
            }

            public Builder isError(Boolean isError) {
                Assert.notNull(isError, "isError must not be null");
                this.isError = isError;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public CallToolResult build() {
                return new CallToolResult(this.content, this.isError, this.structuredContent, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CallToolRequest
    implements Request {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="arguments")
        Map<String, Object> arguments;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public CallToolRequest(String name, String jsonArguments) {
            this(name, CallToolRequest.parseJsonArguments(jsonArguments), null);
        }

        public CallToolRequest(String name, Map<String, Object> arguments) {
            this(name, arguments, null);
        }

        private static Map<String, Object> parseJsonArguments(String jsonArguments) {
            try {
                return (Map)OBJECT_MAPPER.readValue(jsonArguments, MAP_TYPE_REF);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid arguments: " + jsonArguments, e);
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="arguments")
        @Generated
        public void setArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallToolRequest)) {
                return false;
            }
            CallToolRequest other = (CallToolRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, Object> this$arguments = this.getArguments();
            Map<String, Object> other$arguments = other.getArguments();
            if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CallToolRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, Object> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.CallToolRequest(name=" + this.getName() + ", arguments=" + this.getArguments() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public CallToolRequest(String name, Map<String, Object> arguments, Map<String, Object> meta) {
            this.name = name;
            this.arguments = arguments;
            this.meta = meta;
        }

        @Generated
        public CallToolRequest() {
        }

        public static class Builder {
            private String name;
            private Map<String, Object> arguments;
            private Map<String, Object> meta;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder arguments(Map<String, Object> arguments) {
                this.arguments = arguments;
                return this;
            }

            public Builder arguments(String jsonArguments) {
                this.arguments = CallToolRequest.parseJsonArguments(jsonArguments);
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Builder progressToken(String progressToken) {
                if (this.meta == null) {
                    this.meta = new HashMap<String, Object>();
                }
                this.meta.put("progressToken", progressToken);
                return this;
            }

            public CallToolRequest build() {
                Assert.hasText(this.name, "name must not be empty");
                return new CallToolRequest(this.name, this.arguments, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Tool {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="inputSchema")
        JsonSchema inputSchema;
        @JsonProperty(value="outputSchema")
        Map<String, Object> outputSchema;
        @JsonProperty(value="annotations")
        ToolAnnotations annotations;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        @Deprecated
        public Tool(String name, String description, JsonSchema inputSchema, ToolAnnotations annotations) {
            this(name, null, description, inputSchema, null, annotations, null);
        }

        @Deprecated
        public Tool(String name, String description, String inputSchema) {
            this(name, null, description, McpSchema.parseSchema(inputSchema), null, null, null);
        }

        @Deprecated
        public Tool(String name, String description, String schema, ToolAnnotations annotations) {
            this(name, null, description, McpSchema.parseSchema(schema), null, annotations, null);
        }

        @Deprecated
        public Tool(String name, String description, String inputSchema, String outputSchema, ToolAnnotations annotations) {
            this(name, null, description, McpSchema.parseSchema(inputSchema), McpSchema.schemaToMap(outputSchema), annotations, null);
        }

        @Deprecated
        public Tool(String name, String title, String description, String inputSchema, String outputSchema, ToolAnnotations annotations) {
            this(name, title, description, McpSchema.parseSchema(inputSchema), McpSchema.schemaToMap(outputSchema), annotations, null);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public JsonSchema getInputSchema() {
            return this.inputSchema;
        }

        @Generated
        public Map<String, Object> getOutputSchema() {
            return this.outputSchema;
        }

        @Generated
        public ToolAnnotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="inputSchema")
        @Generated
        public void setInputSchema(JsonSchema inputSchema) {
            this.inputSchema = inputSchema;
        }

        @JsonProperty(value="outputSchema")
        @Generated
        public void setOutputSchema(Map<String, Object> outputSchema) {
            this.outputSchema = outputSchema;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(ToolAnnotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tool)) {
                return false;
            }
            Tool other = (Tool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            JsonSchema this$inputSchema = this.getInputSchema();
            JsonSchema other$inputSchema = other.getInputSchema();
            if (this$inputSchema == null ? other$inputSchema != null : !((Object)this$inputSchema).equals(other$inputSchema)) {
                return false;
            }
            Map<String, Object> this$outputSchema = this.getOutputSchema();
            Map<String, Object> other$outputSchema = other.getOutputSchema();
            if (this$outputSchema == null ? other$outputSchema != null : !((Object)this$outputSchema).equals(other$outputSchema)) {
                return false;
            }
            ToolAnnotations this$annotations = this.getAnnotations();
            ToolAnnotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tool;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            JsonSchema $inputSchema = this.getInputSchema();
            result = result * 59 + ($inputSchema == null ? 43 : ((Object)$inputSchema).hashCode());
            Map<String, Object> $outputSchema = this.getOutputSchema();
            result = result * 59 + ($outputSchema == null ? 43 : ((Object)$outputSchema).hashCode());
            ToolAnnotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Tool(name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", inputSchema=" + this.getInputSchema() + ", outputSchema=" + this.getOutputSchema() + ", annotations=" + this.getAnnotations() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public Tool(String name, String title, String description, JsonSchema inputSchema, Map<String, Object> outputSchema, ToolAnnotations annotations, Map<String, Object> meta) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.inputSchema = inputSchema;
            this.outputSchema = outputSchema;
            this.annotations = annotations;
            this.meta = meta;
        }

        @Generated
        public Tool() {
        }

        public static class Builder {
            private String name;
            private String title;
            private String description;
            private JsonSchema inputSchema;
            private Map<String, Object> outputSchema;
            private ToolAnnotations annotations;
            private Map<String, Object> meta;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder inputSchema(JsonSchema inputSchema) {
                this.inputSchema = inputSchema;
                return this;
            }

            public Builder inputSchema(String inputSchema) {
                this.inputSchema = McpSchema.parseSchema(inputSchema);
                return this;
            }

            public Builder outputSchema(Map<String, Object> outputSchema) {
                this.outputSchema = outputSchema;
                return this;
            }

            public Builder outputSchema(String outputSchema) {
                this.outputSchema = McpSchema.schemaToMap(outputSchema);
                return this;
            }

            public Builder annotations(ToolAnnotations annotations) {
                this.annotations = annotations;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Tool build() {
                Assert.hasText(this.name, "name must not be empty");
                return new Tool(this.name, this.title, this.description, this.inputSchema, this.outputSchema, this.annotations, this.meta);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ToolAnnotations {
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="readOnlyHint")
        Boolean readOnlyHint;
        @JsonProperty(value="destructiveHint")
        Boolean destructiveHint;
        @JsonProperty(value="idempotentHint")
        Boolean idempotentHint;
        @JsonProperty(value="openWorldHint")
        Boolean openWorldHint;
        @JsonProperty(value="returnDirect")
        Boolean returnDirect;

        @Generated
        public ToolAnnotations() {
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public Boolean getReadOnlyHint() {
            return this.readOnlyHint;
        }

        @Generated
        public Boolean getDestructiveHint() {
            return this.destructiveHint;
        }

        @Generated
        public Boolean getIdempotentHint() {
            return this.idempotentHint;
        }

        @Generated
        public Boolean getOpenWorldHint() {
            return this.openWorldHint;
        }

        @Generated
        public Boolean getReturnDirect() {
            return this.returnDirect;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="readOnlyHint")
        @Generated
        public void setReadOnlyHint(Boolean readOnlyHint) {
            this.readOnlyHint = readOnlyHint;
        }

        @JsonProperty(value="destructiveHint")
        @Generated
        public void setDestructiveHint(Boolean destructiveHint) {
            this.destructiveHint = destructiveHint;
        }

        @JsonProperty(value="idempotentHint")
        @Generated
        public void setIdempotentHint(Boolean idempotentHint) {
            this.idempotentHint = idempotentHint;
        }

        @JsonProperty(value="openWorldHint")
        @Generated
        public void setOpenWorldHint(Boolean openWorldHint) {
            this.openWorldHint = openWorldHint;
        }

        @JsonProperty(value="returnDirect")
        @Generated
        public void setReturnDirect(Boolean returnDirect) {
            this.returnDirect = returnDirect;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToolAnnotations)) {
                return false;
            }
            ToolAnnotations other = (ToolAnnotations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$readOnlyHint = this.getReadOnlyHint();
            Boolean other$readOnlyHint = other.getReadOnlyHint();
            if (this$readOnlyHint == null ? other$readOnlyHint != null : !((Object)this$readOnlyHint).equals(other$readOnlyHint)) {
                return false;
            }
            Boolean this$destructiveHint = this.getDestructiveHint();
            Boolean other$destructiveHint = other.getDestructiveHint();
            if (this$destructiveHint == null ? other$destructiveHint != null : !((Object)this$destructiveHint).equals(other$destructiveHint)) {
                return false;
            }
            Boolean this$idempotentHint = this.getIdempotentHint();
            Boolean other$idempotentHint = other.getIdempotentHint();
            if (this$idempotentHint == null ? other$idempotentHint != null : !((Object)this$idempotentHint).equals(other$idempotentHint)) {
                return false;
            }
            Boolean this$openWorldHint = this.getOpenWorldHint();
            Boolean other$openWorldHint = other.getOpenWorldHint();
            if (this$openWorldHint == null ? other$openWorldHint != null : !((Object)this$openWorldHint).equals(other$openWorldHint)) {
                return false;
            }
            Boolean this$returnDirect = this.getReturnDirect();
            Boolean other$returnDirect = other.getReturnDirect();
            if (this$returnDirect == null ? other$returnDirect != null : !((Object)this$returnDirect).equals(other$returnDirect)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ToolAnnotations;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $readOnlyHint = this.getReadOnlyHint();
            result = result * 59 + ($readOnlyHint == null ? 43 : ((Object)$readOnlyHint).hashCode());
            Boolean $destructiveHint = this.getDestructiveHint();
            result = result * 59 + ($destructiveHint == null ? 43 : ((Object)$destructiveHint).hashCode());
            Boolean $idempotentHint = this.getIdempotentHint();
            result = result * 59 + ($idempotentHint == null ? 43 : ((Object)$idempotentHint).hashCode());
            Boolean $openWorldHint = this.getOpenWorldHint();
            result = result * 59 + ($openWorldHint == null ? 43 : ((Object)$openWorldHint).hashCode());
            Boolean $returnDirect = this.getReturnDirect();
            result = result * 59 + ($returnDirect == null ? 43 : ((Object)$returnDirect).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ToolAnnotations(title=" + this.getTitle() + ", readOnlyHint=" + this.getReadOnlyHint() + ", destructiveHint=" + this.getDestructiveHint() + ", idempotentHint=" + this.getIdempotentHint() + ", openWorldHint=" + this.getOpenWorldHint() + ", returnDirect=" + this.getReturnDirect() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonSchema {
        @JsonProperty(value="type")
        String type;
        @JsonProperty(value="properties")
        Map<String, Object> properties;
        @JsonProperty(value="required")
        List<String> required;
        @JsonProperty(value="additionalProperties")
        Boolean additionalProperties;
        @JsonProperty(value="$defs")
        Map<String, Object> defs;
        @JsonProperty(value="definitions")
        Map<String, Object> definitions;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @Generated
        public List<String> getRequired() {
            return this.required;
        }

        @Generated
        public Boolean getAdditionalProperties() {
            return this.additionalProperties;
        }

        @Generated
        public Map<String, Object> getDefs() {
            return this.defs;
        }

        @Generated
        public Map<String, Object> getDefinitions() {
            return this.definitions;
        }

        @JsonProperty(value="type")
        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="properties")
        @Generated
        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="required")
        @Generated
        public void setRequired(List<String> required) {
            this.required = required;
        }

        @JsonProperty(value="additionalProperties")
        @Generated
        public void setAdditionalProperties(Boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="$defs")
        @Generated
        public void setDefs(Map<String, Object> defs) {
            this.defs = defs;
        }

        @JsonProperty(value="definitions")
        @Generated
        public void setDefinitions(Map<String, Object> definitions) {
            this.definitions = definitions;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonSchema)) {
                return false;
            }
            JsonSchema other = (JsonSchema)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$additionalProperties = this.getAdditionalProperties();
            Boolean other$additionalProperties = other.getAdditionalProperties();
            if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Map<String, Object> this$properties = this.getProperties();
            Map<String, Object> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            List<String> this$required = this.getRequired();
            List<String> other$required = other.getRequired();
            if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
                return false;
            }
            Map<String, Object> this$defs = this.getDefs();
            Map<String, Object> other$defs = other.getDefs();
            if (this$defs == null ? other$defs != null : !((Object)this$defs).equals(other$defs)) {
                return false;
            }
            Map<String, Object> this$definitions = this.getDefinitions();
            Map<String, Object> other$definitions = other.getDefinitions();
            return !(this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JsonSchema;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $additionalProperties = this.getAdditionalProperties();
            result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Map<String, Object> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            List<String> $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            Map<String, Object> $defs = this.getDefs();
            result = result * 59 + ($defs == null ? 43 : ((Object)$defs).hashCode());
            Map<String, Object> $definitions = this.getDefinitions();
            result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JsonSchema(type=" + this.getType() + ", properties=" + this.getProperties() + ", required=" + this.getRequired() + ", additionalProperties=" + this.getAdditionalProperties() + ", defs=" + this.getDefs() + ", definitions=" + this.getDefinitions() + ")";
        }

        @Generated
        public JsonSchema(String type, Map<String, Object> properties, List<String> required, Boolean additionalProperties, Map<String, Object> defs, Map<String, Object> definitions) {
            this.type = type;
            this.properties = properties;
            this.required = required;
            this.additionalProperties = additionalProperties;
            this.defs = defs;
            this.definitions = definitions;
        }

        @Generated
        public JsonSchema() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListToolsResult
    implements Result {
        @JsonProperty(value="tools")
        List<Tool> tools;
        @JsonProperty(value="nextCursor")
        String nextCursor;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ListToolsResult(List<Tool> tools, String nextCursor) {
            this(tools, nextCursor, null);
        }

        @Generated
        public List<Tool> getTools() {
            return this.tools;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="tools")
        @Generated
        public void setTools(List<Tool> tools) {
            this.tools = tools;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListToolsResult)) {
                return false;
            }
            ListToolsResult other = (ListToolsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Tool> this$tools = this.getTools();
            List<Tool> other$tools = other.getTools();
            if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            if (this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListToolsResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Tool> $tools = this.getTools();
            result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListToolsResult(tools=" + this.getTools() + ", nextCursor=" + this.getNextCursor() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ListToolsResult(List<Tool> tools, String nextCursor, Map<String, Object> meta) {
            this.tools = tools;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        @Generated
        public ListToolsResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptResult
    implements Result {
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="messages")
        List<PromptMessage> messages;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public GetPromptResult(String description, List<PromptMessage> messages) {
            this(description, messages, null);
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<PromptMessage> getMessages() {
            return this.messages;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="messages")
        @Generated
        public void setMessages(List<PromptMessage> messages) {
            this.messages = messages;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetPromptResult)) {
                return false;
            }
            GetPromptResult other = (GetPromptResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<PromptMessage> this$messages = this.getMessages();
            List<PromptMessage> other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GetPromptResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<PromptMessage> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.GetPromptResult(description=" + this.getDescription() + ", messages=" + this.getMessages() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public GetPromptResult(String description, List<PromptMessage> messages, Map<String, Object> meta) {
            this.description = description;
            this.messages = messages;
            this.meta = meta;
        }

        @Generated
        public GetPromptResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GetPromptRequest
    implements Request {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="arguments")
        Map<String, Object> arguments;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public GetPromptRequest(String name, Map<String, Object> arguments) {
            this(name, arguments, null);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="arguments")
        @Generated
        public void setArguments(Map<String, Object> arguments) {
            this.arguments = arguments;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GetPromptRequest)) {
                return false;
            }
            GetPromptRequest other = (GetPromptRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, Object> this$arguments = this.getArguments();
            Map<String, Object> other$arguments = other.getArguments();
            if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GetPromptRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, Object> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.GetPromptRequest(name=" + this.getName() + ", arguments=" + this.getArguments() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public GetPromptRequest(String name, Map<String, Object> arguments, Map<String, Object> meta) {
            this.name = name;
            this.arguments = arguments;
            this.meta = meta;
        }

        @Generated
        public GetPromptRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListPromptsResult
    implements Result {
        @JsonProperty(value="prompts")
        List<Prompt> prompts;
        @JsonProperty(value="nextCursor")
        String nextCursor;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ListPromptsResult(List<Prompt> prompts, String nextCursor) {
            this(prompts, nextCursor, null);
        }

        @Generated
        public List<Prompt> getPrompts() {
            return this.prompts;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="prompts")
        @Generated
        public void setPrompts(List<Prompt> prompts) {
            this.prompts = prompts;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListPromptsResult)) {
                return false;
            }
            ListPromptsResult other = (ListPromptsResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Prompt> this$prompts = this.getPrompts();
            List<Prompt> other$prompts = other.getPrompts();
            if (this$prompts == null ? other$prompts != null : !((Object)this$prompts).equals(other$prompts)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            if (this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListPromptsResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Prompt> $prompts = this.getPrompts();
            result = result * 59 + ($prompts == null ? 43 : ((Object)$prompts).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListPromptsResult(prompts=" + this.getPrompts() + ", nextCursor=" + this.getNextCursor() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ListPromptsResult(List<Prompt> prompts, String nextCursor, Map<String, Object> meta) {
            this.prompts = prompts;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        @Generated
        public ListPromptsResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptMessage {
        @JsonProperty(value="role")
        Role role;
        @JsonProperty(value="content")
        Content content;

        @Generated
        public Role getRole() {
            return this.role;
        }

        @Generated
        public Content getContent() {
            return this.content;
        }

        @JsonProperty(value="role")
        @Generated
        public void setRole(Role role) {
            this.role = role;
        }

        @JsonProperty(value="content")
        @Generated
        public void setContent(Content content) {
            this.content = content;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PromptMessage)) {
                return false;
            }
            PromptMessage other = (PromptMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Role this$role = this.getRole();
            Role other$role = other.getRole();
            if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
                return false;
            }
            Content this$content = this.getContent();
            Content other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PromptMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Role $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
            Content $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PromptMessage(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ")";
        }

        @Generated
        public PromptMessage(Role role, Content content) {
            this.role = role;
            this.content = content;
        }

        @Generated
        public PromptMessage() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PromptArgument
    implements BaseMetadata {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="required")
        Boolean required;

        public PromptArgument(String name, String description, Boolean required) {
            this(name, null, description, required);
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Boolean getRequired() {
            return this.required;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="required")
        @Generated
        public void setRequired(Boolean required) {
            this.required = required;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PromptArgument)) {
                return false;
            }
            PromptArgument other = (PromptArgument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$required = this.getRequired();
            Boolean other$required = other.getRequired();
            if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PromptArgument;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.PromptArgument(name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", required=" + this.getRequired() + ")";
        }

        @Generated
        public PromptArgument(String name, String title, String description, Boolean required) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.required = required;
        }

        @Generated
        public PromptArgument() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Prompt
    implements BaseMetadata {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="arguments")
        List<PromptArgument> arguments;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public Prompt(String name, String description, List<PromptArgument> arguments) {
            this(name, null, description, arguments != null ? arguments : new ArrayList());
        }

        public Prompt(String name, String title, String description, List<PromptArgument> arguments) {
            this(name, title, description, arguments != null ? arguments : new ArrayList<PromptArgument>(), null);
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<PromptArgument> getArguments() {
            return this.arguments;
        }

        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="arguments")
        @Generated
        public void setArguments(List<PromptArgument> arguments) {
            this.arguments = arguments;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prompt)) {
                return false;
            }
            Prompt other = (Prompt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<PromptArgument> this$arguments = this.getArguments();
            List<PromptArgument> other$arguments = other.getArguments();
            if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Prompt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<PromptArgument> $arguments = this.getArguments();
            result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Prompt(name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", arguments=" + this.getArguments() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public Prompt(String name, String title, String description, List<PromptArgument> arguments, Map<String, Object> meta) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.arguments = arguments;
            this.meta = meta;
        }

        @Generated
        public Prompt() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class BlobResourceContents
    implements ResourceContents {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="blob")
        String blob;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public BlobResourceContents(String uri, String mimeType, String blob) {
            this(uri, mimeType, blob, null);
        }

        @Override
        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Generated
        public String getBlob() {
            return this.blob;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="blob")
        @Generated
        public void setBlob(String blob) {
            this.blob = blob;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlobResourceContents)) {
                return false;
            }
            BlobResourceContents other = (BlobResourceContents)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            String this$blob = this.getBlob();
            String other$blob = other.getBlob();
            if (this$blob == null ? other$blob != null : !this$blob.equals(other$blob)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BlobResourceContents;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            String $blob = this.getBlob();
            result = result * 59 + ($blob == null ? 43 : $blob.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.BlobResourceContents(uri=" + this.getUri() + ", mimeType=" + this.getMimeType() + ", blob=" + this.getBlob() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public BlobResourceContents(String uri, String mimeType, String blob, Map<String, Object> meta) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.blob = blob;
            this.meta = meta;
        }

        @Generated
        public BlobResourceContents() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TextResourceContents
    implements ResourceContents {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="text")
        String text;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public TextResourceContents(String uri, String mimeType, String text) {
            this(uri, mimeType, text, null);
        }

        @Override
        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="text")
        @Generated
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextResourceContents)) {
                return false;
            }
            TextResourceContents other = (TextResourceContents)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TextResourceContents;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.TextResourceContents(uri=" + this.getUri() + ", mimeType=" + this.getMimeType() + ", text=" + this.getText() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public TextResourceContents(String uri, String mimeType, String text, Map<String, Object> meta) {
            this.uri = uri;
            this.mimeType = mimeType;
            this.text = text;
            this.meta = meta;
        }

        @Generated
        public TextResourceContents() {
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION, include=JsonTypeInfo.As.PROPERTY)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=TextResourceContents.class, name="text"), @JsonSubTypes.Type(value=BlobResourceContents.class, name="blob")})
    public static interface ResourceContents {
        public String getUri();

        public String getMimeType();

        public Map<String, Object> getMeta();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class UnsubscribeRequest
    implements Request {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public UnsubscribeRequest(String uri) {
            this(uri, null);
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnsubscribeRequest)) {
                return false;
            }
            UnsubscribeRequest other = (UnsubscribeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UnsubscribeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.UnsubscribeRequest(uri=" + this.getUri() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public UnsubscribeRequest(String uri, Map<String, Object> meta) {
            this.uri = uri;
            this.meta = meta;
        }

        @Generated
        public UnsubscribeRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SubscribeRequest
    implements Request {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public SubscribeRequest(String uri) {
            this(uri, null);
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscribeRequest)) {
                return false;
            }
            SubscribeRequest other = (SubscribeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubscribeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.SubscribeRequest(uri=" + this.getUri() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public SubscribeRequest(String uri, Map<String, Object> meta) {
            this.uri = uri;
            this.meta = meta;
        }

        @Generated
        public SubscribeRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceResult
    implements Result {
        @JsonProperty(value="contents")
        List<ResourceContents> contents;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ReadResourceResult(List<ResourceContents> contents) {
            this(contents, null);
        }

        @Generated
        public List<ResourceContents> getContents() {
            return this.contents;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="contents")
        @Generated
        public void setContents(List<ResourceContents> contents) {
            this.contents = contents;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadResourceResult)) {
                return false;
            }
            ReadResourceResult other = (ReadResourceResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ResourceContents> this$contents = this.getContents();
            List<ResourceContents> other$contents = other.getContents();
            if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReadResourceResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ResourceContents> $contents = this.getContents();
            result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ReadResourceResult(contents=" + this.getContents() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ReadResourceResult(List<ResourceContents> contents, Map<String, Object> meta) {
            this.contents = contents;
            this.meta = meta;
        }

        @Generated
        public ReadResourceResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ReadResourceRequest
    implements Request {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ReadResourceRequest(String uri) {
            this(uri, null);
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReadResourceRequest)) {
                return false;
            }
            ReadResourceRequest other = (ReadResourceRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReadResourceRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ReadResourceRequest(uri=" + this.getUri() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ReadResourceRequest(String uri, Map<String, Object> meta) {
            this.uri = uri;
            this.meta = meta;
        }

        @Generated
        public ReadResourceRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourceTemplatesResult
    implements Result {
        @JsonProperty(value="resourceTemplates")
        List<ResourceTemplate> resourceTemplates;
        @JsonProperty(value="nextCursor")
        String nextCursor;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ListResourceTemplatesResult(List<ResourceTemplate> resourceTemplates, String nextCursor) {
            this(resourceTemplates, nextCursor, null);
        }

        @Generated
        public List<ResourceTemplate> getResourceTemplates() {
            return this.resourceTemplates;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="resourceTemplates")
        @Generated
        public void setResourceTemplates(List<ResourceTemplate> resourceTemplates) {
            this.resourceTemplates = resourceTemplates;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListResourceTemplatesResult)) {
                return false;
            }
            ListResourceTemplatesResult other = (ListResourceTemplatesResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ResourceTemplate> this$resourceTemplates = this.getResourceTemplates();
            List<ResourceTemplate> other$resourceTemplates = other.getResourceTemplates();
            if (this$resourceTemplates == null ? other$resourceTemplates != null : !((Object)this$resourceTemplates).equals(other$resourceTemplates)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            if (this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListResourceTemplatesResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ResourceTemplate> $resourceTemplates = this.getResourceTemplates();
            result = result * 59 + ($resourceTemplates == null ? 43 : ((Object)$resourceTemplates).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListResourceTemplatesResult(resourceTemplates=" + this.getResourceTemplates() + ", nextCursor=" + this.getNextCursor() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ListResourceTemplatesResult(List<ResourceTemplate> resourceTemplates, String nextCursor, Map<String, Object> meta) {
            this.resourceTemplates = resourceTemplates;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        @Generated
        public ListResourceTemplatesResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ListResourcesResult
    implements Result {
        @JsonProperty(value="resources")
        List<Resource> resources;
        @JsonProperty(value="nextCursor")
        String nextCursor;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ListResourcesResult(List<Resource> resources, String nextCursor) {
            this(resources, nextCursor, null);
        }

        @Generated
        public List<Resource> getResources() {
            return this.resources;
        }

        @Generated
        public String getNextCursor() {
            return this.nextCursor;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="resources")
        @Generated
        public void setResources(List<Resource> resources) {
            this.resources = resources;
        }

        @JsonProperty(value="nextCursor")
        @Generated
        public void setNextCursor(String nextCursor) {
            this.nextCursor = nextCursor;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListResourcesResult)) {
                return false;
            }
            ListResourcesResult other = (ListResourcesResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Resource> this$resources = this.getResources();
            List<Resource> other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            String this$nextCursor = this.getNextCursor();
            String other$nextCursor = other.getNextCursor();
            if (this$nextCursor == null ? other$nextCursor != null : !this$nextCursor.equals(other$nextCursor)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ListResourcesResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Resource> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            String $nextCursor = this.getNextCursor();
            result = result * 59 + ($nextCursor == null ? 43 : $nextCursor.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ListResourcesResult(resources=" + this.getResources() + ", nextCursor=" + this.getNextCursor() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ListResourcesResult(List<Resource> resources, String nextCursor, Map<String, Object> meta) {
            this.resources = resources;
            this.nextCursor = nextCursor;
            this.meta = meta;
        }

        @Generated
        public ListResourcesResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ResourceTemplate
    implements Annotated,
    BaseMetadata {
        @JsonProperty(value="uriTemplate")
        String uriTemplate;
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="annotations")
        Annotations annotations;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public ResourceTemplate(String uriTemplate, String name, String title, String description, String mimeType, Annotations annotations) {
            this(uriTemplate, name, title, description, mimeType, annotations, null);
        }

        public ResourceTemplate(String uriTemplate, String name, String description, String mimeType, Annotations annotations) {
            this(uriTemplate, name, null, description, mimeType, annotations);
        }

        @Generated
        public String getUriTemplate() {
            return this.uriTemplate;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uriTemplate")
        @Generated
        public void setUriTemplate(String uriTemplate) {
            this.uriTemplate = uriTemplate;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResourceTemplate)) {
                return false;
            }
            ResourceTemplate other = (ResourceTemplate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$uriTemplate = this.getUriTemplate();
            String other$uriTemplate = other.getUriTemplate();
            if (this$uriTemplate == null ? other$uriTemplate != null : !this$uriTemplate.equals(other$uriTemplate)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResourceTemplate;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $uriTemplate = this.getUriTemplate();
            result = result * 59 + ($uriTemplate == null ? 43 : $uriTemplate.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ResourceTemplate(uriTemplate=" + this.getUriTemplate() + ", name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", mimeType=" + this.getMimeType() + ", annotations=" + this.getAnnotations() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public ResourceTemplate(String uriTemplate, String name, String title, String description, String mimeType, Annotations annotations, Map<String, Object> meta) {
            this.uriTemplate = uriTemplate;
            this.name = name;
            this.title = title;
            this.description = description;
            this.mimeType = mimeType;
            this.annotations = annotations;
            this.meta = meta;
        }

        @Generated
        public ResourceTemplate() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Resource
    implements Annotated,
    ResourceContent {
        @JsonProperty(value="uri")
        String uri;
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="description")
        String description;
        @JsonProperty(value="mimeType")
        String mimeType;
        @JsonProperty(value="size")
        Long size;
        @JsonProperty(value="annotations")
        Annotations annotations;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public String getUri() {
            return this.uri;
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Override
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Override
        @Generated
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        @Generated
        public Long getSize() {
            return this.size;
        }

        @Override
        @Generated
        public Annotations getAnnotations() {
            return this.annotations;
        }

        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="uri")
        @Generated
        public void setUri(String uri) {
            this.uri = uri;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="mimeType")
        @Generated
        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @JsonProperty(value="size")
        @Generated
        public void setSize(Long size) {
            this.size = size;
        }

        @JsonProperty(value="annotations")
        @Generated
        public void setAnnotations(Annotations annotations) {
            this.annotations = annotations;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$size = this.getSize();
            Long other$size = other.getSize();
            if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$mimeType = this.getMimeType();
            String other$mimeType = other.getMimeType();
            if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
                return false;
            }
            Annotations this$annotations = this.getAnnotations();
            Annotations other$annotations = other.getAnnotations();
            if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $mimeType = this.getMimeType();
            result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
            Annotations $annotations = this.getAnnotations();
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Resource(uri=" + this.getUri() + ", name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", mimeType=" + this.getMimeType() + ", size=" + this.getSize() + ", annotations=" + this.getAnnotations() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public Resource(String uri, String name, String title, String description, String mimeType, Long size, Annotations annotations, Map<String, Object> meta) {
            this.uri = uri;
            this.name = name;
            this.title = title;
            this.description = description;
            this.mimeType = mimeType;
            this.size = size;
            this.annotations = annotations;
            this.meta = meta;
        }

        @Generated
        public Resource() {
        }

        public static class Builder {
            private String uri;
            private String name;
            private String title;
            private String description;
            private String mimeType;
            private Long size;
            private Annotations annotations;
            private Map<String, Object> meta;

            public Builder uri(String uri) {
                this.uri = uri;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder mimeType(String mimeType) {
                this.mimeType = mimeType;
                return this;
            }

            public Builder size(Long size) {
                this.size = size;
                return this;
            }

            public Builder annotations(Annotations annotations) {
                this.annotations = annotations;
                return this;
            }

            public Builder meta(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            public Resource build() {
                Assert.hasText(this.uri, "uri must not be empty");
                Assert.hasText(this.name, "name must not be empty");
                return new Resource(this.uri, this.name, this.title, this.description, this.mimeType, this.size, this.annotations, this.meta);
            }
        }
    }

    public static interface BaseMetadata {
        public String getName();

        public String getTitle();
    }

    public static interface ResourceContent
    extends BaseMetadata {
        public String getUri();

        public String getDescription();

        public String getMimeType();

        public Long getSize();

        public Annotations getAnnotations();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Annotations {
        @JsonProperty(value="audience")
        List<Role> audience;
        @JsonProperty(value="priority")
        Double priority;

        @Generated
        public List<Role> getAudience() {
            return this.audience;
        }

        @Generated
        public Double getPriority() {
            return this.priority;
        }

        @JsonProperty(value="audience")
        @Generated
        public void setAudience(List<Role> audience) {
            this.audience = audience;
        }

        @JsonProperty(value="priority")
        @Generated
        public void setPriority(Double priority) {
            this.priority = priority;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Annotations)) {
                return false;
            }
            Annotations other = (Annotations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$priority = this.getPriority();
            Double other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            List<Role> this$audience = this.getAudience();
            List<Role> other$audience = other.getAudience();
            return !(this$audience == null ? other$audience != null : !((Object)this$audience).equals(other$audience));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Annotations;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            List<Role> $audience = this.getAudience();
            result = result * 59 + ($audience == null ? 43 : ((Object)$audience).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Annotations(audience=" + this.getAudience() + ", priority=" + this.getPriority() + ")";
        }

        @Generated
        public Annotations(List<Role> audience, Double priority) {
            this.audience = audience;
            this.priority = priority;
        }

        @Generated
        public Annotations() {
        }
    }

    public static interface Annotated {
        public Annotations getAnnotations();
    }

    public static enum Role {
        USER,
        ASSISTANT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Implementation
    implements BaseMetadata {
        @JsonProperty(value="name")
        String name;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="version")
        String version;

        public Implementation(String name, String version) {
            this(name, null, version);
        }

        @Override
        @Generated
        public String getName() {
            return this.name;
        }

        @Override
        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @JsonProperty(value="name")
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="title")
        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="version")
        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Implementation)) {
                return false;
            }
            Implementation other = (Implementation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Implementation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.Implementation(name=" + this.getName() + ", title=" + this.getTitle() + ", version=" + this.getVersion() + ")";
        }

        @Generated
        public Implementation(String name, String title, String version) {
            this.name = name;
            this.title = title;
            this.version = version;
        }

        @Generated
        public Implementation() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServerCapabilities {
        @JsonProperty(value="completions")
        CompletionCapabilities completions;
        @JsonProperty(value="experimental")
        Map<String, Object> experimental;
        @JsonProperty(value="logging")
        LoggingCapabilities logging;
        @JsonProperty(value="prompts")
        PromptCapabilities prompts;
        @JsonProperty(value="resources")
        ResourceCapabilities resources;
        @JsonProperty(value="tools")
        ToolCapabilities tools;

        public Builder mutate() {
            Builder builder = new Builder();
            builder.completions = this.completions;
            builder.experimental = this.experimental;
            builder.logging = this.logging;
            builder.prompts = this.prompts;
            builder.resources = this.resources;
            builder.tools = this.tools;
            return builder;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CompletionCapabilities getCompletions() {
            return this.completions;
        }

        @Generated
        public Map<String, Object> getExperimental() {
            return this.experimental;
        }

        @Generated
        public LoggingCapabilities getLogging() {
            return this.logging;
        }

        @Generated
        public PromptCapabilities getPrompts() {
            return this.prompts;
        }

        @Generated
        public ResourceCapabilities getResources() {
            return this.resources;
        }

        @Generated
        public ToolCapabilities getTools() {
            return this.tools;
        }

        @JsonProperty(value="completions")
        @Generated
        public void setCompletions(CompletionCapabilities completions) {
            this.completions = completions;
        }

        @JsonProperty(value="experimental")
        @Generated
        public void setExperimental(Map<String, Object> experimental) {
            this.experimental = experimental;
        }

        @JsonProperty(value="logging")
        @Generated
        public void setLogging(LoggingCapabilities logging) {
            this.logging = logging;
        }

        @JsonProperty(value="prompts")
        @Generated
        public void setPrompts(PromptCapabilities prompts) {
            this.prompts = prompts;
        }

        @JsonProperty(value="resources")
        @Generated
        public void setResources(ResourceCapabilities resources) {
            this.resources = resources;
        }

        @JsonProperty(value="tools")
        @Generated
        public void setTools(ToolCapabilities tools) {
            this.tools = tools;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerCapabilities)) {
                return false;
            }
            ServerCapabilities other = (ServerCapabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CompletionCapabilities this$completions = this.getCompletions();
            CompletionCapabilities other$completions = other.getCompletions();
            if (this$completions == null ? other$completions != null : !this$completions.equals(other$completions)) {
                return false;
            }
            Map<String, Object> this$experimental = this.getExperimental();
            Map<String, Object> other$experimental = other.getExperimental();
            if (this$experimental == null ? other$experimental != null : !((Object)this$experimental).equals(other$experimental)) {
                return false;
            }
            LoggingCapabilities this$logging = this.getLogging();
            LoggingCapabilities other$logging = other.getLogging();
            if (this$logging == null ? other$logging != null : !this$logging.equals(other$logging)) {
                return false;
            }
            PromptCapabilities this$prompts = this.getPrompts();
            PromptCapabilities other$prompts = other.getPrompts();
            if (this$prompts == null ? other$prompts != null : !((Object)this$prompts).equals(other$prompts)) {
                return false;
            }
            ResourceCapabilities this$resources = this.getResources();
            ResourceCapabilities other$resources = other.getResources();
            if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
                return false;
            }
            ToolCapabilities this$tools = this.getTools();
            ToolCapabilities other$tools = other.getTools();
            return !(this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerCapabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CompletionCapabilities $completions = this.getCompletions();
            result = result * 59 + ($completions == null ? 43 : $completions.hashCode());
            Map<String, Object> $experimental = this.getExperimental();
            result = result * 59 + ($experimental == null ? 43 : ((Object)$experimental).hashCode());
            LoggingCapabilities $logging = this.getLogging();
            result = result * 59 + ($logging == null ? 43 : $logging.hashCode());
            PromptCapabilities $prompts = this.getPrompts();
            result = result * 59 + ($prompts == null ? 43 : ((Object)$prompts).hashCode());
            ResourceCapabilities $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            ToolCapabilities $tools = this.getTools();
            result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ServerCapabilities(completions=" + this.getCompletions() + ", experimental=" + this.getExperimental() + ", logging=" + this.getLogging() + ", prompts=" + this.getPrompts() + ", resources=" + this.getResources() + ", tools=" + this.getTools() + ")";
        }

        @Generated
        public ServerCapabilities(CompletionCapabilities completions, Map<String, Object> experimental, LoggingCapabilities logging, PromptCapabilities prompts, ResourceCapabilities resources, ToolCapabilities tools) {
            this.completions = completions;
            this.experimental = experimental;
            this.logging = logging;
            this.prompts = prompts;
            this.resources = resources;
            this.tools = tools;
        }

        @Generated
        public ServerCapabilities() {
        }

        public static class Builder {
            private CompletionCapabilities completions;
            private Map<String, Object> experimental;
            private LoggingCapabilities logging = new LoggingCapabilities();
            private PromptCapabilities prompts;
            private ResourceCapabilities resources;
            private ToolCapabilities tools;

            public Builder completions() {
                this.completions = new CompletionCapabilities();
                return this;
            }

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder logging() {
                this.logging = new LoggingCapabilities();
                return this;
            }

            public Builder prompts(Boolean listChanged) {
                this.prompts = new PromptCapabilities(listChanged);
                return this;
            }

            public Builder resources(Boolean subscribe, Boolean listChanged) {
                this.resources = new ResourceCapabilities(subscribe, listChanged);
                return this;
            }

            public Builder tools(Boolean listChanged) {
                this.tools = new ToolCapabilities(listChanged);
                return this;
            }

            public ServerCapabilities build() {
                return new ServerCapabilities(this.completions, this.experimental, this.logging, this.prompts, this.resources, this.tools);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ToolCapabilities {
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ToolCapabilities)) {
                    return false;
                }
                ToolCapabilities other = (ToolCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ToolCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ServerCapabilities.ToolCapabilities(listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public ToolCapabilities(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public ToolCapabilities() {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ResourceCapabilities {
            @JsonProperty(value="subscribe")
            Boolean subscribe;
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getSubscribe() {
                return this.subscribe;
            }

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="subscribe")
            @Generated
            public void setSubscribe(Boolean subscribe) {
                this.subscribe = subscribe;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResourceCapabilities)) {
                    return false;
                }
                ResourceCapabilities other = (ResourceCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$subscribe = this.getSubscribe();
                Boolean other$subscribe = other.getSubscribe();
                if (this$subscribe == null ? other$subscribe != null : !((Object)this$subscribe).equals(other$subscribe)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ResourceCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $subscribe = this.getSubscribe();
                result = result * 59 + ($subscribe == null ? 43 : ((Object)$subscribe).hashCode());
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ServerCapabilities.ResourceCapabilities(subscribe=" + this.getSubscribe() + ", listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public ResourceCapabilities(Boolean subscribe, Boolean listChanged) {
                this.subscribe = subscribe;
                this.listChanged = listChanged;
            }

            @Generated
            public ResourceCapabilities() {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class PromptCapabilities {
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PromptCapabilities)) {
                    return false;
                }
                PromptCapabilities other = (PromptCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PromptCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ServerCapabilities.PromptCapabilities(listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public PromptCapabilities(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public PromptCapabilities() {
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class LoggingCapabilities {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class CompletionCapabilities {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClientCapabilities {
        @JsonProperty(value="experimental")
        Map<String, Object> experimental;
        @JsonProperty(value="roots")
        RootCapabilities roots;
        @JsonProperty(value="sampling")
        Sampling sampling;
        @JsonProperty(value="elicitation")
        Elicitation elicitation;

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExperimental() {
            return this.experimental;
        }

        @Generated
        public RootCapabilities getRoots() {
            return this.roots;
        }

        @Generated
        public Sampling getSampling() {
            return this.sampling;
        }

        @Generated
        public Elicitation getElicitation() {
            return this.elicitation;
        }

        @JsonProperty(value="experimental")
        @Generated
        public void setExperimental(Map<String, Object> experimental) {
            this.experimental = experimental;
        }

        @JsonProperty(value="roots")
        @Generated
        public void setRoots(RootCapabilities roots) {
            this.roots = roots;
        }

        @JsonProperty(value="sampling")
        @Generated
        public void setSampling(Sampling sampling) {
            this.sampling = sampling;
        }

        @JsonProperty(value="elicitation")
        @Generated
        public void setElicitation(Elicitation elicitation) {
            this.elicitation = elicitation;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientCapabilities)) {
                return false;
            }
            ClientCapabilities other = (ClientCapabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$experimental = this.getExperimental();
            Map<String, Object> other$experimental = other.getExperimental();
            if (this$experimental == null ? other$experimental != null : !((Object)this$experimental).equals(other$experimental)) {
                return false;
            }
            RootCapabilities this$roots = this.getRoots();
            RootCapabilities other$roots = other.getRoots();
            if (this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots)) {
                return false;
            }
            Sampling this$sampling = this.getSampling();
            Sampling other$sampling = other.getSampling();
            if (this$sampling == null ? other$sampling != null : !this$sampling.equals(other$sampling)) {
                return false;
            }
            Elicitation this$elicitation = this.getElicitation();
            Elicitation other$elicitation = other.getElicitation();
            return !(this$elicitation == null ? other$elicitation != null : !this$elicitation.equals(other$elicitation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientCapabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $experimental = this.getExperimental();
            result = result * 59 + ($experimental == null ? 43 : ((Object)$experimental).hashCode());
            RootCapabilities $roots = this.getRoots();
            result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
            Sampling $sampling = this.getSampling();
            result = result * 59 + ($sampling == null ? 43 : $sampling.hashCode());
            Elicitation $elicitation = this.getElicitation();
            result = result * 59 + ($elicitation == null ? 43 : $elicitation.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.ClientCapabilities(experimental=" + this.getExperimental() + ", roots=" + this.getRoots() + ", sampling=" + this.getSampling() + ", elicitation=" + this.getElicitation() + ")";
        }

        @Generated
        public ClientCapabilities(Map<String, Object> experimental, RootCapabilities roots, Sampling sampling, Elicitation elicitation) {
            this.experimental = experimental;
            this.roots = roots;
            this.sampling = sampling;
            this.elicitation = elicitation;
        }

        @Generated
        public ClientCapabilities() {
        }

        public static class Builder {
            private Map<String, Object> experimental;
            private RootCapabilities roots;
            private Sampling sampling;
            private Elicitation elicitation;

            public Builder experimental(Map<String, Object> experimental) {
                this.experimental = experimental;
                return this;
            }

            public Builder roots(Boolean listChanged) {
                this.roots = new RootCapabilities(listChanged);
                return this;
            }

            public Builder sampling() {
                this.sampling = new Sampling();
                return this;
            }

            public Builder elicitation() {
                this.elicitation = new Elicitation();
                return this;
            }

            public ClientCapabilities build() {
                return new ClientCapabilities(this.experimental, this.roots, this.sampling, this.elicitation);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class Elicitation {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class Sampling {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RootCapabilities {
            @JsonProperty(value="listChanged")
            Boolean listChanged;

            @Generated
            public Boolean getListChanged() {
                return this.listChanged;
            }

            @JsonProperty(value="listChanged")
            @Generated
            public void setListChanged(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RootCapabilities)) {
                    return false;
                }
                RootCapabilities other = (RootCapabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$listChanged = this.getListChanged();
                Boolean other$listChanged = other.getListChanged();
                return !(this$listChanged == null ? other$listChanged != null : !((Object)this$listChanged).equals(other$listChanged));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RootCapabilities;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $listChanged = this.getListChanged();
                result = result * 59 + ($listChanged == null ? 43 : ((Object)$listChanged).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.ClientCapabilities.RootCapabilities(listChanged=" + this.getListChanged() + ")";
            }

            @Generated
            public RootCapabilities(Boolean listChanged) {
                this.listChanged = listChanged;
            }

            @Generated
            public RootCapabilities() {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeResult
    implements Result {
        @JsonProperty(value="protocolVersion")
        String protocolVersion;
        @JsonProperty(value="capabilities")
        ServerCapabilities capabilities;
        @JsonProperty(value="serverInfo")
        Implementation serverInfo;
        @JsonProperty(value="instructions")
        String instructions;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public InitializeResult(String protocolVersion, ServerCapabilities capabilities, Implementation serverInfo, String instructions) {
            this(protocolVersion, capabilities, serverInfo, instructions, null);
        }

        @Generated
        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Generated
        public ServerCapabilities getCapabilities() {
            return this.capabilities;
        }

        @Generated
        public Implementation getServerInfo() {
            return this.serverInfo;
        }

        @Generated
        public String getInstructions() {
            return this.instructions;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="protocolVersion")
        @Generated
        public void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @JsonProperty(value="capabilities")
        @Generated
        public void setCapabilities(ServerCapabilities capabilities) {
            this.capabilities = capabilities;
        }

        @JsonProperty(value="serverInfo")
        @Generated
        public void setServerInfo(Implementation serverInfo) {
            this.serverInfo = serverInfo;
        }

        @JsonProperty(value="instructions")
        @Generated
        public void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializeResult)) {
                return false;
            }
            InitializeResult other = (InitializeResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$protocolVersion = this.getProtocolVersion();
            String other$protocolVersion = other.getProtocolVersion();
            if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
                return false;
            }
            ServerCapabilities this$capabilities = this.getCapabilities();
            ServerCapabilities other$capabilities = other.getCapabilities();
            if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
                return false;
            }
            Implementation this$serverInfo = this.getServerInfo();
            Implementation other$serverInfo = other.getServerInfo();
            if (this$serverInfo == null ? other$serverInfo != null : !((Object)this$serverInfo).equals(other$serverInfo)) {
                return false;
            }
            String this$instructions = this.getInstructions();
            String other$instructions = other.getInstructions();
            if (this$instructions == null ? other$instructions != null : !this$instructions.equals(other$instructions)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InitializeResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $protocolVersion = this.getProtocolVersion();
            result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
            ServerCapabilities $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            Implementation $serverInfo = this.getServerInfo();
            result = result * 59 + ($serverInfo == null ? 43 : ((Object)$serverInfo).hashCode());
            String $instructions = this.getInstructions();
            result = result * 59 + ($instructions == null ? 43 : $instructions.hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.InitializeResult(protocolVersion=" + this.getProtocolVersion() + ", capabilities=" + this.getCapabilities() + ", serverInfo=" + this.getServerInfo() + ", instructions=" + this.getInstructions() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public InitializeResult(String protocolVersion, ServerCapabilities capabilities, Implementation serverInfo, String instructions, Map<String, Object> meta) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.serverInfo = serverInfo;
            this.instructions = instructions;
            this.meta = meta;
        }

        @Generated
        public InitializeResult() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class InitializeRequest
    implements Request {
        @JsonProperty(value="protocolVersion")
        String protocolVersion;
        @JsonProperty(value="capabilities")
        ClientCapabilities capabilities;
        @JsonProperty(value="clientInfo")
        Implementation clientInfo;
        @JsonProperty(value="_meta")
        Map<String, Object> meta;

        public InitializeRequest(String protocolVersion, ClientCapabilities capabilities, Implementation clientInfo) {
            this(protocolVersion, capabilities, clientInfo, null);
        }

        @Generated
        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Generated
        public ClientCapabilities getCapabilities() {
            return this.capabilities;
        }

        @Generated
        public Implementation getClientInfo() {
            return this.clientInfo;
        }

        @Override
        @Generated
        public Map<String, Object> getMeta() {
            return this.meta;
        }

        @JsonProperty(value="protocolVersion")
        @Generated
        public void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @JsonProperty(value="capabilities")
        @Generated
        public void setCapabilities(ClientCapabilities capabilities) {
            this.capabilities = capabilities;
        }

        @JsonProperty(value="clientInfo")
        @Generated
        public void setClientInfo(Implementation clientInfo) {
            this.clientInfo = clientInfo;
        }

        @JsonProperty(value="_meta")
        @Generated
        public void setMeta(Map<String, Object> meta) {
            this.meta = meta;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializeRequest)) {
                return false;
            }
            InitializeRequest other = (InitializeRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$protocolVersion = this.getProtocolVersion();
            String other$protocolVersion = other.getProtocolVersion();
            if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
                return false;
            }
            ClientCapabilities this$capabilities = this.getCapabilities();
            ClientCapabilities other$capabilities = other.getCapabilities();
            if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
                return false;
            }
            Implementation this$clientInfo = this.getClientInfo();
            Implementation other$clientInfo = other.getClientInfo();
            if (this$clientInfo == null ? other$clientInfo != null : !((Object)this$clientInfo).equals(other$clientInfo)) {
                return false;
            }
            Map<String, Object> this$meta = this.getMeta();
            Map<String, Object> other$meta = other.getMeta();
            return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InitializeRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $protocolVersion = this.getProtocolVersion();
            result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
            ClientCapabilities $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            Implementation $clientInfo = this.getClientInfo();
            result = result * 59 + ($clientInfo == null ? 43 : ((Object)$clientInfo).hashCode());
            Map<String, Object> $meta = this.getMeta();
            result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.InitializeRequest(protocolVersion=" + this.getProtocolVersion() + ", capabilities=" + this.getCapabilities() + ", clientInfo=" + this.getClientInfo() + ", meta=" + this.getMeta() + ")";
        }

        @Generated
        public InitializeRequest(String protocolVersion, ClientCapabilities capabilities, Implementation clientInfo, Map<String, Object> meta) {
            this.protocolVersion = protocolVersion;
            this.capabilities = capabilities;
            this.clientInfo = clientInfo;
            this.meta = meta;
        }

        @Generated
        public InitializeRequest() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCResponse
    implements JSONRPCMessage {
        @JsonProperty(value="jsonrpc")
        String jsonrpc;
        @JsonProperty(value="id")
        Object id;
        @JsonProperty(value="result")
        Object result;
        @JsonProperty(value="error")
        JSONRPCError error;

        @Override
        @Generated
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        @Generated
        public Object getId() {
            return this.id;
        }

        @Generated
        public Object getResult() {
            return this.result;
        }

        @Generated
        public JSONRPCError getError() {
            return this.error;
        }

        @JsonProperty(value="jsonrpc")
        @Generated
        public void setJsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
        }

        @JsonProperty(value="id")
        @Generated
        public void setId(Object id) {
            this.id = id;
        }

        @JsonProperty(value="result")
        @Generated
        public void setResult(Object result) {
            this.result = result;
        }

        @JsonProperty(value="error")
        @Generated
        public void setError(JSONRPCError error) {
            this.error = error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCResponse)) {
                return false;
            }
            JSONRPCResponse other = (JSONRPCResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonrpc = this.getJsonrpc();
            String other$jsonrpc = other.getJsonrpc();
            if (this$jsonrpc == null ? other$jsonrpc != null : !this$jsonrpc.equals(other$jsonrpc)) {
                return false;
            }
            Object this$id = this.getId();
            Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Object this$result = this.getResult();
            Object other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            JSONRPCError this$error = this.getError();
            JSONRPCError other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonrpc = this.getJsonrpc();
            result = result * 59 + ($jsonrpc == null ? 43 : $jsonrpc.hashCode());
            Object $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Object $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            JSONRPCError $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCResponse(jsonrpc=" + this.getJsonrpc() + ", id=" + this.getId() + ", result=" + this.getResult() + ", error=" + this.getError() + ")";
        }

        @Generated
        public JSONRPCResponse(String jsonrpc, Object id, Object result, JSONRPCError error) {
            this.jsonrpc = jsonrpc;
            this.id = id;
            this.result = result;
            this.error = error;
        }

        @Generated
        public JSONRPCResponse() {
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class JSONRPCError {
            @JsonProperty(value="code")
            int code;
            @JsonProperty(value="message")
            String message;
            @JsonProperty(value="data")
            Object data;

            @Generated
            public int getCode() {
                return this.code;
            }

            @Generated
            public String getMessage() {
                return this.message;
            }

            @Generated
            public Object getData() {
                return this.data;
            }

            @JsonProperty(value="code")
            @Generated
            public void setCode(int code) {
                this.code = code;
            }

            @JsonProperty(value="message")
            @Generated
            public void setMessage(String message) {
                this.message = message;
            }

            @JsonProperty(value="data")
            @Generated
            public void setData(Object data) {
                this.data = data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JSONRPCError)) {
                    return false;
                }
                JSONRPCError other = (JSONRPCError)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getCode() != other.getCode()) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                    return false;
                }
                Object this$data = this.getData();
                Object other$data = other.getData();
                return !(this$data == null ? other$data != null : !this$data.equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof JSONRPCError;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getCode();
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                Object $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "McpSchema.JSONRPCResponse.JSONRPCError(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
            }

            @Generated
            public JSONRPCError(int code, String message, Object data) {
                this.code = code;
                this.message = message;
                this.data = data;
            }

            @Generated
            public JSONRPCError() {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCNotification
    implements JSONRPCMessage {
        @JsonProperty(value="jsonrpc")
        String jsonrpc;
        @JsonProperty(value="method")
        String method;
        @JsonProperty(value="params")
        Object params;

        @Override
        @Generated
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public Object getParams() {
            return this.params;
        }

        @JsonProperty(value="jsonrpc")
        @Generated
        public void setJsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
        }

        @JsonProperty(value="method")
        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @JsonProperty(value="params")
        @Generated
        public void setParams(Object params) {
            this.params = params;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCNotification)) {
                return false;
            }
            JSONRPCNotification other = (JSONRPCNotification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonrpc = this.getJsonrpc();
            String other$jsonrpc = other.getJsonrpc();
            if (this$jsonrpc == null ? other$jsonrpc != null : !this$jsonrpc.equals(other$jsonrpc)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            Object this$params = this.getParams();
            Object other$params = other.getParams();
            return !(this$params == null ? other$params != null : !this$params.equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCNotification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonrpc = this.getJsonrpc();
            result = result * 59 + ($jsonrpc == null ? 43 : $jsonrpc.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            Object $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCNotification(jsonrpc=" + this.getJsonrpc() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ")";
        }

        @Generated
        public JSONRPCNotification(String jsonrpc, String method, Object params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.params = params;
        }

        @Generated
        public JSONRPCNotification() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JSONRPCRequest
    implements JSONRPCMessage {
        @JsonProperty(value="jsonrpc")
        String jsonrpc;
        @JsonProperty(value="method")
        String method;
        @JsonProperty(value="id")
        Object id;
        @JsonProperty(value="params")
        Object params;

        @Override
        @Generated
        public String getJsonrpc() {
            return this.jsonrpc;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public Object getId() {
            return this.id;
        }

        @Generated
        public Object getParams() {
            return this.params;
        }

        @JsonProperty(value="jsonrpc")
        @Generated
        public void setJsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
        }

        @JsonProperty(value="method")
        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @JsonProperty(value="id")
        @Generated
        public void setId(Object id) {
            this.id = id;
        }

        @JsonProperty(value="params")
        @Generated
        public void setParams(Object params) {
            this.params = params;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSONRPCRequest)) {
                return false;
            }
            JSONRPCRequest other = (JSONRPCRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonrpc = this.getJsonrpc();
            String other$jsonrpc = other.getJsonrpc();
            if (this$jsonrpc == null ? other$jsonrpc != null : !this$jsonrpc.equals(other$jsonrpc)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            Object this$id = this.getId();
            Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            Object this$params = this.getParams();
            Object other$params = other.getParams();
            return !(this$params == null ? other$params != null : !this$params.equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSONRPCRequest;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonrpc = this.getJsonrpc();
            result = result * 59 + ($jsonrpc == null ? 43 : $jsonrpc.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            Object $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            Object $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "McpSchema.JSONRPCRequest(jsonrpc=" + this.getJsonrpc() + ", method=" + this.getMethod() + ", id=" + this.getId() + ", params=" + this.getParams() + ")";
        }

        @Generated
        public JSONRPCRequest(String jsonrpc, String method, Object id, Object params) {
            this.jsonrpc = jsonrpc;
            this.method = method;
            this.id = id;
            this.params = params;
        }

        @Generated
        public JSONRPCRequest() {
        }
    }

    public static interface JSONRPCMessage {
        public String getJsonrpc();
    }

    public static interface Notification {
        public Map<String, Object> getMeta();
    }

    public static interface Result {
        public Map<String, Object> getMeta();
    }

    public static interface Request {
        public Map<String, Object> getMeta();

        default public String progressToken() {
            if (this.getMeta() != null && this.getMeta().containsKey("progressToken")) {
                return this.getMeta().get("progressToken").toString();
            }
            return null;
        }
    }

    public static final class ErrorCodes {
        public static final int PARSE_ERROR = -32700;
        public static final int INVALID_REQUEST = -32600;
        public static final int METHOD_NOT_FOUND = -32601;
        public static final int INVALID_PARAMS = -32602;
        public static final int INTERNAL_ERROR = -32603;
    }
}

