/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.mcp.server.manager;

import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.server.McpSyncServer;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiMedia;
import org.noear.solon.ai.chat.ChatRole;
import org.noear.solon.ai.chat.message.ChatMessage;
import org.noear.solon.ai.chat.message.UserMessage;
import org.noear.solon.ai.mcp.exception.McpException;
import org.noear.solon.ai.mcp.server.McpServerContext;
import org.noear.solon.ai.mcp.server.McpServerProperties;
import org.noear.solon.ai.mcp.server.manager.McpServerManager;
import org.noear.solon.ai.mcp.server.prompt.FunctionPrompt;
import org.noear.solon.ai.media.Image;
import org.noear.solon.ai.util.ParamDesc;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextHolder;

public class PromptMcpServerManager
implements McpServerManager<FunctionPrompt> {
    private final Map<String, FunctionPrompt> promptsMap = new ConcurrentHashMap<String, FunctionPrompt>();

    @Override
    public int count() {
        return this.promptsMap.size();
    }

    @Override
    public Collection<FunctionPrompt> all() {
        return this.promptsMap.values();
    }

    @Override
    public boolean contains(String promptName) {
        return this.promptsMap.containsKey(promptName);
    }

    @Override
    public void remove(McpSyncServer server, String promptName) {
        if (server != null) {
            server.removePrompt(promptName);
            this.promptsMap.remove(promptName);
        }
    }

    @Override
    public void add(McpSyncServer server, McpServer.SyncSpecification mcpServerSpec, McpServerProperties mcpServerProps, FunctionPrompt functionPrompt) {
        try {
            this.promptsMap.put(functionPrompt.name(), functionPrompt);
            ArrayList<McpSchema.PromptArgument> promptArguments = new ArrayList<McpSchema.PromptArgument>();
            for (ParamDesc p1 : functionPrompt.params()) {
                promptArguments.add(new McpSchema.PromptArgument(p1.name(), p1.description(), p1.required()));
            }
            McpServerFeatures.SyncPromptSpecification promptSpec = new McpServerFeatures.SyncPromptSpecification(new McpSchema.Prompt(functionPrompt.name(), functionPrompt.title(), functionPrompt.description(), promptArguments), (exchange, request) -> {
                try {
                    ContextHolder.currentSet((Context)new McpServerContext((McpSyncServerExchange)exchange));
                    Collection<ChatMessage> prompts = functionPrompt.handle(request.getArguments());
                    ArrayList<McpSchema.PromptMessage> promptMessages = new ArrayList<McpSchema.PromptMessage>();
                    for (ChatMessage msg : prompts) {
                        if (msg.getRole() == ChatRole.ASSISTANT) {
                            promptMessages.add(new McpSchema.PromptMessage(McpSchema.Role.ASSISTANT, new McpSchema.TextContent(msg.getContent())));
                            continue;
                        }
                        if (msg.getRole() != ChatRole.USER) continue;
                        UserMessage userMessage = (UserMessage)msg;
                        if (Utils.isEmpty((Collection)userMessage.getMedias())) {
                            promptMessages.add(new McpSchema.PromptMessage(McpSchema.Role.USER, new McpSchema.TextContent(msg.getContent())));
                            continue;
                        }
                        for (AiMedia media : userMessage.getMedias()) {
                            if (!(media instanceof Image)) continue;
                            Image mediaImage = (Image)media;
                            if (mediaImage.getB64Json() != null) {
                                promptMessages.add(new McpSchema.PromptMessage(McpSchema.Role.USER, new McpSchema.ImageContent(null, null, mediaImage.getB64Json(), mediaImage.getMimeType())));
                                continue;
                            }
                            promptMessages.add(new McpSchema.PromptMessage(McpSchema.Role.USER, new McpSchema.ImageContent(null, null, mediaImage.getUrl(), mediaImage.getMimeType())));
                        }
                        if (!Utils.isNotEmpty((String)msg.getContent())) continue;
                        promptMessages.add(new McpSchema.PromptMessage(McpSchema.Role.USER, new McpSchema.TextContent(msg.getContent())));
                    }
                    McpSchema.GetPromptResult getPromptResult = new McpSchema.GetPromptResult(functionPrompt.description(), promptMessages);
                    return getPromptResult;
                }
                catch (Throwable ex) {
                    ex = Utils.throwableUnwrap((Throwable)ex);
                    throw new McpException(ex.getMessage(), ex);
                }
                finally {
                    ContextHolder.currentRemove();
                }
            });
            if (server != null) {
                server.addPrompt(promptSpec);
            } else {
                mcpServerSpec.prompts(promptSpec);
            }
        }
        catch (Throwable ex) {
            throw new McpException("Prompt add failed, prompt: " + functionPrompt.name(), ex);
        }
    }
}

