/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.config.yaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.noear.solon.Utils;
import org.yaml.snakeyaml.Yaml;

public class PropertiesYaml
extends Properties {
    static final String SOLON_ENV = "solon.env";
    static final String SOLON_ENV_ON = "solon.env.on";
    static final String YML_PART_SPLIT = "---";
    AtomicReference<String> envRef = new AtomicReference<String>(System.getProperty("solon.env"));

    private Yaml createYaml() {
        return new Yaml();
    }

    public void loadYml(InputStream inputStream) throws Exception {
        try (InputStreamReader is = new InputStreamReader(inputStream);){
            this.loadYml(is);
        }
    }

    public void loadYml(Reader reader) throws IOException {
        List<String> partList = this.splitParts(reader);
        String partStr = null;
        for (int i = 0; i < partList.size(); ++i) {
            partStr = partList.get(i);
            if (Utils.isBlank((String)partStr)) continue;
            int fi = i;
            this.loadYml(partStr, partProp -> {
                if (this.envRef.get() == null && fi == 0 && partProp.containsKey(SOLON_ENV)) {
                    this.envRef.set(String.valueOf(partProp.get(SOLON_ENV)));
                }
            });
        }
    }

    public void loadYml(String str) {
        this.loadYml(str, null);
    }

    public void loadYml(String str, Consumer<Map<Object, Object>> c) {
        Object tmp = this.createYaml().load(str);
        TreeMap<Object, Object> partProp = new TreeMap<Object, Object>();
        this.load0(partProp, "", tmp);
        if (partProp.size() == 0) {
            return;
        }
        if (c != null) {
            c.accept(partProp);
        }
        if (partProp.containsKey(SOLON_ENV_ON)) {
            String envOn = String.valueOf(partProp.get(SOLON_ENV_ON));
            if (Arrays.stream(envOn.split("\\|")).anyMatch(e -> e.trim().equals(this.envRef.get()))) {
                super.putAll((Map<?, ?>)partProp);
            }
        } else {
            super.putAll((Map<?, ?>)partProp);
        }
    }

    private List<String> splitParts(Reader reader) throws IOException {
        ArrayList<String> partList = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(reader);){
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith(YML_PART_SPLIT)) {
                    partList.add(buffer.toString());
                    buffer.setLength(0);
                    continue;
                }
                buffer.append(line).append("\n");
            }
            partList.add(buffer.toString());
        }
        return partList;
    }

    private void load0(Map<Object, Object> temProp, String prefix, Object tmp) {
        if (tmp instanceof Map) {
            ((Map)tmp).forEach((? super K k, ? super V v) -> {
                String prefix2 = prefix + "." + k;
                this.load0(temProp, prefix2, v);
            });
            return;
        }
        if (tmp instanceof List) {
            int index = 0;
            for (Object v2 : (List)tmp) {
                String prefix2 = prefix + "[" + index + "]";
                this.load0(temProp, prefix2, v2);
                ++index;
            }
            return;
        }
        if (tmp == null) {
            this.put0(temProp, prefix, "");
        } else {
            this.put0(temProp, prefix, String.valueOf(tmp));
        }
    }

    private void put0(Map<Object, Object> temProp, String key, Object val) {
        if (key.startsWith(".")) {
            temProp.put(key.substring(1), val);
        } else {
            temProp.put(key, val);
        }
    }
}

