/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Parser;
import org.noear.solon.expression.snel.TemplateFragment;
import org.noear.solon.expression.snel.TemplateNode;
import org.noear.solon.expression.util.LRUCache;

public class SnelTemplateParser
implements Parser<String> {
    private static final SnelTemplateParser INSTANCE = new SnelTemplateParser(1000);
    private final Map<String, Expression<String>> exprCached;
    public static final char MARK_START1 = '#';
    public static final char MARK_START2 = '$';
    private static final char MARK_BRACE_OPEN = '{';
    private static final char MARK_BRACE_CLOSE = '}';

    public SnelTemplateParser(int cahceCapacity) {
        this.exprCached = Collections.synchronizedMap(new LRUCache(cahceCapacity));
    }

    public static SnelTemplateParser getInstance() {
        return INSTANCE;
    }

    @Override
    public Expression<String> parse(String expr, boolean cached) {
        return cached ? this.exprCached.computeIfAbsent(expr, this::parseDo) : this.parseDo(expr);
    }

    private Expression<String> parseDo(String expr) {
        ArrayList<TemplateFragment> fragments = new ArrayList<TemplateFragment>(expr.length() / 16);
        boolean inExpression = false;
        char marker = '\u0000';
        int textStart = 0;
        int scanPosition = 0;
        int length = expr.length();
        while (scanPosition < length) {
            if (!inExpression) {
                int exprStart = this.findExpressionStart(expr, scanPosition);
                if (exprStart != -1) {
                    if (textStart < exprStart) {
                        fragments.add(new TemplateFragment(false, 0, expr.substring(textStart, exprStart)));
                    }
                    marker = expr.charAt(exprStart);
                    inExpression = true;
                    textStart = scanPosition = exprStart + 2;
                    continue;
                }
                fragments.add(new TemplateFragment(false, 0, expr.substring(textStart)));
                break;
            }
            int closePos = expr.indexOf(125, scanPosition);
            if (closePos != -1) {
                fragments.add(new TemplateFragment(true, marker, expr.substring(textStart, closePos)));
                inExpression = false;
                textStart = scanPosition = closePos + 1;
                continue;
            }
            fragments.add(new TemplateFragment(false, 0, expr.substring(textStart - 2, textStart) + expr.substring(textStart)));
            break;
        }
        return new TemplateNode(fragments);
    }

    private int findExpressionStart(String s, int start) {
        for (int i = start; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (c != '#' && c != '$' || s.charAt(i + 1) != '{') continue;
            return i;
        }
        return -1;
    }
}

