/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.ActionArgumentResolver;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.LazyReference;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.VarSpec;

public abstract class AbstractEntityReader {
    protected Object[] doRead(Context ctx, Object target, MethodWrap mWrap) throws Throwable {
        ParamWrap[] pSet = mWrap.getParamWraps();
        Object[] args = new Object[pSet.length];
        LazyReference bodyRef = new LazyReference(() -> this.changeBody(ctx, mWrap));
        int len = pSet.length;
        for (int i = 0; i < len; ++i) {
            ParamWrap p = pSet[i];
            args[i] = this.doReadArgument(ctx, target, mWrap, p, i, bodyRef);
        }
        return args;
    }

    protected Object doReadArgument(Context ctx, Object target, MethodWrap mWrap, ParamWrap pWrap, int pIndex, LazyReference bodyRef) throws Throwable {
        ActionArgumentResolver argumentResolver;
        Class pt = pWrap.getType();
        if (Context.class.isAssignableFrom(pt)) {
            return ctx;
        }
        if (ModelAndView.class.isAssignableFrom(pt)) {
            return new ModelAndView();
        }
        if (Locale.class.isAssignableFrom(pt)) {
            return ctx.getLocale();
        }
        if (UploadedFile.class == pt) {
            return ctx.file(pWrap.spec().getName());
        }
        if (UploadedFile[].class == pt) {
            return ctx.fileValues(pWrap.spec().getName());
        }
        Object tv = null;
        if (Object.class != pt) {
            tv = ctx.pull(pt);
        }
        if (tv == null && pWrap.spec().isRequiredBody()) {
            if (String.class.equals((Object)pt)) {
                tv = ctx.bodyNew();
            } else if (InputStream.class.equals((Object)pt)) {
                tv = ctx.bodyAsStream();
            } else if (Map.class.equals((Object)pt) && bodyRef.get() instanceof MultiMap) {
                tv = ((MultiMap)bodyRef.get()).toValueMap();
            }
        }
        if (tv == null && Solon.app() != null && (argumentResolver = Solon.app().chains().getArgumentResolver(ctx, pWrap)) != null) {
            tv = argumentResolver.resolveArgument(ctx, target, mWrap, pWrap, pIndex, bodyRef);
        }
        if (tv == null) {
            try {
                tv = this.changeValue(ctx, pWrap, pIndex, pt, bodyRef);
            }
            catch (ConstructionException e) {
                throw e;
            }
            catch (Exception e) {
                String methodFullName = mWrap.getDeclaringClz().getName() + "::" + mWrap.getName() + "@" + pWrap.spec().getName();
                throw new StatusException("Action parameter change failed: " + methodFullName, (Throwable)e, 400);
            }
        }
        if (tv == null && pt.isPrimitive()) {
            if (pt == Short.TYPE) {
                tv = (short)0;
            } else if (pt == Integer.TYPE) {
                tv = 0;
            } else if (pt == Long.TYPE) {
                tv = 0L;
            } else if (pt == Double.TYPE) {
                tv = 0.0;
            } else if (pt == Float.TYPE) {
                tv = Float.valueOf(0.0f);
            } else if (pt == Boolean.TYPE) {
                tv = false;
            } else {
                throw new IllegalArgumentException("Please enter a valid parameter @" + pWrap.spec().getName());
            }
        }
        if (tv == null && pWrap.spec().isRequiredInput()) {
            throw new StatusException(pWrap.spec().getRequiredHint(), 400);
        }
        return tv;
    }

    protected Object changeBody(Context ctx, MethodWrap mWrap) throws Exception {
        return ctx.paramMap();
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, LazyReference bodyRef) throws Throwable {
        String pn = p.spec().getName();
        String pv = p.spec().getValue(ctx);
        if (pv == null) {
            pv = p.spec().getDefaultValue();
        }
        if (pv == null) {
            Type pta0;
            if (UploadedFile.class == pt) {
                return ctx.file(pn);
            }
            if (UploadedFile[].class == pt) {
                return ctx.fileValues(pn);
            }
            if (p.getGenericType() != null && List.class.isAssignableFrom(pt) && UploadedFile.class.equals((Object)(pta0 = p.getGenericType().getActualTypeArguments()[0]))) {
                return Arrays.asList(ctx.fileValues(pn));
            }
            if (pn.startsWith("$")) {
                return ctx.attr(pn);
            }
            if (pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive() || pt.isEnum()) {
                return null;
            }
            return this.changeEntityDo(ctx, p, pn, pt);
        }
        return this.changeValueDo(ctx, p, pn, pt, pv);
    }

    protected Object changeValueDo(Context ctx, ParamWrap p, String name, Class<?> type, String value) {
        return ConvertUtil.to((VarSpec)p.spec(), (String)value, (Context)ctx);
    }

    protected Object changeEntityDo(Context ctx, ParamWrap p, String name, Class<?> type) throws Exception {
        ClassWrap clzW = ClassWrap.get(type);
        MultiMap map = ctx.paramMap();
        return clzW.newBy(arg_0 -> ((MultiMap)map).get(arg_0), ctx);
    }
}

