/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Consumes;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Multipart;
import org.noear.solon.annotation.Produces;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.EntityConverter;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.ReturnValueHandler;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.PathMatcher;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.wrap.MethodWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDefault
extends HandlerAide
implements Action {
    static final Logger log = LoggerFactory.getLogger(ActionDefault.class);
    private final BeanWrap bWrap;
    private final HandlerAide bAide;
    private Render bRender;
    private final MethodWrap mWrap;
    private String mProduces;
    private String mConsumes;
    private final String mName;
    private final String mFullName;
    private final boolean mRemoting;
    private final Mapping mMapping;
    private final String mVersion;
    private boolean mMultipart;
    private PathMatcher pathKeysAnalyzer;
    private List<String> pathKeys;

    public ActionDefault(BeanWrap bWrap, Method method) {
        this(bWrap, null, null, method, null, null, false, null);
    }

    public ActionDefault(BeanWrap bWrap, HandlerAide bAide, String bVersion, Method method, Mapping mapping, String path, boolean remoting, Render render) {
        this.bWrap = bWrap;
        this.bAide = bAide;
        ClassUtil.accessibleAsTrue((AccessibleObject)method);
        if (NativeDetector.isAotRuntime()) {
            bWrap.context().methodGet(bWrap.rawClz(), method);
        }
        this.mWrap = new MethodWrap(bWrap.context(), bWrap.rawClz(), method).ofHandler();
        this.mRemoting = remoting;
        this.mMapping = mapping;
        this.bRender = render;
        if (this.bRender == null && Render.class.isAssignableFrom(bWrap.clz())) {
            this.bRender = (Render)bWrap.raw();
        }
        if (mapping == null) {
            this.mName = method.getName();
            this.mVersion = bVersion;
        } else {
            Produces producesAnno = method.getAnnotation(Produces.class);
            Consumes consumesAnno = method.getAnnotation(Consumes.class);
            Multipart multipartAnno = method.getAnnotation(Multipart.class);
            this.mProduces = producesAnno == null ? mapping.produces() : producesAnno.value();
            this.mConsumes = consumesAnno == null ? mapping.consumes() : consumesAnno.value();
            if (Utils.isEmpty((String)this.mProduces) && (producesAnno = bWrap.rawClz().getAnnotation(Produces.class)) != null) {
                this.mProduces = producesAnno.value();
            }
            if (Utils.isEmpty((String)this.mConsumes) && (consumesAnno = bWrap.rawClz().getAnnotation(Consumes.class)) != null) {
                this.mConsumes = consumesAnno.value();
            }
            if (multipartAnno == null) {
                multipartAnno = bWrap.rawClz().getAnnotation(Multipart.class);
            }
            this.mMultipart = multipartAnno == null ? mapping.multipart() : true;
            this.mName = Utils.annoAlias((String)mapping.value(), (String)mapping.path());
            this.mVersion = Utils.annoAlias((String)mapping.version(), (String)bVersion);
        }
        this.mFullName = Utils.isEmpty((String)path) ? this.mName : (path.startsWith("/") ? path.substring(1) : path);
        if (!this.mMultipart) {
            for (Class<?> clz : method.getParameterTypes()) {
                if (!UploadedFile.class.isAssignableFrom(clz)) continue;
                this.mMultipart = true;
                break;
            }
        }
        if (path != null && path.contains("{")) {
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathKeysAnalyzer = PathMatcher.get((String)path);
            }
        }
    }

    public String name() {
        return this.mName;
    }

    public String fullName() {
        return this.mFullName;
    }

    public Mapping mapping() {
        return this.mMapping;
    }

    public MethodWrap method() {
        return this.mWrap;
    }

    public BeanWrap controller() {
        return this.bWrap;
    }

    public String produces() {
        return this.mProduces;
    }

    public String consumes() {
        return this.mConsumes;
    }

    public String version() {
        return this.mVersion;
    }

    public void handle(Context x) throws Throwable {
        if (Utils.isNotEmpty((String)this.mConsumes) && (x.contentType() == null || !x.contentType().contains(this.mConsumes))) {
            throw new StatusException("Unsupported Media Type, path=" + x.path(), 415);
        }
        if (this.mMultipart) {
            x.autoMultipart(true);
        }
        if (Utils.isNotEmpty((String)this.mProduces)) {
            x.contentType(this.mProduces);
        }
        this.invoke(x, null);
    }

    public void invoke(Context c, Object obj) throws Throwable {
        c.remotingSet(this.mRemoting);
        try {
            if (obj == null) {
                obj = this.bWrap.get(true);
            }
            c.attrSet("ATTR_CONTROLLER", obj);
            c.attrSet("ATTR_MAIN_HANDLER", (Object)this);
            if (this.bAide == null) {
                this.invokeFilterDo(c);
            } else {
                new FilterChainImpl(this.bAide.filters(), this::invokeFilterDo).doFilter(c);
            }
        }
        catch (Throwable e) {
            c.setHandled(true);
            e = Utils.throwableUnwrap((Throwable)e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.renderDo(ex, c);
                } else {
                    this.renderDo(ex.data(), c);
                }
            }
            c.errors = e;
            this.renderDo(e, c);
        }
    }

    protected void invokeFilterDo(Context x) throws Throwable {
        new FilterChainImpl(this.filters(), this::invokeHandleDo).doFilter(x);
    }

    protected void invokeHandleDo(Context x) throws Throwable {
        Object obj = x.controller();
        this.invokeMethodDo(x, obj);
    }

    protected void invokeMethodDo(Context c, Object obj) throws Throwable {
        try {
            if (!c.getHandled()) {
                this.bindPathVarDo(c);
                c.result = this.executeDo(c, obj);
                ReturnValueHandler returnHandler = (ReturnValueHandler)c.attr("ATTR_RETURN_HANDLER");
                if (returnHandler == null && c.result != null) {
                    returnHandler = this.bWrap.context().app().chains().getReturnHandler(c, c.result.getClass());
                }
                if (returnHandler != null) {
                    returnHandler.returnHandle(c, c.result);
                } else {
                    this.renderDo(c.result, c);
                }
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap((Throwable)e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.renderDo(ex, c);
                } else {
                    this.renderDo(ex.data(), c);
                }
            }
            c.errors = e;
            throw e;
        }
    }

    private void bindPathVarDo(Context c) throws Throwable {
        Matcher pm;
        if (this.pathKeysAnalyzer != null && (pm = this.pathKeysAnalyzer.matcher(c.pathNew())).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                c.paramMap().add(this.pathKeys.get(i), (Object)pm.group(i + 1));
            }
        }
    }

    protected Object executeDo(Context c, Object target) throws Throwable {
        EntityConverter entityConverter = this.bWrap.context().app().chains().getCanReadEntityConverter(c, this.mWrap.getParamWraps().length);
        Object[] args = entityConverter.read(c, target, this.mWrap);
        this.bWrap.context().app().chains().postArguments(c, this.mWrap.getParamWraps(), args);
        return this.mWrap.invokeByAspect(target, args);
    }

    public void render(Object obj, Context c, boolean allowMultiple) throws Throwable {
        this.renderDo(obj, c, allowMultiple);
    }

    protected void renderDo(Object obj, Context c) throws Throwable {
        this.renderDo(obj, c, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void renderDo(Object obj, Context c, boolean allowMultiple) throws Throwable {
        obj = this.bWrap.context().app().chains().postResult(c, obj);
        if (allowMultiple || !c.getRendered()) {
            c.result = obj;
        }
        if (this.bRender != null) {
            this.bRender.render(obj, c);
            return;
        }
        if (obj instanceof DataThrowable) {
            return;
        }
        if (obj == null && Void.TYPE == this.method().getReturnType()) {
            return;
        }
        if (obj instanceof Throwable) {
            if (!c.remoting()) {
                c.setHandled(false);
                throw (Throwable)obj;
            }
            Throwable objE = (Throwable)obj;
            log.warn("Action remoting handle failed: " + c.pathNew(), objE);
            if (c.getRendered()) return;
            if (objE instanceof StatusException) {
                StatusException se = (StatusException)objE;
                c.status(se.getCode(), se.getMessage());
            } else {
                c.status(500, objE.getMessage());
            }
            c.setRendered(true);
            return;
        }
        if (!allowMultiple) {
            if (c.getRendered()) return;
        }
        c.render(obj);
    }

    public String toString() {
        return "Mapping: " + this.fullName();
    }
}

