/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization;

import java.util.Base64;
import org.noear.solon.core.handle.AbstractEntityConverter;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.Assert;
import org.noear.solon.serialization.EntitySerializer;
import org.noear.solon.serialization.SerializationConfig;

public abstract class AbstractBytesEntityConverter<T extends EntitySerializer<byte[]>>
extends AbstractEntityConverter {
    protected final T serializer;

    public T getSerializer() {
        return this.serializer;
    }

    public AbstractBytesEntityConverter(T serializer) {
        Assert.notNull(serializer, (String)"Serializer not be null");
        this.serializer = serializer;
    }

    public boolean allowWrite() {
        return true;
    }

    public boolean canWrite(String mime, Context ctx) {
        return this.serializer.matched(ctx, mime);
    }

    public String writeAndReturn(Object data, Context ctx) throws Throwable {
        byte[] tmp = (byte[])this.serializer.serialize(data);
        return Base64.getEncoder().encodeToString(tmp);
    }

    public void write(Object data, Context ctx) throws Throwable {
        if (SerializationConfig.isOutputMeta()) {
            ctx.headerAdd("solon.serialization", this.name());
        }
        this.serializer.serializeToBody(ctx, data);
    }

    public boolean allowRead() {
        return true;
    }

    public boolean canRead(Context ctx, String mime) {
        return this.serializer.matched(ctx, mime);
    }
}

