/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jlhttp;

import java.io.IOException;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jlhttp.HTTPServer;
import org.noear.solon.boot.jlhttp.JlHttpContext;
import org.noear.solon.boot.jlhttp.XPluginImp;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;

public class JlHttpContextHandler
implements HTTPServer.ContextHandler {
    private final Handler handler;

    public JlHttpContextHandler(Handler handler) {
        this.handler = handler;
    }

    @Override
    public int serve(HTTPServer.Request request, HTTPServer.Response response) throws IOException {
        try {
            return this.handleDo(request, response);
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
            response.sendHeaders(500);
            return 0;
        }
    }

    protected int handleDo(HTTPServer.Request request, HTTPServer.Response response) throws IOException {
        JlHttpContext ctx = new JlHttpContext(request, response);
        try {
            ctx.contentType("text/plain;charset=UTF-8");
            if (ServerProps.output_meta) {
                ctx.headerSet("Solon-Boot", XPluginImp.solon_boot_ver());
            }
            this.handler.handle((Context)ctx);
            if (ctx.getHandled() || ctx.status() >= 200) {
                ctx.commit();
                return 0;
            }
            return 404;
        }
        catch (Throwable e) {
            EventBus.pushTry((Object)e);
            return 500;
        }
    }
}

