/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ResourceUtil;

public class Scanner {
    public Set<String> scan(ClassLoader classLoader, String path, boolean fileMode, Predicate<String> filter) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        try {
            if (fileMode) {
                URL root = Utils.getFile(path).toURI().toURL();
                this.scanDo(root, path, fileMode, filter, urls);
            } else {
                if (classLoader == null) {
                    return urls;
                }
                Enumeration<URL> roots = ResourceUtil.getResources(classLoader, path);
                while (roots.hasMoreElements()) {
                    this.scanDo(roots.nextElement(), path, fileMode, filter, urls);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return urls;
    }

    protected void scanDo(URL url, String path, boolean fileMode, Predicate<String> filter, Set<String> urls) throws IOException {
        if ("file".equals(url.getProtocol())) {
            String fp = URLDecoder.decode(url.getFile(), Solon.encoding());
            this.doScanByFile(new File(fp), path, fileMode, filter, urls);
        } else if ("jar".equals(url.getProtocol())) {
            JarURLConnection jarCon = (JarURLConnection)url.openConnection();
            try (JarFile jar = jarCon.getJarFile();){
                this.doScanByJar(jar, path, filter, urls);
                jarCon.connect();
            }
        }
    }

    protected void doScanByFile(File dir, String path, boolean fileMode, Predicate<String> filter, Set<String> urls) {
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] dirfiles = dir.listFiles(f -> f.isDirectory() || filter.test(f.getName()));
        if (dirfiles != null) {
            for (File f2 : dirfiles) {
                String p2 = path + "/" + f2.getName();
                if (f2.isDirectory()) {
                    this.doScanByFile(f2, p2, fileMode, filter, urls);
                    continue;
                }
                if (p2.startsWith("/") && !fileMode) {
                    urls.add(p2.substring(1));
                    continue;
                }
                urls.add(p2);
            }
        }
    }

    protected void doScanByJar(JarFile jar, String path, Predicate<String> filter, Set<String> urls) {
        Enumeration<JarEntry> entry = jar.entries();
        while (entry.hasMoreElements()) {
            JarEntry e = entry.nextElement();
            String n = e.getName();
            if (n.charAt(0) == '/') {
                n = n.substring(1);
            }
            if (e.isDirectory() || !n.startsWith(path) || !filter.test(n)) continue;
            if (n.startsWith("/")) {
                urls.add(n.substring(1));
                continue;
            }
            urls.add(n);
        }
    }
}

