/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.function.Supplier;
import org.noear.eggg.ParamEggg;
import org.noear.eggg.TypeEggg;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.VarHolder;

public class VarHolderOfParam
implements VarHolder {
    private final ParamEggg pe;
    private final ParameterizedType pType;
    private final AppContext ctx;
    private Class<?> dependencyType;
    private Object val;
    private Supplier valDef;
    private boolean done;
    private boolean required = false;
    private InjectGather gather;

    public VarHolderOfParam(AppContext ctx, ParamEggg pe, InjectGather gather) {
        this.ctx = ctx;
        this.pe = pe;
        this.gather = gather;
        this.pType = pe.getTypeEggg().isParameterizedType() ? pe.getTypeEggg().getParameterizedType() : null;
    }

    @Override
    public AppContext context() {
        return this.ctx;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public TypeEggg getTypeEggg() {
        return this.pe.getTypeEggg();
    }

    @Override
    public Class<?> getType() {
        return this.pe.getType();
    }

    @Override
    public ParameterizedType getGenericType() {
        return this.pType;
    }

    @Override
    public Class<?> getDependencyType() {
        if (this.dependencyType == null) {
            return this.getType();
        }
        return this.dependencyType;
    }

    @Override
    public void setDependencyType(Class<?> dependencyType) {
        this.dependencyType = dependencyType;
    }

    @Override
    public Annotation[] getAnnoS() {
        return this.pe.getAnnotations();
    }

    @Override
    public String getFullName() {
        Class<?> declClz;
        Executable e = this.pe.getParam().getDeclaringExecutable();
        Class<?> fileClz = declClz = e.getDeclaringClass();
        if (declClz.isMemberClass()) {
            fileClz = declClz.getEnclosingClass();
        }
        if (e instanceof Method) {
            Method m = (Method)e;
            return "'" + this.pe.getParam().getName() + "'\r\n\tat " + declClz.getName() + "." + m.getName() + "(" + fileClz.getSimpleName() + ".java:0)";
        }
        return "'" + this.pe.getParam().getName() + "'\r\n\tat " + declClz.getName() + "(" + fileClz.getSimpleName() + ".java:10)";
    }

    @Override
    public void setValue(Object val) {
        this.val = val;
        this.done = true;
        if (this.gather != null) {
            this.gather.run();
        }
    }

    @Override
    public void setValueDefault(Supplier supplier) {
        this.valDef = supplier;
    }

    @Override
    public Object getValue() {
        if (this.val == null && this.valDef != null) {
            return this.valDef.get();
        }
        return this.val;
    }

    @Override
    public void commit() {
        Object tmp;
        if (this.isDone()) {
            return;
        }
        if (this.valDef != null && (tmp = this.valDef.get()) != null) {
            this.setValue(tmp);
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public void required(boolean required) {
        this.required = required;
    }

    public String toString() {
        if (this.pe.getGenericType() == null) {
            return this.pe.getName() + ":" + this.pe.getType().getTypeName();
        }
        return this.pe.getName() + ":" + this.pe.getGenericType().getTypeName();
    }
}

