/*
 * Decompiled with CFR 0.152.
 */
package org.pumpkin.database.relation.database.datasource.impl;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.pumpkin.database.relation.database.dao.IRelationSpatialDao;
import org.pumpkin.database.relation.database.dao.impl.MysqlSpatialDao;
import org.pumpkin.database.relation.database.datasource.DataSource;
import org.pumpkin.database.relation.database.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDataSource
extends DataSource {
    private Logger logger = LoggerFactory.getLogger(MysqlDataSource.class);

    public MysqlDataSource(String url, String user, String password) throws SQLException {
        super(url, user, password, DataSource.DataSourceType.mysql);
    }

    public IRelationSpatialDao getDao() throws SQLException {
        Connection conn = this.getConnection();
        return new MysqlSpatialDao(conn);
    }

    @Override
    public boolean isValid() {
        Connection conn = null;
        try {
            Class.forName(this.type.getDriver());
            conn = DriverManager.getConnection(this.url, this.user, this.password);
            String sql = "select 1";
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            rs.close();
            stmt.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            String sqlstate = e.getSQLState();
            if ("28000".equals(sqlstate)) {
                throw new BusinessException("\u8d26\u53f7\u548c\u5bc6\u7801\u9519\u8bef");
            }
            if ("42000".equals(sqlstate)) {
                throw new BusinessException("\u6570\u636e\u5e93\u4e0d\u5b58\u5728");
            }
            String message = "\u8fde\u63a5\u5931\u8d25\uff0c" + this.url;
            throw new BusinessException(message);
        }
        catch (Exception e) {
            this.logger.error("\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            String message = "\u8fde\u63a5\u5931\u8d25\uff0c" + this.url;
            throw new BusinessException(message);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

