/*
 * Decompiled with CFR 0.152.
 */
package org.pumpkin.database.relation.database.dao.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.pumpkin.database.relation.database.bean.GeomeryColumn;
import org.pumpkin.database.relation.database.bean.GeometryInfo;
import org.pumpkin.database.relation.database.bean.GeometryType;
import org.pumpkin.database.relation.database.bean.Index;
import org.pumpkin.database.relation.database.bean.PageResult;
import org.pumpkin.database.relation.database.bean.SpatialDataSet;
import org.pumpkin.database.relation.database.bean.TableColumn;
import org.pumpkin.database.relation.database.bean.UpdateNodeBean;
import org.pumpkin.database.relation.database.constants.ProjSRIDType;
import org.pumpkin.database.relation.database.dao.RelationSpatialDao;
import org.pumpkin.database.relation.database.datasource.DataSource;
import org.pumpkin.database.relation.database.exception.BusinessException;
import org.pumpkin.database.relation.database.utils.PreparedStatementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSpatialDao
extends RelationSpatialDao {
    protected DataSource.DataSourceType type = DataSource.DataSourceType.oracle;
    Logger logger = LoggerFactory.getLogger(OracleSpatialDao.class);

    public OracleSpatialDao(Connection conn) {
        super(conn);
    }

    @Override
    public GeometryInfo getGeometryInfo(String tableName, String geometryField) throws SQLException {
        GeometryInfo info;
        if (StringUtils.isEmpty((CharSequence)geometryField)) {
            String sql = "select column_name from user_tab_cols where TABLE_NAME = ? and DATA_TYPE = 'SDO_GEOMETRY'";
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{tableName});
            Boolean exist = false;
            int geoNum = 0;
            while (rs.next()) {
                ++geoNum;
                if (!StringUtils.isNotEmpty((CharSequence)rs.getString("column_name"))) continue;
                geometryField = rs.getString("column_name");
            }
            if (geoNum > 1) {
                throw new BusinessException("\u8bf7\u660e\u786e\u6307\u5b9a\u7a7a\u95f4\u5b57\u6bb5");
            }
            ps.close();
        }
        if ((info = this.getGeometryInfoByRow(tableName, geometryField)) != null) {
            info.setGeometryFieldName(geometryField);
        }
        return info;
    }

    private GeometryInfo getGeometryInfoByRow(String tableName, String geometryField) throws SQLException {
        GeometryInfo info = null;
        String typeSql = "SELECT t." + geometryField + ".SDO_GTYPE as type, t." + geometryField + ".SDO_SRID as srid from " + tableName + " t where " + geometryField + " is not null and rownum = 1";
        String geometryType = null;
        Integer srid = null;
        try (PreparedStatement nps = this.conn.prepareStatement(typeSql);
             ResultSet nrs = nps.executeQuery();){
            while (nrs.next()) {
                info = new GeometryInfo();
                int gtype = nrs.getInt("type");
                srid = nrs.getInt("srid");
                geometryType = this.getGeometryTypeStrByGType(gtype);
                if (StringUtils.isEmpty((CharSequence)geometryType)) {
                    throw new BusinessException("\u4ec5\u652f\u6301\u4e8c\u7ef4\u7684\u7a7a\u95f4\u7c7b\u578b\uff0c\u5f53\u524d\u7c7b\u578b\u7f16\u7801" + gtype);
                }
                info.setType(GeometryType.valueOf(geometryType));
                info.setSrid(srid);
            }
        }
        return info;
    }

    private String getGeometryTypeStrByGType(int gType) {
        switch (gType) {
            case 2001: {
                return "POINT";
            }
            case 2002: {
                return "LINESTRING";
            }
            case 2003: {
                return "POLYGON";
            }
            case 2005: {
                return "MULTIPOINT";
            }
            case 2006: {
                return "MULTILINESTRING";
            }
            case 2007: {
                return "MULTIPOLYGON";
            }
        }
        return null;
    }

    @Override
    public Integer getSrid(String tableName) throws SQLException {
        return null;
    }

    @Override
    public String getExtent(String tableName, String field) throws SQLException {
        String sql = "";
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            sql = "SELECT SDO_UTIL.TO_WKTGEOMETRY(SDO_TUNE.EXTENT_OF('" + tableName + "', '" + field + "')) as wkt  FROM DUAL ";
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
        }
        catch (Exception ex) {
            sql = "SELECT MDSYS.SDO_UTIL.TO_WKTGEOMETRY(" + field + ") as wkt from " + tableName + " where ROWNUM=1";
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
        }
        String wkt = null;
        while (rs.next()) {
            wkt = rs.getString("wkt");
        }
        if (wkt == null) {
            wkt = "POLYGON((97.5272782897613 21.1423123704196,97.5272782897613 29.225285980064,106.196957920072 29.225285980064,106.196957920072 21.1423123704196,97.5272782897613 21.1423123704196))";
        }
        ps.close();
        return wkt;
    }

    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields) throws SQLException {
        return this.list(tableName, conn, pageIndex, rows, keyWord, wkt, geomField, Fields, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields, String sortField, String sortType) throws SQLException {
        Statement ps = null;
        ResultSet rs = null;
        HashMap<String, Object> datas = new HashMap<String, Object>();
        ArrayList<String> allFields = new ArrayList<String>();
        ArrayList dataslist = new ArrayList();
        ArrayList<String> searchFields = new ArrayList<String>();
        try {
            String searchType = "VARCHAR2,NUMBER,LONG,NVARCHAR2,CHAR,NCHAR";
            for (TableColumn field : Fields) {
                String type = field.getType();
                String name = field.getName();
                if ("CLOB".equals(type) || "BLOB".equals(type)) continue;
                allFields.add(name);
                if (!searchType.contains(type)) continue;
                String notNullField = "COALESCE(" + name + " ,'')";
                if ("integer".equals(type) || "numeric".equals(type)) {
                    notNullField = "COALESCE(" + name + " ,0)";
                }
                searchFields.add(notNullField);
            }
            List fieldsList = allFields.stream().collect(Collectors.toList());
            fieldsList.remove(geomField);
            fieldsList.add("MDSYS.SDO_UTIL.TO_WKTGEOMETRY(" + geomField + ") as geom");
            fieldsList.add("ROWNUM AS rowno");
            String allFieldsStr = StringUtils.join(fieldsList, (String)",");
            String text = StringUtils.join(searchFields, (String)"||'-'||");
            text = "'' || " + text;
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append(allFieldsStr);
            sql.append(" from ");
            sql.append(tableName);
            Object[] paras = null;
            if (wkt != null && !"".equals(wkt)) {
                sql.append(" where ");
                sql.append(text);
                sql.append(" like ?");
                paras = new Object[]{"%" + wkt + "%"};
            }
            ps = conn.prepareStatement(sql.toString().replace(allFieldsStr, "count(*) as num"));
            rs = paras != null ? PreparedStatementUtils.executeQuery((PreparedStatement)ps, paras) : PreparedStatementUtils.executeQuery((PreparedStatement)ps, new Object[0]);
            long count = -1L;
            while (rs.next()) {
                count = rs.getInt("num");
            }
            ps.close();
            paras = paras != null ? new Object[]{"%" + wkt + "%", (pageIndex + 1) * rows, pageIndex * rows} : new Object[]{(pageIndex + 1) * rows, pageIndex * rows};
            if (StringUtils.isNotEmpty((CharSequence)wkt)) {
                sql.append(" AND ROWNUM <= ?");
            } else {
                sql.append(" where ROWNUM <= ?");
            }
            if (StringUtils.isNotBlank((CharSequence)sortField)) {
                String type = StringUtils.isNotEmpty((CharSequence)sortType) ? sortType : "ASC";
                sql.append(" ORDER BY ").append(sortField).append(" ").append(type);
            }
            sql.insert(0, "select * from (");
            sql.append(") t where t.rowno > ?");
            ps = conn.prepareStatement(sql.toString());
            rs = PreparedStatementUtils.executeQuery((PreparedStatement)ps, paras);
            int fieldsNum = allFields.size();
            allFields.remove(geomField);
            allFields.add("geom");
            HashMap<String, Object> row = null;
            String field = null;
            dataslist = new ArrayList();
            while (rs.next()) {
                row = new HashMap<String, Object>();
                for (int i = 0; i < fieldsNum; ++i) {
                    field = (String)allFields.get(i);
                    Object v = rs.getObject(field);
                    if ("geom".equals(field)) {
                        Clob clob = rs.getClob(field);
                        String value = this.clobToString(clob);
                        row.put(field, value);
                        continue;
                    }
                    if (v instanceof Clob || v instanceof Blob) continue;
                    row.put(field, v);
                }
                dataslist.add(row);
            }
            datas.put("count", count);
            datas.put("columns", allFields);
            datas.put("data", dataslist);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return datas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clobToString(Clob clob) {
        String reString = "";
        Reader is = null;
        BufferedReader br = null;
        try {
            is = clob.getCharacterStream();
            br = new BufferedReader(is);
            String s = br.readLine();
            StringBuffer sb = new StringBuffer();
            while (s != null) {
                sb.append(s);
                s = br.readLine();
            }
            reString = sb.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return reString;
    }

    @Override
    public Boolean exists(String tableName) throws SQLException {
        String sql = "SELECT 1 as exist from (SELECT VIEW_NAME AS table_name FROM user_views UNION SELECT table_name FROM user_tables) where table_name = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{tableName});
        Boolean exist = false;
        while (rs.next()) {
            if (rs.getInt("exist") != 1) continue;
            exist = true;
        }
        ps.close();
        return exist;
    }

    @Override
    public String getPk(String tableName) throws SQLException {
        StringBuffer columnSql = new StringBuffer();
        columnSql.append("select a.column_name from user_cons_columns a, user_constraints b where a.constraint_name = b.constraint_name and b.constraint_type = 'P' and a.table_name = ?");
        PreparedStatement ps = this.conn.prepareStatement(columnSql.toString());
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        ArrayList fields = new ArrayList();
        if (rs.next()) {
            return rs.getString("column_name");
        }
        ps.close();
        return null;
    }

    @Override
    public List<TableColumn> getFields(String tableName) throws SQLException {
        String sql = "select column_name,data_type from user_tab_cols where TABLE_NAME = ? and HIDDEN_COLUMN = 'NO' and VIRTUAL_COLUMN = 'NO'";
        PreparedStatement ps = this.conn.prepareStatement(sql.toString());
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        ArrayList<TableColumn> fields = new ArrayList<TableColumn>();
        while (rs.next()) {
            TableColumn field = new TableColumn();
            field.setName(rs.getString("column_name"));
            field.setType(rs.getString("data_type"));
            fields.add(field);
        }
        ps.close();
        return fields;
    }

    @Override
    public List<TableColumn> getFieldsWithCommit(String tableName) throws SQLException {
        return this.getFields(tableName);
    }

    @Override
    public List<String> getFieldNames(String tableName) throws SQLException {
        String sql = "select column_name from user_tab_cols where TABLE_NAME = ? and HIDDEN_COLUMN = 'NO' and VIRTUAL_COLUMN = 'NO'";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        ArrayList<String> fields = new ArrayList<String>();
        while (rs.next()) {
            fields.add(rs.getString("column_name"));
        }
        ps.close();
        return fields;
    }

    @Override
    public boolean isView(String viewName) throws SQLException {
        String sql = "SELECT count(1) as count from USER_VIEWS where VIEW_NAME = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ps.setString(1, viewName);
        ResultSet rs = ps.executeQuery();
        Integer count = null;
        while (rs.next()) {
            count = rs.getInt("count");
        }
        ps.close();
        return Integer.valueOf(1).equals(count);
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTable(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        keyWord = StringUtils.isEmpty((CharSequence)keyWord) ? "%%" : "%" + keyWord + "%";
        String username = this.conn.getMetaData().getUserName();
        ArrayList<SpatialDataSet> results = new ArrayList<SpatialDataSet>();
        String srid = StringUtils.join(ProjSRIDType.ProjSRID.keySet(), (String)",");
        String baseSql = "select rownum as rn, usgm.TABLE_NAME, usgm.COLUMN_NAME,usgm.SRID from MDSYS.USER_SDO_GEOM_METADATA usgm left join ALL_TABLES usi ON usgm.TABLE_NAME = usi.TABLE_NAME where ( usi.OWNER = ? or usi.OWNER = ? ) and usgm.SRID in (" + srid + ") and UPPER(usgm.TABLE_NAME) like ? ";
        String pageSql = "select * from ( " + baseSql + " and rownum <= ? ) o where o.rn > ?";
        PreparedStatement ps = this.conn.prepareStatement(pageSql);
        Object[] paras = new Object[]{username, username.toLowerCase(), StringUtils.upperCase((String)keyWord), (pageIndex + 1) * rows, pageIndex * rows};
        ResultSet rs = PreparedStatementUtils.executeQuery(ps, paras);
        while (rs.next()) {
            SpatialDataSet elment = new SpatialDataSet();
            elment.setName(rs.getString("TABLE_NAME"));
            ArrayList<GeomeryColumn> list = new ArrayList<GeomeryColumn>();
            list.add(new GeomeryColumn(rs.getString("COLUMN_NAME"), rs.getInt("SRID"), null));
            elment.setGeomeryColumnList(list);
            elment.setSrid(rs.getInt("SRID"));
            results.add(elment);
        }
        ps.close();
        String countSql = "select count(*) as count from ( " + baseSql + " ) o";
        ps = this.conn.prepareStatement(countSql);
        rs = PreparedStatementUtils.executeQuery(ps, new Object[]{username, username.toLowerCase(), StringUtils.upperCase((String)keyWord)});
        Long count = 0L;
        while (rs.next()) {
            count = rs.getLong("count");
        }
        ps.close();
        return new PageResult<SpatialDataSet>(count, results);
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTableWithColumns(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        PageResult<SpatialDataSet> tablePages = this.getSpatialTable(pageIndex, rows, keyWord);
        List<SpatialDataSet> tables = tablePages.getData();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (SpatialDataSet item : tables) {
            tableNames.add(item.getName());
        }
        Map<String, List<TableColumn>> tablesColumns = this.getSpatialColumns(tableNames);
        List<Object> columns = new ArrayList();
        if (tables != null && !tables.isEmpty()) {
            for (int i = 0; i < tables.size(); ++i) {
                SpatialDataSet elment;
                columns = tablesColumns.get((elment = tables.get(i)).getName());
                elment.setColumnList(columns == null ? new ArrayList() : columns);
            }
        }
        return tablePages;
    }

    private Map<String, List<TableColumn>> getSpatialColumns(List<String> tableNames) throws SQLException {
        if (tableNames == null || tableNames.isEmpty()) {
            return null;
        }
        HashMap<String, List<TableColumn>> results = new HashMap<String, List<TableColumn>>();
        String params = "'" + StringUtils.join(tableNames, (String)"','") + "'";
        String tempSql1 = "SELECT  utc.table_name, utc.column_name, utc.data_type|| '('||utc.data_length || ')'as dataType,  utc.data_type, utc.data_length, utc.data_precision, utc.data_Scale, utc.nullable, utc.data_default, ucc.comments  FROM user_tab_columns utc, user_col_comments ucc WHERE utc.table_name = ucc.table_name AND utc.column_name = ucc.column_name ";
        String tempSql2 = "SELECT cu.* FROM user_cons_columns cu, user_constraints au WHERE cu.constraint_name = au.constraint_name AND au.constraint_type = 'P' ";
        String sql = "SELECT tabInf.table_name, tabInf.column_name, tabInf.DATATYPE, tabInf.COMMENTS, tabInf.NULLABLE, PK.position as primary_key  FROM  ( " + tempSql1 + ") tabInf LEFT JOIN (  " + tempSql2 + ") pk ON tabInf.table_name = pk.table_name and tabInf.COLUMN_NAME = pk.COLUMN_NAME WHERE tabInf.table_name in (" + params + ") ";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        ArrayList<TableColumn> columns = null;
        while (rs.next()) {
            TableColumn column = new TableColumn();
            column.setName(rs.getString("column_name"));
            column.setComment(rs.getString("COMMENTS"));
            column.setNotnull(rs.getString("NULLABLE"));
            column.setType(rs.getString("DATATYPE"));
            String isPrimary = rs.getString("primary_key");
            column.setIsPrimary(isPrimary != null);
            String tN = rs.getString("table_name");
            columns = (ArrayList<TableColumn>)results.get(tN);
            if (columns == null) {
                columns = new ArrayList<TableColumn>();
                results.put(tN, columns);
            }
            columns.add(column);
        }
        ps.close();
        return results;
    }

    @Override
    public boolean checkSpatial(String tableName, String geometryField) throws SQLException {
        boolean isView = this.isView(tableName);
        if (isView) {
            throw new BusinessException("oracle\u6570\u636e\u6e90\u4ec5\u652f\u6301\u7a7a\u95f4\u8868\u6ce8\u518c\uff0c\u4e0d\u80fd\u6ce8\u518c\u89c6\u56fe");
        }
        String pk = this.getPk(tableName);
        if (StringUtils.isEmpty((CharSequence)pk)) {
            throw new BusinessException("\u8868" + tableName + "\u7f3a\u5c11\u4e3b\u952e\uff0c\u4e0d\u80fd\u6ce8\u518c");
        }
        this.checkSpatialIndex(tableName, geometryField);
        this.checkDims(tableName, geometryField);
        return true;
    }

    @Override
    public Map<String, List<UpdateNodeBean>> getUpdateNode(String schema) throws SQLException {
        return null;
    }

    @Override
    public String getSequenceNameForTable(String tableName) throws SQLException {
        return null;
    }

    private void checkSdeGeometry(String tableName, String shapeField) throws SQLException {
        String sql = "SELECT count(*)  as count from USER_ST_GEOMETRY_COLUMNS where table_name = ? and lower(column_name) = ?";
        Integer count = null;
        try {
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{tableName, shapeField});
            count = null;
            while (rs.next()) {
                count = rs.getInt("count");
            }
        }
        catch (Throwable e) {
            this.logger.warn("\u68c0\u67e5\u8868" + tableName + "\u662f\u5426\u5b58\u5728SDE\u7a7a\u95f4\u5b57\u6bb5" + shapeField + "\u5931\u8d25", e);
            return;
        }
        if (Integer.valueOf(1).equals(count)) {
            throw new RuntimeException("\u4e0d\u652f\u6301sde\u7c7b\u578b\u7684\u7a7a\u95f4\u6570\u636e");
        }
    }

    public void checkSpatialIndex(String tableName, String geometryField) throws SQLException {
        String sql = "select t.DOMIDX_STATUS,t.DOMIDX_OPSTATUS from user_indexes t where t.ITYP_NAME='SPATIAL_INDEX' and table_name = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{tableName});
        String status = null;
        String opStatus = null;
        while (rs.next()) {
            status = rs.getString("DOMIDX_STATUS");
            opStatus = rs.getString("DOMIDX_OPSTATUS");
        }
        if (opStatus == null || status == null) {
            throw new RuntimeException("\u8868" + tableName + "\u7a7a\u95f4\u5b57\u6bb5" + geometryField + "\u4e0d\u5b58\u5728\u6216\u7f3a\u5c11\u7a7a\u95f4\u7d22\u5f15");
        }
        if (!"VALID".equals(status) || !"VALID".equals(opStatus)) {
            throw new RuntimeException("\u8868." + tableName + "\u7a7a\u95f4\u5b57\u6bb5" + geometryField + "\u7a7a\u95f4\u7d22\u5f15\u4e0d\u53ef\u7528");
        }
    }

    public void checkDims(String tableName, String geometryField) throws SQLException {
        String sql = "SELECT t." + geometryField + ".Get_Dims() as dims from " + tableName + " t where " + geometryField + " is not null and rownum = 1";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[0]);
        Integer dims = null;
        while (rs.next()) {
            dims = rs.getInt("dims");
        }
        if (!Integer.valueOf(2).equals(dims)) {
            throw new RuntimeException("\u7a7a\u95f4\u5b57\u6bb5" + geometryField + "\u4e0d\u662f\u4e8c\u7ef4\u6570\u636e");
        }
    }

    @Override
    public DataSource.DataSourceType getType() {
        return this.type;
    }

    @Override
    public List<Index> getIndexes(String tableName) throws SQLException {
        return null;
    }
}

