/*
 * Decompiled with CFR 0.152.
 */
package org.pumpkin.database.relation.database.datasource.manager;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pumpkin.database.relation.database.datasource.DataSource;
import org.pumpkin.database.relation.database.datasource.manager.DataSourceCollector;
import org.pumpkin.database.relation.database.datasource.manager.DataSourceFactory;

public class DataSourceManager {
    protected static Map<String, DataSource> pools = new ConcurrentHashMap<String, DataSource>();
    public static long EXPIRED_TIMEOUT = 900000L;

    public static void init() {
        DataSourceCollector.start();
    }

    public static DataSource getPool(String key) {
        return pools.get(key);
    }

    public static synchronized Connection getConnection(String poolId) throws Exception {
        if (DataSourceManager.has(poolId)) {
            return DataSourceManager.getPool(poolId).getConnection();
        }
        String[] paras = DataSourceManager.parsePoolId(poolId);
        DataSource pool = DataSourceFactory.create(paras[0], paras[1], paras[2]);
        DataSourceManager.putCache(poolId, pool);
        return pool.getConnection();
    }

    public static synchronized Connection getConnection(String url, String user, String password) throws Exception {
        String poolId = DataSourceManager.getPoolId(url, user, password);
        if (DataSourceManager.has(poolId)) {
            Connection conn = null;
            try {
                conn = DataSourceManager.getPool(poolId).getConnection();
            }
            catch (Exception e) {
                DataSourceManager.getPool(poolId).close();
                DataSourceManager.clearOnly(poolId);
                throw e;
            }
            return conn;
        }
        DataSource pool = DataSourceFactory.create(url, user, password);
        Connection conn = null;
        try {
            conn = pool.getConnection();
        }
        catch (Exception e) {
            pool.close();
            throw e;
        }
        DataSourceManager.putCache(poolId, pool);
        return conn;
    }

    private static String getPoolId(String url, String user, String password) {
        return url + "@" + user + "/" + password;
    }

    private static String[] parsePoolId(String poolId) {
        if (poolId == null || "".equals(poolId)) {
            return null;
        }
        String[] paras = poolId.split("@");
        if (paras.length <= 1) {
            return null;
        }
        String[] result = new String[3];
        result[0] = paras[0];
        String[] up = paras[1].split("/");
        if (up.length <= 1) {
            return null;
        }
        result[1] = up[0];
        result[2] = up[1];
        return result;
    }

    public static boolean has(String key) {
        return pools.containsKey(key);
    }

    public static void clearAll() {
        pools.clear();
    }

    public static synchronized void clearAll(String type) {
        Iterator<Map.Entry<String, DataSource>> i = pools.entrySet().iterator();
        ArrayList<String> arr = new ArrayList<String>();
        try {
            while (i.hasNext()) {
                Map.Entry<String, DataSource> entry = i.next();
                String key = entry.getKey();
                if (!key.startsWith(type)) continue;
                arr.add(key);
            }
            for (int k = 0; k < arr.size(); ++k) {
                DataSourceManager.clearOnly((String)arr.get(k));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized void clearOnly(String key) {
        pools.remove(key);
    }

    public static synchronized void putCache(String key, DataSource obj) {
        pools.put(key, obj);
    }

    public static DataSource getCacheInfo(String key) {
        if (DataSourceManager.has(key)) {
            DataSource poor = DataSourceManager.getPool(key);
            if (DataSourceManager.cacheExpired(poor)) {
                poor.setExpired(true);
            }
            return poor;
        }
        return null;
    }

    public static void putCacheInfo(String key, DataSource obj) {
        pools.put(key, obj);
    }

    public static boolean cacheExpired(DataSource poor) {
        if (null == poor) {
            return false;
        }
        long nowDt = System.currentTimeMillis();
        long cacheDt = poor.getUpdateTime() + EXPIRED_TIMEOUT;
        return cacheDt > 0L && cacheDt <= nowDt;
    }

    public static int getCacheSize() {
        return pools.size();
    }

    public static int getCacheSize(String type) {
        int k = 0;
        Iterator<Map.Entry<String, DataSource>> i = pools.entrySet().iterator();
        try {
            while (i.hasNext()) {
                Map.Entry<String, DataSource> entry = i.next();
                String key = entry.getKey();
                if (key.indexOf(type) == -1) continue;
                ++k;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return k;
    }

    public static ArrayList getCacheAllkey() {
        ArrayList<String> a = new ArrayList<String>();
        try {
            for (Map.Entry<String, DataSource> entry : pools.entrySet()) {
                a.add(entry.getKey());
            }
        }
        catch (Exception exception) {}
        finally {
            return a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getCacheListkey(String type) {
        ArrayList<String> a = new ArrayList<String>();
        try {
            for (Map.Entry<String, DataSource> entry : pools.entrySet()) {
                String key = entry.getKey();
                if (key.indexOf(type) == -1) continue;
                a.add(key);
            }
        }
        catch (Exception exception) {}
        finally {
            return a;
        }
    }

    static {
        DataSourceManager.init();
    }
}

