/*
 * Decompiled with CFR 0.152.
 */
package org.rythmengine.internal.parser.build_in;

import com.stevesoft.pat.Regex;
import org.rythmengine.internal.IContext;
import org.rythmengine.internal.IParser;
import org.rythmengine.internal.Keyword;
import org.rythmengine.internal.Token;
import org.rythmengine.internal.parser.CodeToken;
import org.rythmengine.internal.parser.IRemoveLeadingLineBreakAndSpaces;
import org.rythmengine.internal.parser.ParserBase;
import org.rythmengine.internal.parser.build_in.KeywordParserFactory;
import org.rythmengine.utils.TextBuilder;

public class DebugParser
extends KeywordParserFactory
implements IRemoveLeadingLineBreakAndSpaces {
    @Override
    public Keyword keyword() {
        return Keyword.DEBUG;
    }

    @Override
    public IParser create(final IContext ctx) {
        return new ParserBase(ctx){

            @Override
            public Token go() {
                Regex r0;
                Regex r = DebugParser.this.reg(this.dialect());
                if (!r.search(this.remain())) {
                    this.raiseParseException("error parsing @debug, correct usage: @debug(\"msg\", args...)", new Object[0]);
                }
                String matched = r.stringMatched();
                this.step(matched.length());
                boolean leadLB = matched.startsWith("\n");
                boolean afterLB = matched.endsWith("\n");
                if (leadLB || afterLB) {
                    String blank;
                    ctx.getCodeBuilder().addBuilder(new Token.StringToken("\n", ctx));
                    if (!(leadLB && afterLB || !(r0 = new Regex("\\n([ \\t\\x0B\\f]*).*")).search(matched) || (blank = r0.stringMatched(1)).length() <= 0)) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                } else {
                    String blank;
                    r0 = new Regex("([ \\t\\x0B\\f]*).*");
                    if (r0.search(matched) && (blank = r0.stringMatched(1)).length() > 0) {
                        ctx.getCodeBuilder().addBuilder(new Token.StringToken(blank, ctx));
                    }
                }
                String s = new TextBuilder().p("__logger.debug").p(r.stringMatched(2)).p(";").toString();
                return new CodeToken(s, this.ctx());
            }
        };
    }

    @Override
    protected String patternStr() {
        return "(^\\n?[ \\t\\x0B\\f]*%s%s\\s*((?@()))[\\n]?)";
    }
}

