/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.util;

import java.io.Serializable;
import java.util.Locale;
import sbt.internal.util.ScalaKeywords$;
import sbt.internal.util.Types$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class Util$ {
    public static final Util$ MODULE$ = new Util$();
    private static Regex Hyphen;
    private static Regex Camel;
    private static boolean isMac;
    private static boolean isWindows;
    private static boolean isCygwin;
    private static boolean isNonCygwinWindows;
    private static boolean isCygwinWindows;
    private static boolean isEmacs;
    private static volatile byte bitmap$0;

    public <T> List<T> makeList(int size, T value) {
        return (List)package$.MODULE$.List().fill(size, (Function0 & Serializable)() -> value);
    }

    public <A, B> Tuple2<Seq<A>, Seq<B>> separateE(Seq<Either<A, B>> ps) {
        return this.separate(ps, Types$.MODULE$.idFun());
    }

    public <T, A, B> Tuple2<Seq<A>, Seq<B>> separate(Seq<T> ps, Function1<T, Either<A, B>> f) {
        Tuple2 tuple2 = (Tuple2)ps.foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$), (Function2 & Serializable)(xs, y) -> MODULE$.prependEither((Tuple2)xs, (Either)((Either)f.apply(y))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq a = (Seq)tuple2._1();
        Seq b = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)a, (Object)b);
        Seq a2 = (Seq)tuple22._1();
        Seq b2 = (Seq)tuple22._2();
        return new Tuple2(a2.reverse(), b2.reverse());
    }

    public <A, B> Tuple2<Seq<A>, Seq<B>> prependEither(Tuple2<Seq<A>, Seq<B>> acc, Either<A, B> next) {
        Either<A, B> either = next;
        if (either instanceof Left) {
            Object l;
            Left left = (Left)either;
            Object object = l = left.value();
            return new Tuple2(((SeqOps)acc._1()).$plus$colon(object), acc._2());
        }
        if (either instanceof Right) {
            Object r;
            Right right = (Right)either;
            Object object = r = right.value();
            return new Tuple2(acc._1(), ((SeqOps)acc._2()).$plus$colon(object));
        }
        throw new MatchError(either);
    }

    public <A, B> Function2<A, B, Tuple2<A, B>> pairID() {
        return (Function2 & Serializable)(a, b) -> new Tuple2(a, b);
    }

    private Regex Hyphen$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                Hyphen = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("-(\\p{javaLowerCase})"));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return Hyphen;
    }

    private Regex Hyphen() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.Hyphen$lzycompute();
        }
        return Hyphen;
    }

    public boolean hasHyphen(String s) {
        return s.indexOf(45) >= 0;
    }

    public String hyphenToCamel(String s) {
        if (this.hasHyphen(s)) {
            return this.Hyphen().replaceAllIn((CharSequence)s, (Function1 & Serializable)x$2 -> x$2.group(1).toUpperCase(Locale.ENGLISH));
        }
        return s;
    }

    private Regex Camel$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                Camel = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\p{javaLowerCase})(\\p{javaUpperCase})"));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return Camel;
    }

    private Regex Camel() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.Camel$lzycompute();
        }
        return Camel;
    }

    public String camelToHyphen(String s) {
        return this.Camel().replaceAllIn((CharSequence)s, (Function1 & Serializable)m -> new StringBuilder(1).append(m.group(1)).append("-").append(m.group(2).toLowerCase(Locale.ENGLISH)).toString());
    }

    public String quoteIfKeyword(String s) {
        if (ScalaKeywords$.MODULE$.values().apply((Object)s)) {
            return new StringBuilder(2).append("`").append(s).append("`").toString();
        }
        return s;
    }

    private boolean isMac$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                isMac = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("mac");
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return isMac;
    }

    public boolean isMac() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.isMac$lzycompute();
        }
        return isMac;
    }

    private boolean isWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return isWindows;
    }

    public boolean isWindows() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.isWindows$lzycompute();
        }
        return isWindows;
    }

    private boolean isCygwin$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                boolean bl;
                Option os = scala.sys.package$.MODULE$.env().get((Object)"OSTYPE");
                Option option = os;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String x = (String)some.value();
                    bl = x.toLowerCase(Locale.ENGLISH).contains("cygwin");
                } else {
                    bl = false;
                }
                isCygwin = bl;
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return isCygwin;
    }

    public boolean isCygwin() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.isCygwin$lzycompute();
        }
        return isCygwin;
    }

    private boolean isNonCygwinWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                isNonCygwinWindows = this.isWindows() && !this.isCygwin();
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return isNonCygwinWindows;
    }

    public boolean isNonCygwinWindows() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.isNonCygwinWindows$lzycompute();
        }
        return isNonCygwinWindows;
    }

    private boolean isCygwinWindows$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 0x40) == 0) {
                isCygwinWindows = this.isWindows() && this.isCygwin();
                bitmap$0 = (byte)(bitmap$0 | 0x40);
            }
        }
        return isCygwinWindows;
    }

    public boolean isCygwinWindows() {
        if ((byte)(bitmap$0 & 0x40) == 0) {
            return this.isCygwinWindows$lzycompute();
        }
        return isCygwinWindows;
    }

    private boolean isEmacs$lzycompute() {
        Util$ util$ = this;
        synchronized (util$) {
            if ((byte)(bitmap$0 & 0x80) == 0) {
                isEmacs = scala.sys.package$.MODULE$.env().contains((Object)"INSIDE_EMACS");
                bitmap$0 = (byte)(bitmap$0 | 0x80);
            }
        }
        return isEmacs;
    }

    public boolean isEmacs() {
        if ((byte)(bitmap$0 & 0x80) == 0) {
            return this.isEmacs$lzycompute();
        }
        return isEmacs;
    }

    public <A> List<A> nil() {
        return package$.MODULE$.List().empty();
    }

    public <A> Seq<A> nilSeq() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public <A> Option<A> none() {
        return None$.MODULE$;
    }

    public <A> A AnyOps(A value) {
        return value;
    }

    private Util$() {
    }
}

