/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.nio;

import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import sbt.internal.nio.Deadline;
import sbt.internal.nio.Deadline$;
import sbt.internal.nio.Deadline$Inf$;
import sbt.internal.nio.FileCache;
import sbt.internal.nio.FileEvent;
import sbt.internal.nio.PollingWatchEvent;
import sbt.internal.nio.PollingWatchService$Overflow$;
import sbt.internal.nio.TimeSource;
import sbt.internal.nio.TimeSource$default$;
import sbt.io.IO$;
import sbt.io.Unregisterable;
import sbt.io.WatchService;
import sbt.nio.file.AnyPath$;
import sbt.nio.file.Glob;
import sbt.nio.file.Glob$;
import sbt.nio.file.RelativeGlob;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t-d!\u0002\u0017.\u0001E\u001a\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u00115\u0003!\u0011!Q\u0001\n9CQA\u0015\u0001\u0005\u0002MCQA\u0015\u0001\u0005\u0002]Ca!\u0017\u0001!\n\u0017Q\u0006BB.\u0001A\u0003%A\f\u0003\u0004h\u0001\u0001\u0006I\u0001\u001b\u0005\t\u00033\u0004\u0001\u0015!\u0003\u0002\\\"A\u0011\u0011\u001d\u0001!\u0002\u0013\t\u0019\u000f\u0003\u0005\u0002j\u0002\u0001\u000b\u0011BAv\u0011\u001d\t)\u0010\u0001C!\u0003oBq!a>\u0001\t\u0003\n9\bC\u0004\u0002z\u0002!\t%a?\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!9\u00111\u0011\u0001\u0005B\t%\u0002b\u0002B&\u0001\u0011\u0005#Q\n\u0005\b\u0005'\u0002A\u0011\tB+\u0011\u001d\u0011I\u0006\u0001C\u0005\u0003o:qAa\u0017\u0001\u0011\u0013\u0011iFB\u0004\u0003`\u0001AIA!\u0019\t\rI#B\u0011\u0001B5\r\u0011A\b\u0001B=\t\u0015\u0005\u001daC!B\u0001B\u0003%q\u000e\u0003\u0006\u0002\nY\u0011\t\u0011)A\u0005\u0003\u0017AaA\u0015\f\u0005\u0002\u0005}\u0001\u0002CA\u0014-\u0001\u0006I!!\u000b\t\u000f\u0005ub\u0003)A\u00059\"Q\u0011q\b\f\t\u0006\u0004&I!!\u0011\t\u0015\u0005%c\u0003#b!\n\u0013\t\t\u0005\u0003\u0006\u0002LYA)\u0019)C\u0005\u0003\u0003B\u0001\"!\u0014\u0017A\u0003%\u0011q\n\u0005\t\u000372\u0002\u0015!\u0003\u0002^!A\u00111\r\f!\n\u0013\t)\u0007\u0003\u0005\u0002nY\u0001\u000b\u0011BA8\u0011\u001d\t)H\u0006C!\u0003oBq!a \u0017\t\u0003\n\t\tC\u0004\u0002\u0004Z!\t%!\"\t\u000f\u00055f\u0003\"\u0011\u0002\u0002\"9\u0011q\u0016\f\u0005B\u0005E\u0006\u0002DA]-\t\u0015)\u0019!C\u0001\u0001\u0005m\u0006\u0002DA_-\t\u0005\t\u0011!C\u0001\u0001\u0005}\u0006\u0002DAd-\t\u0005\t\u0011!C\u0001\u0001\u0005%\u0007\u0002DAh-\t\u0005\t\u0011!C\u0001\u0001\u0005E'a\u0005)pY2LgnZ,bi\u000eD7+\u001a:wS\u000e,'B\u0001\u00180\u0003\rq\u0017n\u001c\u0006\u0003aE\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002e\u0005\u00191O\u0019;\u0014\t\u0001!$\b\u0011\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\n\u0014AA5p\u0013\tyDH\u0001\u0007XCR\u001c\u0007nU3sm&\u001cW\r\u0005\u0002<\u0003&\u0011!\t\u0010\u0002\u000f+:\u0014XmZ5ti\u0016\u0014\u0018M\u00197f\u0003\u0015!W\r\\1z\u0007\u0001\u0001\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u0011\u0011,(/\u0019;j_:T!A\u0013\u001c\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002M\u000f\nqa)\u001b8ji\u0016$UO]1uS>t\u0017A\u0003;j[\u0016\u001cv.\u001e:dKB\u0011q\nU\u0007\u0002[%\u0011\u0011+\f\u0002\u000b)&lWmU8ve\u000e,\u0017A\u0002\u001fj]&$h\bF\u0002U+Z\u0003\"a\u0014\u0001\t\u000b\r\u001b\u0001\u0019A#\t\u000b5\u001b\u0001\u0019\u0001(\u0015\u0005QC\u0006\"B\"\u0005\u0001\u0004)\u0015A\u0001;t+\u0005q\u0015AB2m_N,G\r\u0005\u0002^K6\taL\u0003\u0002`A\u00061\u0011\r^8nS\u000eT!AS1\u000b\u0005\t\u001c\u0017\u0001B;uS2T\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002g=\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f!B]3hSN$XM]3e!\u0011IWn\u001c<\u000e\u0003)T!AS6\u000b\u000514\u0014AC2pY2,7\r^5p]&\u0011aN\u001b\u0002\u0004\u001b\u0006\u0004\bC\u00019u\u001b\u0005\t(B\u0001:t\u0003\u00111\u0017\u000e\\3\u000b\u00059\u001a\u0017BA;r\u0005\u0011\u0001\u0016\r\u001e5\u0011\u0005]4R\"\u0001\u0001\u0003\u001fA{G\u000e\\5oO^\u000bGo\u00195LKf\u001cBA\u0006>\u0002\u0002A\u00111P`\u0007\u0002y*\u0011QpY\u0001\u0005Y\u0006tw-\u0003\u0002\u0000y\n1qJ\u00196fGR\u00042\u0001]A\u0002\u0013\r\t)!\u001d\u0002\t/\u0006$8\r[&fs\u0006Y3O\u0019;%S:$XM\u001d8bY\u0012r\u0017n\u001c\u0013Q_2d\u0017N\\4XCR\u001c\u0007nU3sm&\u001cW\r\n\u0013qCRD\u0007%\u0001\u0006fm\u0016tGoS5oIN\u0004R!NA\u0007\u0003#I1!a\u00047\u0005)a$/\u001a9fCR,GM\u0010\t\u0006\u0003'\tIb\u001c\b\u0004a\u0006U\u0011bAA\fc\u0006Qq+\u0019;dQ\u00163XM\u001c;\n\t\u0005m\u0011Q\u0004\u0002\u0005\u0017&tGMC\u0002\u0002\u0018E$RA^A\u0011\u0003KAa!a\t\u001a\u0001\u0004y\u0017\u0001\u00029bi\"Dq!!\u0003\u001a\u0001\u0004\tY!\u0001\u0004fm\u0016tGo\u001d\t\u0007\u0003W\ti#!\r\u000e\u0003\u0001L1!a\fa\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0011\u000b=\u000b\u0019$a\u000e\n\u0007\u0005URFA\u0005GS2,WI^3oiB\u0019Q'!\u000f\n\u0007\u0005mbG\u0001\u0003M_:<\u0017a\u00035bg>3XM\u001d4m_^\fA\"Y2dKB$8I]3bi\u0016,\"!a\u0011\u0011\u0007U\n)%C\u0002\u0002HY\u0012qAQ8pY\u0016\fg.\u0001\u0007bG\u000e,\u0007\u000f\u001e#fY\u0016$X-\u0001\u0007bG\u000e,\u0007\u000f^'pI&4\u00170\u0001\u0003hY>\u0014\u0007\u0003BA)\u0003/j!!a\u0015\u000b\u0007I\f)F\u0003\u0002/c%!\u0011\u0011LA*\u0005\u00119En\u001c2\u0002\u0013\u0019LG.Z\"bG\",\u0007#B(\u0002`\u0005]\u0012bAA1[\tIa)\u001b7f\u0007\u0006\u001c\u0007.Z\u0001\r]\u0016DH\u000fU8mYRKW.Z\u000b\u0003\u0003O\u00022aTA5\u0013\r\tY'\f\u0002\t\t\u0016\fG\r\\5oK\u0006QA.Y:u!>dG.\u001a3\u0011\u000bu\u000b\t(a\u001a\n\u0007\u0005MdLA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f\u0003\u0019\u0019\u0017M\\2fYR\u0011\u0011\u0011\u0010\t\u0004k\u0005m\u0014bAA?m\t!QK\\5u\u0003\u001dI7OV1mS\u0012$\"!a\u0011\u0002\u0015A|G\u000e\\#wK:$8\u000f\u0006\u0002\u0002\bB1\u0011\u0011RAF\u0003\u001fk\u0011!Y\u0005\u0004\u0003\u001b\u000b'\u0001\u0002'jgR\u0004D!!%\u0002\u001cB)\u0001/a%\u0002\u0018&\u0019\u0011QS9\u0003\u0015]\u000bGo\u00195Fm\u0016tG\u000f\u0005\u0003\u0002\u001a\u0006mE\u0002\u0001\u0003\f\u0003;+\u0013\u0011!A\u0001\u0006\u0003\tyJ\u0001\u0005%c6\f'o\u001b\u00132#\u0011\t\t+a*\u0011\u0007U\n\u0019+C\u0002\u0002&Z\u0012qAT8uQ&tw\rE\u00026\u0003SK1!a+7\u0005\r\te._\u0001\u0006e\u0016\u001cX\r^\u0001\no\u0006$8\r[1cY\u0016$\"!a-\u0011\u0007A\f),C\u0002\u00028F\u0014\u0011bV1uG\"\f'\r\\3\u0002UM\u0014G\u000fJ5oi\u0016\u0014h.\u00197%]&|G\u0005U8mY&twmV1uG\"\u001cVM\u001d<jG\u0016$C\u0005]1uQV\tq.\u0001\u0016tER$\u0013N\u001c;fe:\fG\u000e\n8j_\u0012\u0002v\u000e\u001c7j]\u001e<\u0016\r^2i'\u0016\u0014h/[2fI\u0011\u0002x\u000e\u001c7\u0015\u0005\u0005\u0005\u0007#B\u001b\u0002D\u0006\u0005\u0011bAAcm\t1q\n\u001d;j_:\fAg\u001d2uI%tG/\u001a:oC2$c.[8%!>dG.\u001b8h/\u0006$8\r[*feZL7-\u001a\u0013%a>dG.\u0012<f]R\u001c\u0018*\u001c9m+\t\tY\r\u0005\u0004\u0002\n\u0006-\u0015Q\u001a\t\u0005a\u0006Mu.A\u001atER$\u0013N\u001c;fe:\fG\u000e\n8j_\u0012\u0002v\u000e\u001c7j]\u001e<\u0016\r^2i'\u0016\u0014h/[2fI\u0011j\u0017-\u001f2f\u0003\u0012$WI^3oiR!\u00111[Ak!\u0011)\u00141\u0019<\t\u000f\u0005]7\u00061\u0001\u00022\u0005)QM^3oi\u0006)B.Y:u\u001b>$\u0017NZ5fI\u000e{gN^3si\u0016\u0014\bCB\u001b\u0002^>\f9$C\u0002\u0002`Z\u0012\u0011BR;oGRLwN\\\u0019\u0002\u0013A|G\u000e\\)vKV,\u0007#BAE\u0003K4\u0018bAAtC\n)\u0011+^3vK\u00061!/\u00198e_6\u0004B!!<\u0002r6\u0011\u0011q\u001e\u0006\u0003EZJA!a=\u0002p\n1!+\u00198e_6\fQa\u00197pg\u0016\fA!\u001b8ji\u0006!\u0001o\u001c7m)\u0011\t\t!!@\t\u000f\u0005}X\u00021\u0001\u0003\u0002\u00059A/[7f_V$\bc\u0001$\u0003\u0004%\u0019!QA$\u0003\u0011\u0011+(/\u0019;j_:\f\u0001\u0002]8mY&k\u0007\u000f\u001c\u000b\t\u0003\u0003\u0014YA!\u0006\u0003\u0018!9!Q\u0002\bA\u0002\t=\u0011!\u00032bi\u000eD7+\u001b>f!\r)$\u0011C\u0005\u0004\u0005'1$aA%oi\")\u0001J\u0004a\u0001\u000b\"9!\u0011\u0004\bA\u0002\u0005\u001d\u0014\u0001\u00033fC\u0012d\u0017N\\3)\u00079\u0011i\u0002\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\r\u0011\u0019CN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0014\u0005C\u0011q\u0001^1jYJ,7\r\u0006\u0002\u0003,AA!Q\u0006B\u001e\u0003\u0003\u0011yD\u0004\u0003\u00030\t]\u0002c\u0001B\u0019m5\u0011!1\u0007\u0006\u0004\u0005k!\u0015A\u0002\u001fs_>$h(C\u0002\u0003:Y\na\u0001\u0015:fI\u00164\u0017b\u00018\u0003>)\u0019!\u0011\b\u001c\u0011\r\t\u0005#qIAg\u001b\t\u0011\u0019EC\u0002\u0003F-\f\u0011\"[7nkR\f'\r\\3\n\t\t%#1\t\u0002\u0004'\u0016\f\u0018\u0001\u0003:fO&\u001cH/\u001a:\u0015\r\u0005\u0005!q\nB)\u0011\u0019\t\u0019\u0003\u0005a\u0001_\"9\u0011q\u0005\tA\u0002\u0005-\u0011AC;oe\u0016<\u0017n\u001d;feR!\u0011\u0011\u0010B,\u0011\u0019\t\u0019#\u0005a\u0001_\u0006yQM\\:ve\u0016tu\u000e^\"m_N,G-\u0001\u0005Pm\u0016\u0014h\r\\8x!\t9HC\u0001\u0005Pm\u0016\u0014h\r\\8x'\r!\"1\r\t\u0004\u001f\n\u0015\u0014b\u0001B4[\t\t\u0002k\u001c7mS:<w+\u0019;dQ\u00163XM\u001c;\u0015\u0005\tu\u0003")
public class PollingWatchService
implements WatchService,
Unregisterable {
    private volatile PollingWatchService$Overflow$ Overflow$module;
    public final FiniteDuration sbt$internal$nio$PollingWatchService$$delay;
    private final TimeSource timeSource;
    private final AtomicBoolean closed;
    public final scala.collection.concurrent.Map<Path, PollingWatchKey> sbt$internal$nio$PollingWatchService$$registered;
    public final Function1<Path, Object> sbt$internal$nio$PollingWatchService$$lastModifiedConverter;
    private final Queue<PollingWatchKey> pollQueue;
    public final Random sbt$internal$nio$PollingWatchService$$random;

    public PollingWatchService$Overflow$ sbt$internal$nio$PollingWatchService$$Overflow() {
        if (this.Overflow$module == null) {
            this.Overflow$lzycompute$1();
        }
        return this.Overflow$module;
    }

    public TimeSource sbt$internal$nio$PollingWatchService$$ts() {
        return this.timeSource;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.sbt$internal$nio$PollingWatchService$$registered.clear();
            return;
        }
    }

    @Override
    public void init() {
        this.ensureNotClosed();
    }

    @Override
    public WatchKey poll(Duration timeout) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        this.ensureNotClosed();
        int numKeys = this.pollQueue.size();
        Duration duration = timeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)finiteDuration), (Object)Deadline$.MODULE$.now(this.sbt$internal$nio$PollingWatchService$$ts()).$plus(finiteDuration));
        } else {
            tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package.IntMult$.MODULE$.$times$extension1(package$.MODULE$.IntMult(numKeys), new package.DurationInt(package$.MODULE$.DurationInt(2)).millis())), (Object)Deadline$Inf$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FiniteDuration adjustedTimeout = (FiniteDuration)tuple2._1();
        Deadline deadline = (Deadline)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)adjustedTimeout, (Object)deadline);
        FiniteDuration adjustedTimeout2 = (FiniteDuration)tuple23._1();
        Deadline deadline2 = (Deadline)tuple23._2();
        long millis = adjustedTimeout2.toMillis();
        Tuple2 tuple24 = (Tuple2)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), Integer.MAX_VALUE).dropWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> millis * (long)i / (long)numKeys == 0L).headOption().fold((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new package.DurationInt(package$.MODULE$.DurationInt(1)).millis()), (Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))), (Object)adjustedTimeout2.$div((long)BoxesRunTime.unboxToInt((Object)i))));
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        int batchSize = tuple24._1$mcI$sp();
        FiniteDuration batchTimeout = (FiniteDuration)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)batchSize), (Object)batchTimeout);
        int batchSize2 = tuple25._1$mcI$sp();
        FiniteDuration batchTimeout2 = (FiniteDuration)tuple25._2();
        return (WatchKey)this.pollImpl(batchSize2, batchTimeout2, deadline2).orNull(Predef$.MODULE$.$conforms());
    }

    private Option<WatchKey> pollImpl(int batchSize, FiniteDuration duration, Deadline deadline) {
        while (true) {
            PollingWatchKey pollingWatchKey;
            if ((pollingWatchKey = this.pollQueue.poll()) == null) {
                return None$.MODULE$;
            }
            this.pollQueue.add(pollingWatchKey);
            Option<WatchKey> option = pollingWatchKey.sbt$internal$nio$PollingWatchService$$poll();
            if (option.isDefined()) {
                return option;
            }
            if (batchSize > 1) {
                --batchSize;
                continue;
            }
            if (deadline.isOverdue()) break;
            Thread.sleep(duration.toMillis());
        }
        return None$.MODULE$;
    }

    @Override
    public Map<WatchKey, scala.collection.immutable.Seq<WatchEvent<Path>>> pollEvents() {
        this.ensureNotClosed();
        return ((TraversableOnce)this.sbt$internal$nio$PollingWatchService$$registered.values().map((Function1 & Serializable & scala.Serializable)k -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), (Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(k.sbt$internal$nio$PollingWatchService$$pollEventsImpl()).asScala()).toVector()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public WatchKey register(Path path, Seq<WatchEvent.Kind<Path>> events) {
        this.ensureNotClosed();
        Option option = this.sbt$internal$nio$PollingWatchService$$registered.get((Object)path);
        if (option instanceof Some) {
            Some some = (Some)option;
            PollingWatchKey k = (PollingWatchKey)some.value();
            return k;
        }
        if (None$.MODULE$.equals(option)) {
            PollingWatchKey newKey = new PollingWatchKey(this, path, events);
            this.sbt$internal$nio$PollingWatchService$$registered.put((Object)path, (Object)newKey);
            this.pollQueue.add(newKey);
            return newKey;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void unregister(Path path) {
        this.ensureNotClosed();
        this.sbt$internal$nio$PollingWatchService$$registered.remove((Object)path);
        this.pollQueue.removeIf(x$3 -> {
            Path path = x$3.sbt$internal$nio$PollingWatchService$$path();
            Path path2 = path;
            return !(path != null ? !((Object)path).equals(path2) : path2 != null);
        });
    }

    private void ensureNotClosed() {
        if (this.closed.get()) {
            throw new ClosedWatchServiceException();
        }
    }

    private final void Overflow$lzycompute$1() {
        PollingWatchService pollingWatchService = this;
        synchronized (pollingWatchService) {
            if (this.Overflow$module == null) {
                this.Overflow$module = new PollingWatchService$Overflow$(this);
            }
        }
    }

    public PollingWatchService(FiniteDuration delay, TimeSource timeSource) {
        this.sbt$internal$nio$PollingWatchService$$delay = delay;
        this.timeSource = timeSource;
        this.closed = new AtomicBoolean(false);
        this.sbt$internal$nio$PollingWatchService$$registered = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.sbt$internal$nio$PollingWatchService$$lastModifiedConverter = (Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)IO$.MODULE$.getModifiedTimeOrZero(p.toFile()));
        this.pollQueue = new LinkedBlockingDeque<PollingWatchKey>();
        this.sbt$internal$nio$PollingWatchService$$random = new Random();
    }

    public PollingWatchService(FiniteDuration delay) {
        this(delay, TimeSource$default$.MODULE$);
    }

    private class PollingWatchKey
    implements WatchKey {
        private boolean acceptCreate;
        private boolean acceptDelete;
        private boolean acceptModify;
        private final Path sbt$internal$nio$PollingWatchService$$path;
        private final Seq<WatchEvent.Kind<Path>> eventKinds;
        private final ArrayBlockingQueue<FileEvent<Object>> events;
        private final AtomicBoolean hasOverflow;
        private final Glob glob;
        private final FileCache<Object> fileCache;
        private final AtomicReference<Deadline> lastPolled;
        private volatile byte bitmap$0;
        public final /* synthetic */ PollingWatchService $outer;

        public Path sbt$internal$nio$PollingWatchService$$path() {
            return this.sbt$internal$nio$PollingWatchService$$path;
        }

        private boolean acceptCreate$lzycompute() {
            PollingWatchKey pollingWatchKey = this;
            synchronized (pollingWatchKey) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.acceptCreate = this.eventKinds.contains(StandardWatchEventKinds.ENTRY_CREATE);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.acceptCreate;
        }

        private boolean acceptCreate() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.acceptCreate$lzycompute();
            }
            return this.acceptCreate;
        }

        private boolean acceptDelete$lzycompute() {
            PollingWatchKey pollingWatchKey = this;
            synchronized (pollingWatchKey) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.acceptDelete = this.eventKinds.contains(StandardWatchEventKinds.ENTRY_DELETE);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.acceptDelete;
        }

        private boolean acceptDelete() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.acceptDelete$lzycompute();
            }
            return this.acceptDelete;
        }

        private boolean acceptModify$lzycompute() {
            PollingWatchKey pollingWatchKey = this;
            synchronized (pollingWatchKey) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.acceptModify = this.eventKinds.contains(StandardWatchEventKinds.ENTRY_MODIFY);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.acceptModify;
        }

        private boolean acceptModify() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.acceptModify$lzycompute();
            }
            return this.acceptModify;
        }

        private Deadline nextPollTime() {
            return Deadline$.MODULE$.now(this.sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer().sbt$internal$nio$PollingWatchService$$ts()).$plus(new package.DurationInt(package$.MODULE$.DurationInt(this.sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer().sbt$internal$nio$PollingWatchService$$random.nextInt(2 * (int)this.sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer().sbt$internal$nio$PollingWatchService$$delay.toMillis()))).millis());
        }

        @Override
        public void cancel() {
            this.reset();
            this.sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer().sbt$internal$nio$PollingWatchService$$registered.remove((Object)this.sbt$internal$nio$PollingWatchService$$path());
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public List<WatchEvent<?>> pollEvents() {
            return this.sbt$internal$nio$PollingWatchService$$pollEventsImpl();
        }

        @Override
        public boolean reset() {
            boolean bl;
            ArrayBlockingQueue<FileEvent<Object>> arrayBlockingQueue = this.events;
            synchronized (arrayBlockingQueue) {
                this.events.clear();
                bl = true;
            }
            return bl;
        }

        @Override
        public Watchable watchable() {
            return this.sbt$internal$nio$PollingWatchService$$path();
        }

        public Option<WatchKey> sbt$internal$nio$PollingWatchService$$poll() {
            Deadline deadline = this.lastPolled.get();
            if (deadline.$less(Deadline$.MODULE$.now(this.sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer().sbt$internal$nio$PollingWatchService$$ts()))) {
                Seq<FileEvent<Object>> res = this.fileCache.refresh(this.glob);
                this.lastPolled.set(Deadline$.MODULE$.now(this.sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer().sbt$internal$nio$PollingWatchService$$ts()));
                res.foreach((Function1 & Serializable & scala.Serializable)event -> this.sbt$internal$nio$PollingWatchService$$maybeAddEvent((FileEvent<Object>)event));
                if (this.events.isEmpty()) {
                    return None$.MODULE$;
                }
                return new Some((Object)this);
            }
            return None$.MODULE$;
        }

        public List<WatchEvent<Path>> sbt$internal$nio$PollingWatchService$$pollEventsImpl() {
            ArrayList<WatchEvent<Path>> arrayList;
            ArrayBlockingQueue<FileEvent<Object>> arrayBlockingQueue = this.events;
            synchronized (arrayBlockingQueue) {
                boolean overflow = this.hasOverflow.getAndSet(false);
                int size = this.events.size() + (overflow ? 1 : 0);
                ArrayList rawEvents = new ArrayList(size);
                this.events.drainTo(rawEvents);
                ArrayList<WatchEvent<Path>> res = new ArrayList<WatchEvent<Path>>(size);
                res.addAll((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rawEvents).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    FileEvent fileEvent = x0$1;
                    if (fileEvent instanceof FileEvent.Creation) {
                        FileEvent.Creation creation = (FileEvent.Creation)fileEvent;
                        Path p = creation.path();
                        return new PollingWatchEvent(p, StandardWatchEventKinds.ENTRY_CREATE);
                    }
                    if (fileEvent instanceof FileEvent.Deletion) {
                        FileEvent.Deletion deletion = (FileEvent.Deletion)fileEvent;
                        Path p = deletion.path();
                        return new PollingWatchEvent(p, StandardWatchEventKinds.ENTRY_DELETE);
                    }
                    if (fileEvent instanceof FileEvent.Update) {
                        FileEvent.Update update = (FileEvent.Update)fileEvent;
                        Path p = update.path();
                        return new PollingWatchEvent(p, StandardWatchEventKinds.ENTRY_MODIFY);
                    }
                    throw new MatchError((Object)fileEvent);
                }, Buffer$.MODULE$.canBuildFrom())).asJava());
                Object object = overflow ? BoxesRunTime.boxToBoolean((boolean)res.add(this.sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer().sbt$internal$nio$PollingWatchService$$Overflow())) : BoxedUnit.UNIT;
                arrayList = res;
            }
            return arrayList;
        }

        public Option<PollingWatchKey> sbt$internal$nio$PollingWatchService$$maybeAddEvent(FileEvent<Object> event) {
            FileEvent<Object> fileEvent = event;
            if (fileEvent instanceof FileEvent.Creation && this.acceptCreate()) {
                return this.offer$1(event);
            }
            if (fileEvent instanceof FileEvent.Deletion && this.acceptDelete()) {
                return this.offer$1(event);
            }
            if (fileEvent instanceof FileEvent.Update && this.acceptModify()) {
                return this.offer$1(event);
            }
            return None$.MODULE$;
        }

        public /* synthetic */ PollingWatchService sbt$internal$nio$PollingWatchService$PollingWatchKey$$$outer() {
            return this.$outer;
        }

        private final Option offer$1(FileEvent event) {
            boolean bl;
            ArrayBlockingQueue<FileEvent<Object>> arrayBlockingQueue = this.events;
            synchronized (arrayBlockingQueue) {
                bl = this.events.offer(event);
            }
            if (!bl) {
                this.hasOverflow.set(true);
            }
            return new Some((Object)this);
        }

        public PollingWatchKey(PollingWatchService $outer, Path path, Seq<WatchEvent.Kind<Path>> eventKinds) {
            this.sbt$internal$nio$PollingWatchService$$path = path;
            this.eventKinds = eventKinds;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.events = new ArrayBlockingQueue(256);
            this.hasOverflow = new AtomicBoolean(false);
            this.glob = Glob$.MODULE$.apply(path, (RelativeGlob)AnyPath$.MODULE$);
            this.fileCache = new FileCache<Object>($outer.sbt$internal$nio$PollingWatchService$$lastModifiedConverter);
            this.fileCache.register(this.glob);
            this.lastPolled = new AtomicReference<Deadline>(this.nextPollTime());
        }
    }
}

