/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import sbt.internal.FullScalaLoader;
import sbt.internal.JLineLoader;
import sbt.internal.SbtInterfaceLoader;
import sbt.internal.ScalaLibraryClassLoader;
import xsbti.AppProvider;
import xsbti.ScalaProvider;

public final class MetaBuildLoader
extends URLClassLoader {
    private final URLClassLoader fullScalaLoader;
    private final URLClassLoader libraryLoader;
    private final URLClassLoader interfaceLoader;
    private final URLClassLoader jlineLoader;

    MetaBuildLoader(URL[] uRLArray, URLClassLoader uRLClassLoader, URLClassLoader uRLClassLoader2, URLClassLoader uRLClassLoader3, URLClassLoader uRLClassLoader4) {
        super(uRLArray, (ClassLoader)uRLClassLoader);
        this.fullScalaLoader = uRLClassLoader;
        this.libraryLoader = uRLClassLoader2;
        this.interfaceLoader = uRLClassLoader3;
        this.jlineLoader = uRLClassLoader4;
    }

    public String toString() {
        return "SbtMetaBuildClassLoader";
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fullScalaLoader.close();
        this.libraryLoader.close();
        this.interfaceLoader.close();
        this.jlineLoader.close();
    }

    public static MetaBuildLoader makeLoader(AppProvider appProvider) throws IOException {
        String string = String.format("^(%s|%s|%s|%s|%s|%s)\\.jar", "jline-?[0-9.]+-sbt-.*|jline-terminal(-(jna|jansi))?-[0-9.]+", "test-interface(-.*)?", "compiler-interface(-.*)?", "util-interface(-.*)?", "jansi-[0-9.]+", "jna-(platform-)?[0-9.]+");
        Pattern pattern = Pattern.compile(string);
        File[] fileArray = appProvider.mainClasspath();
        URL[] uRLArray2 = new URL[3];
        URL[] uRLArray3 = new URL[7];
        File[] fileArray2 = appProvider.id().classpathExtra() == null ? new File[]{} : appProvider.id().classpathExtra();
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        int n = 0;
        int n2 = 0;
        for (File file : fileArray) {
            String string2 = file.getName();
            if ((string2.contains("test-interface") || string2.contains("compiler-interface") || string2.contains("util-interface")) && pattern.matcher(string2).find()) {
                uRLArray2[n] = file.toURI().toURL();
                ++n;
                continue;
            }
            if (pattern.matcher(string2).find()) {
                uRLArray3[n2] = file.toURI().toURL();
                ++n2;
                continue;
            }
            linkedHashSet.add(file);
        }
        for (File file : fileArray2) {
            linkedHashSet.add(file);
        }
        URL[] uRLArray4 = new URL[linkedHashSet.size()];
        n2 = 0;
        for (File file : linkedHashSet) {
            uRLArray4[n2] = file.toURI().toURL();
            ++n2;
        }
        ScalaProvider scalaProvider = appProvider.scalaProvider();
        Object object = scalaProvider.launcher().topLoader();
        int n3 = 0;
        while (n3 == 0 && object != null) {
            if (object instanceof URLClassLoader) {
                for (URL uRLArray5 : ((URLClassLoader)object).getURLs()) {
                    if (!uRLArray5.toString().contains("test-interface")) continue;
                    object = ((ClassLoader)object).getParent();
                    n3 = 1;
                }
            }
            if (n3 != 0) continue;
            object = ((ClassLoader)object).getParent();
        }
        if (object == null) {
            object = scalaProvider.launcher().topLoader();
        }
        object = new ClassLoader((ClassLoader)object){

            @Override
            protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
                if (string.startsWith("org.fusesource")) {
                    throw new ClassNotFoundException(string);
                }
                return super.loadClass(string, bl);
            }

            public String toString() {
                return "JansiExclusionClassLoader";
            }
        };
        SbtInterfaceLoader sbtInterfaceLoader = new SbtInterfaceLoader(uRLArray2, (ClassLoader)object);
        JLineLoader jLineLoader = new JLineLoader(uRLArray3, (ClassLoader)sbtInterfaceLoader);
        File[] fileArray3 = scalaProvider.jars();
        URL[] uRLArray = new URL[1];
        int n4 = fileArray3.length - 1;
        for (File file : fileArray3) {
            if (!pattern.matcher(file.getName()).find()) continue;
            --n4;
        }
        Serializable[] serializableArray = new URL[Math.max(0, n4)];
        int fullScalaLoader = 0;
        for (int scalaLibraryClassLoader = 0; scalaLibraryClassLoader < fileArray3.length; ++scalaLibraryClassLoader) {
            File file;
            file = fileArray3[scalaLibraryClassLoader];
            if (file.getName().equals("scala-library.jar")) {
                uRLArray[0] = file.toURI().toURL();
                continue;
            }
            if (pattern.matcher(file.getName()).find()) continue;
            serializableArray[fullScalaLoader] = file.toURI().toURL();
            ++fullScalaLoader;
        }
        assert (uRLArray[0] != null) : "no scala-library.jar";
        ScalaLibraryClassLoader scalaLibraryClassLoader = new ScalaLibraryClassLoader(uRLArray, (ClassLoader)jLineLoader);
        FullScalaLoader fullScalaLoader2 = new FullScalaLoader((URL[])serializableArray, scalaLibraryClassLoader);
        return new MetaBuildLoader(uRLArray4, fullScalaLoader2, scalaLibraryClassLoader, sbtInterfaceLoader, jLineLoader);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

