/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.runtime.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v111.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;

public class PropertyDescriptor {
    private final String name;
    private final Optional<RemoteObject> value;
    private final Optional<Boolean> writable;
    private final Optional<RemoteObject> get;
    private final Optional<RemoteObject> set;
    private final Boolean configurable;
    private final Boolean enumerable;
    private final Optional<Boolean> wasThrown;
    private final Optional<Boolean> isOwn;
    private final Optional<RemoteObject> symbol;

    public PropertyDescriptor(String name, Optional<RemoteObject> value, Optional<Boolean> writable, Optional<RemoteObject> get, Optional<RemoteObject> set, Boolean configurable, Boolean enumerable, Optional<Boolean> wasThrown, Optional<Boolean> isOwn, Optional<RemoteObject> symbol) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = value;
        this.writable = writable;
        this.get = get;
        this.set = set;
        this.configurable = Objects.requireNonNull(configurable, "configurable is required");
        this.enumerable = Objects.requireNonNull(enumerable, "enumerable is required");
        this.wasThrown = wasThrown;
        this.isOwn = isOwn;
        this.symbol = symbol;
    }

    public String getName() {
        return this.name;
    }

    public Optional<RemoteObject> getValue() {
        return this.value;
    }

    public Optional<Boolean> getWritable() {
        return this.writable;
    }

    public Optional<RemoteObject> getGet() {
        return this.get;
    }

    public Optional<RemoteObject> getSet() {
        return this.set;
    }

    public Boolean getConfigurable() {
        return this.configurable;
    }

    public Boolean getEnumerable() {
        return this.enumerable;
    }

    public Optional<Boolean> getWasThrown() {
        return this.wasThrown;
    }

    public Optional<Boolean> getIsOwn() {
        return this.isOwn;
    }

    public Optional<RemoteObject> getSymbol() {
        return this.symbol;
    }

    private static PropertyDescriptor fromJson(JsonInput input) {
        String name = null;
        Optional<RemoteObject> value = Optional.empty();
        Optional<Boolean> writable = Optional.empty();
        Optional<RemoteObject> get = Optional.empty();
        Optional<RemoteObject> set = Optional.empty();
        Boolean configurable = false;
        Boolean enumerable = false;
        Optional<Boolean> wasThrown = Optional.empty();
        Optional<Boolean> isOwn = Optional.empty();
        Optional<RemoteObject> symbol = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block24;
                }
                case "value": {
                    value = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block24;
                }
                case "writable": {
                    writable = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "get": {
                    get = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block24;
                }
                case "set": {
                    set = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block24;
                }
                case "configurable": {
                    configurable = input.nextBoolean();
                    continue block24;
                }
                case "enumerable": {
                    enumerable = input.nextBoolean();
                    continue block24;
                }
                case "wasThrown": {
                    wasThrown = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "isOwn": {
                    isOwn = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "symbol": {
                    symbol = Optional.ofNullable((RemoteObject)input.read(RemoteObject.class));
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PropertyDescriptor(name, value, writable, get, set, configurable, enumerable, wasThrown, isOwn, symbol);
    }
}

