/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rabbit.stream.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.rabbit.stream.micrometer.RabbitStreamMessageSenderContext;
import org.springframework.rabbit.stream.micrometer.RabbitStreamTemplateObservationConvention;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RabbitStreamTemplateObservation implements ObservationDocumentation
{
    STREAM_TEMPLATE_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultRabbitStreamTemplateObservationConvention.class;
        }

        public String getPrefix() {
            return "spring.rabbit.stream.template";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return TemplateLowCardinalityTags.values();
        }
    };


    public static class DefaultRabbitStreamTemplateObservationConvention
    implements RabbitStreamTemplateObservationConvention {
        public static final DefaultRabbitStreamTemplateObservationConvention INSTANCE = new DefaultRabbitStreamTemplateObservationConvention();

        public KeyValues getLowCardinalityKeyValues(RabbitStreamMessageSenderContext context) {
            return KeyValues.of((String)TemplateLowCardinalityTags.BEAN_NAME.asString(), (String)context.getBeanName());
        }

        public String getContextualName(RabbitStreamMessageSenderContext context) {
            return context.getDestination() + " send";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemplateLowCardinalityTags implements KeyName
    {
        BEAN_NAME{

            public String asString() {
                return "spring.rabbit.stream.template.name";
            }
        };

    }
}

