/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.amqp.RabbitConnectionDetails;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;

class PropertiesRabbitConnectionDetails
implements RabbitConnectionDetails {
    private final RabbitProperties properties;

    PropertiesRabbitConnectionDetails(RabbitProperties properties) {
        this.properties = properties;
    }

    @Override
    public String getUsername() {
        return this.properties.determineUsername();
    }

    @Override
    public String getPassword() {
        return this.properties.determinePassword();
    }

    @Override
    public String getVirtualHost() {
        return this.properties.determineVirtualHost();
    }

    @Override
    public List<RabbitConnectionDetails.Address> getAddresses() {
        ArrayList<RabbitConnectionDetails.Address> addresses = new ArrayList<RabbitConnectionDetails.Address>();
        for (String address : this.properties.determineAddresses().split(",")) {
            int portSeparatorIndex = address.lastIndexOf(58);
            String host = address.substring(0, portSeparatorIndex);
            String port = address.substring(portSeparatorIndex + 1);
            addresses.add(new RabbitConnectionDetails.Address(host, Integer.parseInt(port)));
        }
        return addresses;
    }
}

